// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetAccessGrantResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the access grant.
     */
    public val accessGrantArn: kotlin.String? = builder.accessGrantArn
    /**
     * The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.
     */
    public val accessGrantId: kotlin.String? = builder.accessGrantId
    /**
     * The configuration options of the grant location. The grant location is the S3 path to the data to which you are granting access.
     */
    public val accessGrantsLocationConfiguration: aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration? = builder.accessGrantsLocationConfiguration
    /**
     * The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID `default` to the default location `s3://` and assigns an auto-generated ID to other locations that you register.
     */
    public val accessGrantsLocationId: kotlin.String? = builder.accessGrantsLocationId
    /**
     * The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data through this application.
     */
    public val applicationArn: kotlin.String? = builder.applicationArn
    /**
     * The date and time when you created the access grant.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The S3 path of the data to which you are granting access. It is the result of appending the `Subprefix` to the location scope.
     */
    public val grantScope: kotlin.String? = builder.grantScope
    /**
     * The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If you have added a corporate directory to Amazon Web Services IAM Identity Center and associated this Identity Center instance with the S3 Access Grants instance, the grantee can also be a corporate directory user or group.
     */
    public val grantee: aws.sdk.kotlin.services.s3control.model.Grantee? = builder.grantee
    /**
     * The type of permission that was granted in the access grant. Can be one of the following values:
     * + `READ` – Grant read-only access to the S3 data.
     * + `WRITE` – Grant write-only access to the S3 data.
     * + `READWRITE` – Grant both read and write access to the S3 data.
     */
    public val permission: aws.sdk.kotlin.services.s3control.model.Permission? = builder.permission

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.GetAccessGrantResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetAccessGrantResponse(")
        append("accessGrantArn=$accessGrantArn,")
        append("accessGrantId=$accessGrantId,")
        append("accessGrantsLocationConfiguration=$accessGrantsLocationConfiguration,")
        append("accessGrantsLocationId=$accessGrantsLocationId,")
        append("applicationArn=$applicationArn,")
        append("createdAt=$createdAt,")
        append("grantScope=$grantScope,")
        append("grantee=$grantee,")
        append("permission=$permission")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessGrantArn?.hashCode() ?: 0
        result = 31 * result + (accessGrantId?.hashCode() ?: 0)
        result = 31 * result + (accessGrantsLocationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (accessGrantsLocationId?.hashCode() ?: 0)
        result = 31 * result + (applicationArn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (grantScope?.hashCode() ?: 0)
        result = 31 * result + (grantee?.hashCode() ?: 0)
        result = 31 * result + (permission?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetAccessGrantResponse

        if (accessGrantArn != other.accessGrantArn) return false
        if (accessGrantId != other.accessGrantId) return false
        if (accessGrantsLocationConfiguration != other.accessGrantsLocationConfiguration) return false
        if (accessGrantsLocationId != other.accessGrantsLocationId) return false
        if (applicationArn != other.applicationArn) return false
        if (createdAt != other.createdAt) return false
        if (grantScope != other.grantScope) return false
        if (grantee != other.grantee) return false
        if (permission != other.permission) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.GetAccessGrantResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the access grant.
         */
        public var accessGrantArn: kotlin.String? = null
        /**
         * The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.
         */
        public var accessGrantId: kotlin.String? = null
        /**
         * The configuration options of the grant location. The grant location is the S3 path to the data to which you are granting access.
         */
        public var accessGrantsLocationConfiguration: aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration? = null
        /**
         * The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID `default` to the default location `s3://` and assigns an auto-generated ID to other locations that you register.
         */
        public var accessGrantsLocationId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data through this application.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * The date and time when you created the access grant.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The S3 path of the data to which you are granting access. It is the result of appending the `Subprefix` to the location scope.
         */
        public var grantScope: kotlin.String? = null
        /**
         * The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If you have added a corporate directory to Amazon Web Services IAM Identity Center and associated this Identity Center instance with the S3 Access Grants instance, the grantee can also be a corporate directory user or group.
         */
        public var grantee: aws.sdk.kotlin.services.s3control.model.Grantee? = null
        /**
         * The type of permission that was granted in the access grant. Can be one of the following values:
         * + `READ` – Grant read-only access to the S3 data.
         * + `WRITE` – Grant write-only access to the S3 data.
         * + `READWRITE` – Grant both read and write access to the S3 data.
         */
        public var permission: aws.sdk.kotlin.services.s3control.model.Permission? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.GetAccessGrantResponse) : this() {
            this.accessGrantArn = x.accessGrantArn
            this.accessGrantId = x.accessGrantId
            this.accessGrantsLocationConfiguration = x.accessGrantsLocationConfiguration
            this.accessGrantsLocationId = x.accessGrantsLocationId
            this.applicationArn = x.applicationArn
            this.createdAt = x.createdAt
            this.grantScope = x.grantScope
            this.grantee = x.grantee
            this.permission = x.permission
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.GetAccessGrantResponse = GetAccessGrantResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration] inside the given [block]
         */
        public fun accessGrantsLocationConfiguration(block: aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration.Builder.() -> kotlin.Unit) {
            this.accessGrantsLocationConfiguration = aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.Grantee] inside the given [block]
         */
        public fun grantee(block: aws.sdk.kotlin.services.s3control.model.Grantee.Builder.() -> kotlin.Unit) {
            this.grantee = aws.sdk.kotlin.services.s3control.model.Grantee.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
