// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * Specifies whether S3 on Outposts replicates delete markers. If you specify a `Filter` element in your replication configuration, you must also include a `DeleteMarkerReplication` element. If your `Filter` includes a `Tag` element, the `DeleteMarkerReplication` element's `Status` child element must be set to `Disabled`, because S3 on Outposts does not support replicating delete markers for tag-based rules.
 *
 * For more information about delete marker replication, see [How delete operations affect replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html#outposts-replication-what-is-replicated) in the *Amazon S3 User Guide*.
 */
public class DeleteMarkerReplication private constructor(builder: Builder) {
    /**
     * Indicates whether to replicate delete markers.
     */
    public val status: aws.sdk.kotlin.services.s3control.model.DeleteMarkerReplicationStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.DeleteMarkerReplication = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteMarkerReplication(")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = status.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteMarkerReplication

        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.DeleteMarkerReplication = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether to replicate delete markers.
         */
        public var status: aws.sdk.kotlin.services.s3control.model.DeleteMarkerReplicationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.DeleteMarkerReplication) : this() {
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.DeleteMarkerReplication = DeleteMarkerReplication(this)

        internal fun correctErrors(): Builder {
            if (status == null) status = DeleteMarkerReplicationStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
