// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * A container for the bucket-level configuration for Amazon S3 Storage Lens.
 *
 * For more information about S3 Storage Lens, see [Assessing your storage activity and usage with S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the *Amazon S3 User Guide*.
 */
public class BucketLevel private constructor(builder: Builder) {
    /**
     * A container for the bucket-level activity metrics for S3 Storage Lens.
     */
    public val activityMetrics: aws.sdk.kotlin.services.s3control.model.ActivityMetrics? = builder.activityMetrics
    /**
     * A container for bucket-level advanced cost-optimization metrics for S3 Storage Lens.
     */
    public val advancedCostOptimizationMetrics: aws.sdk.kotlin.services.s3control.model.AdvancedCostOptimizationMetrics? = builder.advancedCostOptimizationMetrics
    /**
     * A container for bucket-level advanced data-protection metrics for S3 Storage Lens.
     */
    public val advancedDataProtectionMetrics: aws.sdk.kotlin.services.s3control.model.AdvancedDataProtectionMetrics? = builder.advancedDataProtectionMetrics
    /**
     * A container for bucket-level detailed status code metrics for S3 Storage Lens.
     */
    public val detailedStatusCodesMetrics: aws.sdk.kotlin.services.s3control.model.DetailedStatusCodesMetrics? = builder.detailedStatusCodesMetrics
    /**
     * A container for the prefix-level metrics for S3 Storage Lens.
     */
    public val prefixLevel: aws.sdk.kotlin.services.s3control.model.PrefixLevel? = builder.prefixLevel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.BucketLevel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BucketLevel(")
        append("activityMetrics=$activityMetrics,")
        append("advancedCostOptimizationMetrics=$advancedCostOptimizationMetrics,")
        append("advancedDataProtectionMetrics=$advancedDataProtectionMetrics,")
        append("detailedStatusCodesMetrics=$detailedStatusCodesMetrics,")
        append("prefixLevel=$prefixLevel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityMetrics?.hashCode() ?: 0
        result = 31 * result + (advancedCostOptimizationMetrics?.hashCode() ?: 0)
        result = 31 * result + (advancedDataProtectionMetrics?.hashCode() ?: 0)
        result = 31 * result + (detailedStatusCodesMetrics?.hashCode() ?: 0)
        result = 31 * result + (prefixLevel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BucketLevel

        if (activityMetrics != other.activityMetrics) return false
        if (advancedCostOptimizationMetrics != other.advancedCostOptimizationMetrics) return false
        if (advancedDataProtectionMetrics != other.advancedDataProtectionMetrics) return false
        if (detailedStatusCodesMetrics != other.detailedStatusCodesMetrics) return false
        if (prefixLevel != other.prefixLevel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.BucketLevel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A container for the bucket-level activity metrics for S3 Storage Lens.
         */
        public var activityMetrics: aws.sdk.kotlin.services.s3control.model.ActivityMetrics? = null
        /**
         * A container for bucket-level advanced cost-optimization metrics for S3 Storage Lens.
         */
        public var advancedCostOptimizationMetrics: aws.sdk.kotlin.services.s3control.model.AdvancedCostOptimizationMetrics? = null
        /**
         * A container for bucket-level advanced data-protection metrics for S3 Storage Lens.
         */
        public var advancedDataProtectionMetrics: aws.sdk.kotlin.services.s3control.model.AdvancedDataProtectionMetrics? = null
        /**
         * A container for bucket-level detailed status code metrics for S3 Storage Lens.
         */
        public var detailedStatusCodesMetrics: aws.sdk.kotlin.services.s3control.model.DetailedStatusCodesMetrics? = null
        /**
         * A container for the prefix-level metrics for S3 Storage Lens.
         */
        public var prefixLevel: aws.sdk.kotlin.services.s3control.model.PrefixLevel? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.BucketLevel) : this() {
            this.activityMetrics = x.activityMetrics
            this.advancedCostOptimizationMetrics = x.advancedCostOptimizationMetrics
            this.advancedDataProtectionMetrics = x.advancedDataProtectionMetrics
            this.detailedStatusCodesMetrics = x.detailedStatusCodesMetrics
            this.prefixLevel = x.prefixLevel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.BucketLevel = BucketLevel(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.ActivityMetrics] inside the given [block]
         */
        public fun activityMetrics(block: aws.sdk.kotlin.services.s3control.model.ActivityMetrics.Builder.() -> kotlin.Unit) {
            this.activityMetrics = aws.sdk.kotlin.services.s3control.model.ActivityMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.AdvancedCostOptimizationMetrics] inside the given [block]
         */
        public fun advancedCostOptimizationMetrics(block: aws.sdk.kotlin.services.s3control.model.AdvancedCostOptimizationMetrics.Builder.() -> kotlin.Unit) {
            this.advancedCostOptimizationMetrics = aws.sdk.kotlin.services.s3control.model.AdvancedCostOptimizationMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.AdvancedDataProtectionMetrics] inside the given [block]
         */
        public fun advancedDataProtectionMetrics(block: aws.sdk.kotlin.services.s3control.model.AdvancedDataProtectionMetrics.Builder.() -> kotlin.Unit) {
            this.advancedDataProtectionMetrics = aws.sdk.kotlin.services.s3control.model.AdvancedDataProtectionMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.DetailedStatusCodesMetrics] inside the given [block]
         */
        public fun detailedStatusCodesMetrics(block: aws.sdk.kotlin.services.s3control.model.DetailedStatusCodesMetrics.Builder.() -> kotlin.Unit) {
            this.detailedStatusCodesMetrics = aws.sdk.kotlin.services.s3control.model.DetailedStatusCodesMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.PrefixLevel] inside the given [block]
         */
        public fun prefixLevel(block: aws.sdk.kotlin.services.s3control.model.PrefixLevel.Builder.() -> kotlin.Unit) {
            this.prefixLevel = aws.sdk.kotlin.services.s3control.model.PrefixLevel.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
