// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * An access point used to access a bucket.
 */
public class AccessPoint private constructor(builder: Builder) {
    /**
     * The ARN for the access point.
     */
    public val accessPointArn: kotlin.String? = builder.accessPointArn
    /**
     * The name or alias of the access point.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * The name of the bucket associated with this access point.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * The Amazon Web Services account ID associated with the S3 bucket associated with this access point.
     */
    public val bucketAccountId: kotlin.String? = builder.bucketAccountId
    /**
     * The name of this access point.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Indicates whether this access point allows access from the public internet. If `VpcConfiguration` is specified for this access point, then `NetworkOrigin` is `VPC`, and the access point doesn't allow access from the public internet. Otherwise, `NetworkOrigin` is `Internet`, and the access point allows access from the public internet, subject to the access point and bucket access policies.
     */
    public val networkOrigin: aws.sdk.kotlin.services.s3control.model.NetworkOrigin = requireNotNull(builder.networkOrigin) { "A non-null value must be provided for networkOrigin" }
    /**
     * The virtual private cloud (VPC) configuration for this access point, if one exists.
     *
     * This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.s3control.model.VpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.AccessPoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessPoint(")
        append("accessPointArn=$accessPointArn,")
        append("alias=$alias,")
        append("bucket=$bucket,")
        append("bucketAccountId=$bucketAccountId,")
        append("name=$name,")
        append("networkOrigin=$networkOrigin,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPointArn?.hashCode() ?: 0
        result = 31 * result + (alias?.hashCode() ?: 0)
        result = 31 * result + (bucket.hashCode())
        result = 31 * result + (bucketAccountId?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (networkOrigin.hashCode())
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessPoint

        if (accessPointArn != other.accessPointArn) return false
        if (alias != other.alias) return false
        if (bucket != other.bucket) return false
        if (bucketAccountId != other.bucketAccountId) return false
        if (name != other.name) return false
        if (networkOrigin != other.networkOrigin) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.AccessPoint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN for the access point.
         */
        public var accessPointArn: kotlin.String? = null
        /**
         * The name or alias of the access point.
         */
        public var alias: kotlin.String? = null
        /**
         * The name of the bucket associated with this access point.
         */
        public var bucket: kotlin.String? = null
        /**
         * The Amazon Web Services account ID associated with the S3 bucket associated with this access point.
         */
        public var bucketAccountId: kotlin.String? = null
        /**
         * The name of this access point.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates whether this access point allows access from the public internet. If `VpcConfiguration` is specified for this access point, then `NetworkOrigin` is `VPC`, and the access point doesn't allow access from the public internet. Otherwise, `NetworkOrigin` is `Internet`, and the access point allows access from the public internet, subject to the access point and bucket access policies.
         */
        public var networkOrigin: aws.sdk.kotlin.services.s3control.model.NetworkOrigin? = null
        /**
         * The virtual private cloud (VPC) configuration for this access point, if one exists.
         *
         * This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.s3control.model.VpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.AccessPoint) : this() {
            this.accessPointArn = x.accessPointArn
            this.alias = x.alias
            this.bucket = x.bucket
            this.bucketAccountId = x.bucketAccountId
            this.name = x.name
            this.networkOrigin = x.networkOrigin
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.AccessPoint = AccessPoint(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.VpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.s3control.model.VpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.s3control.model.VpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            if (name == null) name = ""
            if (networkOrigin == null) networkOrigin = NetworkOrigin.SdkUnknown("no value provided")
            return this
        }
    }
}
