// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.s3control.model.GetBucketResponse
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class GetBucketOperationDeserializer: HttpDeserialize<GetBucketResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetBucketResponse {
        if (!response.status.isSuccess()) {
            throwGetBucketError(context, response)
        }
        val builder = GetBucketResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetBucketOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetBucketError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBucketOperationBody(builder: GetBucketResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val BUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Bucket"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("CreationDate"))
    val PUBLICACCESSBLOCKENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("PublicAccessBlockEnabled"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetBucketResult"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(BUCKET_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(PUBLICACCESSBLOCKENABLED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUCKET_DESCRIPTOR.index -> builder.bucket = deserializeString()
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromIso8601(it) }
                PUBLICACCESSBLOCKENABLED_DESCRIPTOR.index -> builder.publicAccessBlockEnabled = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
