// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessPointForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class GetAccessPointForObjectLambdaOperationDeserializer: HttpDeserialize<GetAccessPointForObjectLambdaResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetAccessPointForObjectLambdaResponse {
        if (!response.status.isSuccess()) {
            throwGetAccessPointForObjectLambdaError(context, response)
        }
        val builder = GetAccessPointForObjectLambdaResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAccessPointForObjectLambdaOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetAccessPointForObjectLambdaError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAccessPointForObjectLambdaOperationBody(builder: GetAccessPointForObjectLambdaResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("CreationDate"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Name"))
    val PUBLICACCESSBLOCKCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("PublicAccessBlockConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetAccessPointForObjectLambdaResult"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(CREATIONDATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PUBLICACCESSBLOCKCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromIso8601(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PUBLICACCESSBLOCKCONFIGURATION_DESCRIPTOR.index -> builder.publicAccessBlockConfiguration = deserializePublicAccessBlockConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
