// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.internal

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.endpoint.AwsEndpoint
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.endpoint.CredentialScope
import aws.sdk.kotlin.runtime.endpoint.internal.EndpointDefinition
import aws.sdk.kotlin.runtime.endpoint.internal.Partition
import aws.sdk.kotlin.runtime.endpoint.internal.resolveEndpoint

internal class DefaultEndpointResolver : AwsEndpointResolver {
    override suspend fun resolve(service: String, region: String): AwsEndpoint {
        return resolveEndpoint(servicePartitions, region) ?: throw ClientException("unable to resolve endpoint for region: $region")
    }
}

private val servicePartitions = listOf(
    Partition(
        id = "aws",
        regionRegex = Regex("^(us|eu|ap|sa|ca|me|af)\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "s3-control.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("s3v4", ),
        ),
        endpoints = mapOf(
            "ap-northeast-1" to EndpointDefinition(
                hostname = "s3-control.ap-northeast-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-northeast-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "ap-northeast-2" to EndpointDefinition(
                hostname = "s3-control.ap-northeast-2.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-northeast-2",),
                signatureVersions = listOf("s3v4", ),
            ),
            "ap-northeast-3" to EndpointDefinition(
                hostname = "s3-control.ap-northeast-3.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-northeast-3",),
                signatureVersions = listOf("s3v4", ),
            ),
            "ap-south-1" to EndpointDefinition(
                hostname = "s3-control.ap-south-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-south-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "ap-southeast-1" to EndpointDefinition(
                hostname = "s3-control.ap-southeast-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-southeast-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "ap-southeast-2" to EndpointDefinition(
                hostname = "s3-control.ap-southeast-2.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-southeast-2",),
                signatureVersions = listOf("s3v4", ),
            ),
            "ca-central-1" to EndpointDefinition(
                hostname = "s3-control.ca-central-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ca-central-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "ca-central-1-fips" to EndpointDefinition(
                hostname = "s3-control-fips.ca-central-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ca-central-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "eu-central-1" to EndpointDefinition(
                hostname = "s3-control.eu-central-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-central-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "eu-north-1" to EndpointDefinition(
                hostname = "s3-control.eu-north-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-north-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "eu-west-1" to EndpointDefinition(
                hostname = "s3-control.eu-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "eu-west-2" to EndpointDefinition(
                hostname = "s3-control.eu-west-2.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-2",),
                signatureVersions = listOf("s3v4", ),
            ),
            "eu-west-3" to EndpointDefinition(
                hostname = "s3-control.eu-west-3.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-3",),
                signatureVersions = listOf("s3v4", ),
            ),
            "sa-east-1" to EndpointDefinition(
                hostname = "s3-control.sa-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "sa-east-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "us-east-1" to EndpointDefinition(
                hostname = "s3-control.us-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "us-east-1-fips" to EndpointDefinition(
                hostname = "s3-control-fips.us-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "us-east-2" to EndpointDefinition(
                hostname = "s3-control.us-east-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-2",),
                signatureVersions = listOf("s3v4", ),
            ),
            "us-east-2-fips" to EndpointDefinition(
                hostname = "s3-control-fips.us-east-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-2",),
                signatureVersions = listOf("s3v4", ),
            ),
            "us-west-1" to EndpointDefinition(
                hostname = "s3-control.us-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "us-west-1-fips" to EndpointDefinition(
                hostname = "s3-control-fips.us-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "us-west-2" to EndpointDefinition(
                hostname = "s3-control.us-west-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-2",),
                signatureVersions = listOf("s3v4", ),
            ),
            "us-west-2-fips" to EndpointDefinition(
                hostname = "s3-control-fips.us-west-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-2",),
                signatureVersions = listOf("s3v4", ),
            ),
        )
    ),
    Partition(
        id = "aws-cn",
        regionRegex = Regex("^cn\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "s3-control.{region}.amazonaws.com.cn",
            protocols = listOf("https", ),
            signatureVersions = listOf("s3v4", ),
        ),
        endpoints = mapOf(
            "cn-north-1" to EndpointDefinition(
                hostname = "s3-control.cn-north-1.amazonaws.com.cn",
                credentialScope = CredentialScope(region = "cn-north-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "cn-northwest-1" to EndpointDefinition(
                hostname = "s3-control.cn-northwest-1.amazonaws.com.cn",
                credentialScope = CredentialScope(region = "cn-northwest-1",),
                signatureVersions = listOf("s3v4", ),
            ),
        )
    ),
    Partition(
        id = "aws-iso",
        regionRegex = Regex("^us\\-iso\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "s3-control.{region}.c2s.ic.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-iso-b",
        regionRegex = Regex("^us\\-isob\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "s3-control.{region}.sc2s.sgov.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-us-gov",
        regionRegex = Regex("^us\\-gov\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "s3-control.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("s3v4", ),
        ),
        endpoints = mapOf(
            "us-gov-east-1" to EndpointDefinition(
                hostname = "s3-control.us-gov-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-east-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "us-gov-east-1-fips" to EndpointDefinition(
                hostname = "s3-control-fips.us-gov-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-east-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "us-gov-west-1" to EndpointDefinition(
                hostname = "s3-control.us-gov-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-west-1",),
                signatureVersions = listOf("s3v4", ),
            ),
            "us-gov-west-1-fips" to EndpointDefinition(
                hostname = "s3-control-fips.us-gov-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-west-1",),
                signatureVersions = listOf("s3v4", ),
            ),
        )
    ),
)
