// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.serde

import aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration
import aws.sdk.kotlin.services.rum.model.CustomEvents
import aws.sdk.kotlin.services.rum.model.DeobfuscationConfiguration
import aws.sdk.kotlin.services.rum.model.UpdateAppMonitorRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateAppMonitorOperationSerializer: HttpSerializer.NonStreaming<UpdateAppMonitorRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateAppMonitorRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("appmonitor"))
                add(PercentEncoding.SmithyLabel.encode(input.name))
            }
        }

        val payload = serializeUpdateAppMonitorOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAppMonitorOperationBody(context: ExecutionContext, input: UpdateAppMonitorRequest): ByteArray {
    val serializer = JsonSerializer()
    val APPMONITORCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AppMonitorConfiguration"))
    val CUSTOMEVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CustomEvents"))
    val CWLOGENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("CwLogEnabled"))
    val DEOBFUSCATIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeobfuscationConfiguration"))
    val DOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Domain"))
    val DOMAINLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DomainList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPMONITORCONFIGURATION_DESCRIPTOR)
        field(CUSTOMEVENTS_DESCRIPTOR)
        field(CWLOGENABLED_DESCRIPTOR)
        field(DEOBFUSCATIONCONFIGURATION_DESCRIPTOR)
        field(DOMAIN_DESCRIPTOR)
        field(DOMAINLIST_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.appMonitorConfiguration?.let { field(APPMONITORCONFIGURATION_DESCRIPTOR, it, ::serializeAppMonitorConfigurationDocument) }
        input.customEvents?.let { field(CUSTOMEVENTS_DESCRIPTOR, it, ::serializeCustomEventsDocument) }
        input.cwLogEnabled?.let { field(CWLOGENABLED_DESCRIPTOR, it) }
        input.deobfuscationConfiguration?.let { field(DEOBFUSCATIONCONFIGURATION_DESCRIPTOR, it, ::serializeDeobfuscationConfigurationDocument) }
        input.domain?.let { field(DOMAIN_DESCRIPTOR, it) }
        if (input.domainList != null) {
            listField(DOMAINLIST_DESCRIPTOR) {
                for (el0 in input.domainList) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
