// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.paginators

import aws.sdk.kotlin.services.rum.RumClient
import aws.sdk.kotlin.services.rum.model.AppMonitorSummary
import aws.sdk.kotlin.services.rum.model.BatchGetRumMetricDefinitionsRequest
import aws.sdk.kotlin.services.rum.model.BatchGetRumMetricDefinitionsResponse
import aws.sdk.kotlin.services.rum.model.GetAppMonitorDataRequest
import aws.sdk.kotlin.services.rum.model.GetAppMonitorDataResponse
import aws.sdk.kotlin.services.rum.model.ListAppMonitorsRequest
import aws.sdk.kotlin.services.rum.model.ListAppMonitorsResponse
import aws.sdk.kotlin.services.rum.model.ListRumMetricsDestinationsRequest
import aws.sdk.kotlin.services.rum.model.ListRumMetricsDestinationsResponse
import aws.sdk.kotlin.services.rum.model.MetricDefinition
import aws.sdk.kotlin.services.rum.model.MetricDestinationSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [BatchGetRumMetricDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [BatchGetRumMetricDefinitionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BatchGetRumMetricDefinitionsResponse]
 */
public fun RumClient.batchGetRumMetricDefinitionsPaginated(initialRequest: BatchGetRumMetricDefinitionsRequest): Flow<BatchGetRumMetricDefinitionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@batchGetRumMetricDefinitionsPaginated.batchGetRumMetricDefinitions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [BatchGetRumMetricDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BatchGetRumMetricDefinitionsResponse]
 */
public fun RumClient.batchGetRumMetricDefinitionsPaginated(block: BatchGetRumMetricDefinitionsRequest.Builder.() -> Unit): Flow<BatchGetRumMetricDefinitionsResponse> =
    batchGetRumMetricDefinitionsPaginated(BatchGetRumMetricDefinitionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [batchGetRumMetricDefinitionsPaginated]
 * to access the nested member [MetricDefinition]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MetricDefinition]
 */
@JvmName("batchGetRumMetricDefinitionsResponseMetricDefinition")
public fun Flow<BatchGetRumMetricDefinitionsResponse>.metricDefinitions(): Flow<MetricDefinition> =
    transform() { response ->
        response.metricDefinitions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetAppMonitorDataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetAppMonitorDataRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetAppMonitorDataResponse]
 */
public fun RumClient.getAppMonitorDataPaginated(initialRequest: GetAppMonitorDataRequest): Flow<GetAppMonitorDataResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getAppMonitorDataPaginated.getAppMonitorData(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetAppMonitorDataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetAppMonitorDataResponse]
 */
public fun RumClient.getAppMonitorDataPaginated(block: GetAppMonitorDataRequest.Builder.() -> Unit): Flow<GetAppMonitorDataResponse> =
    getAppMonitorDataPaginated(GetAppMonitorDataRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getAppMonitorDataPaginated]
 * to access the nested member [EventData]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventData]
 */
@JvmName("getAppMonitorDataResponseEventData")
public fun Flow<GetAppMonitorDataResponse>.events(): Flow<String> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAppMonitorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAppMonitorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppMonitorsResponse]
 */
public fun RumClient.listAppMonitorsPaginated(initialRequest: ListAppMonitorsRequest = ListAppMonitorsRequest { }): Flow<ListAppMonitorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAppMonitorsPaginated.listAppMonitors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAppMonitorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppMonitorsResponse]
 */
public fun RumClient.listAppMonitorsPaginated(block: ListAppMonitorsRequest.Builder.() -> Unit): Flow<ListAppMonitorsResponse> =
    listAppMonitorsPaginated(ListAppMonitorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAppMonitorsPaginated]
 * to access the nested member [AppMonitorSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AppMonitorSummary]
 */
@JvmName("listAppMonitorsResponseAppMonitorSummary")
public fun Flow<ListAppMonitorsResponse>.appMonitorSummaries(): Flow<AppMonitorSummary> =
    transform() { response ->
        response.appMonitorSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRumMetricsDestinationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRumMetricsDestinationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRumMetricsDestinationsResponse]
 */
public fun RumClient.listRumMetricsDestinationsPaginated(initialRequest: ListRumMetricsDestinationsRequest): Flow<ListRumMetricsDestinationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRumMetricsDestinationsPaginated.listRumMetricsDestinations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRumMetricsDestinationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRumMetricsDestinationsResponse]
 */
public fun RumClient.listRumMetricsDestinationsPaginated(block: ListRumMetricsDestinationsRequest.Builder.() -> Unit): Flow<ListRumMetricsDestinationsResponse> =
    listRumMetricsDestinationsPaginated(ListRumMetricsDestinationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRumMetricsDestinationsPaginated]
 * to access the nested member [MetricDestinationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MetricDestinationSummary]
 */
@JvmName("listRumMetricsDestinationsResponseMetricDestinationSummary")
public fun Flow<ListRumMetricsDestinationsResponse>.destinations(): Flow<MetricDestinationSummary> =
    transform() { response ->
        response.destinations?.forEach {
            emit(it)
        }
    }
