// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure that contains the information for one performance event that RUM collects from a user session with your application.
 */
public class RumEvent private constructor(builder: Builder) {
    /**
     * A string containing details about the event.
     */
    public val details: kotlin.String = requireNotNull(builder.details) { "A non-null value must be provided for details" }
    /**
     * A unique ID for this event.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Metadata about this event, which contains a JSON serialization of the identity of the user for this session. The user information comes from information such as the HTTP user-agent request header and document interface.
     */
    public val metadata: kotlin.String? = builder.metadata
    /**
     * The exact time that this event occurred.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.timestamp) { "A non-null value must be provided for timestamp" }
    /**
     * The JSON schema that denotes the type of event this is, such as a page load or a new session.
     */
    public val type: kotlin.String = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.RumEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RumEvent(")
        append("details=$details,")
        append("id=$id,")
        append("metadata=$metadata,")
        append("timestamp=$timestamp,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = details.hashCode()
        result = 31 * result + (id.hashCode())
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (timestamp.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RumEvent

        if (details != other.details) return false
        if (id != other.id) return false
        if (metadata != other.metadata) return false
        if (timestamp != other.timestamp) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.RumEvent = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A string containing details about the event.
         */
        public var details: kotlin.String? = null
        /**
         * A unique ID for this event.
         */
        public var id: kotlin.String? = null
        /**
         * Metadata about this event, which contains a JSON serialization of the identity of the user for this session. The user information comes from information such as the HTTP user-agent request header and document interface.
         */
        public var metadata: kotlin.String? = null
        /**
         * The exact time that this event occurred.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The JSON schema that denotes the type of event this is, such as a page load or a new session.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.RumEvent) : this() {
            this.details = x.details
            this.id = x.id
            this.metadata = x.metadata
            this.timestamp = x.timestamp
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.RumEvent = RumEvent(this)

        internal fun correctErrors(): Builder {
            if (details == null) details = ""
            if (id == null) id = ""
            if (timestamp == null) timestamp = Instant.fromEpochSeconds(0)
            if (type == null) type = ""
            return this
        }
    }
}
