// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Resource not found.
 */
public class ResourceNotFoundException private constructor(builder: Builder) : RumException(builder.message) {

    /**
     * The name of the resource that is associated with the error.
     */
    public val resourceName: kotlin.String = requireNotNull(builder.resourceName) { "A non-null value must be provided for resourceName" }
    /**
     * The type of the resource that is associated with the error.
     */
    public val resourceType: kotlin.String? = builder.resourceType

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.ResourceNotFoundException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceNotFoundException(")
        append("message=$message,")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message.hashCode()
        result = 31 * result + (resourceName.hashCode())
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceNotFoundException

        if (message != other.message) return false
        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.ResourceNotFoundException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        public var message: kotlin.String? = null
        /**
         * The name of the resource that is associated with the error.
         */
        public var resourceName: kotlin.String? = null
        /**
         * The type of the resource that is associated with the error.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.ResourceNotFoundException) : this() {
            this.message = x.message
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.ResourceNotFoundException = ResourceNotFoundException(this)

        internal fun correctErrors(): Builder {
            if (message == null) message = ""
            if (resourceName == null) resourceName = ""
            return this
        }
    }
}
