// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutRumEventsRequest private constructor(builder: Builder) {
    /**
     * If the app monitor uses a resource-based policy that requires `PutRumEvents` requests to specify a certain alias, specify that alias here. This alias will be compared to the `rum:alias` context key in the resource-based policy. For more information, see [Using resource-based policies with CloudWatch RUM](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html).
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * A structure that contains information about the app monitor that collected this telemetry information.
     */
    public val appMonitorDetails: aws.sdk.kotlin.services.rum.model.AppMonitorDetails? = builder.appMonitorDetails
    /**
     * A unique identifier for this batch of RUM event data.
     */
    public val batchId: kotlin.String = requireNotNull(builder.batchId) { "A non-null value must be provided for batchId" }
    /**
     * The ID of the app monitor that is sending this data.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * An array of structures that contain the telemetry event data.
     */
    public val rumEvents: List<RumEvent> = requireNotNull(builder.rumEvents) { "A non-null value must be provided for rumEvents" }
    /**
     * A structure that contains information about the user session that this batch of events was collected from.
     */
    public val userDetails: aws.sdk.kotlin.services.rum.model.UserDetails? = builder.userDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.PutRumEventsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutRumEventsRequest(")
        append("alias=$alias,")
        append("appMonitorDetails=$appMonitorDetails,")
        append("batchId=$batchId,")
        append("id=$id,")
        append("rumEvents=$rumEvents,")
        append("userDetails=$userDetails")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (appMonitorDetails?.hashCode() ?: 0)
        result = 31 * result + (batchId.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (rumEvents.hashCode())
        result = 31 * result + (userDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutRumEventsRequest

        if (alias != other.alias) return false
        if (appMonitorDetails != other.appMonitorDetails) return false
        if (batchId != other.batchId) return false
        if (id != other.id) return false
        if (rumEvents != other.rumEvents) return false
        if (userDetails != other.userDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.PutRumEventsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If the app monitor uses a resource-based policy that requires `PutRumEvents` requests to specify a certain alias, specify that alias here. This alias will be compared to the `rum:alias` context key in the resource-based policy. For more information, see [Using resource-based policies with CloudWatch RUM](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html).
         */
        public var alias: kotlin.String? = null
        /**
         * A structure that contains information about the app monitor that collected this telemetry information.
         */
        public var appMonitorDetails: aws.sdk.kotlin.services.rum.model.AppMonitorDetails? = null
        /**
         * A unique identifier for this batch of RUM event data.
         */
        public var batchId: kotlin.String? = null
        /**
         * The ID of the app monitor that is sending this data.
         */
        public var id: kotlin.String? = null
        /**
         * An array of structures that contain the telemetry event data.
         */
        public var rumEvents: List<RumEvent>? = null
        /**
         * A structure that contains information about the user session that this batch of events was collected from.
         */
        public var userDetails: aws.sdk.kotlin.services.rum.model.UserDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.PutRumEventsRequest) : this() {
            this.alias = x.alias
            this.appMonitorDetails = x.appMonitorDetails
            this.batchId = x.batchId
            this.id = x.id
            this.rumEvents = x.rumEvents
            this.userDetails = x.userDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.PutRumEventsRequest = PutRumEventsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rum.model.AppMonitorDetails] inside the given [block]
         */
        public fun appMonitorDetails(block: aws.sdk.kotlin.services.rum.model.AppMonitorDetails.Builder.() -> kotlin.Unit) {
            this.appMonitorDetails = aws.sdk.kotlin.services.rum.model.AppMonitorDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rum.model.UserDetails] inside the given [block]
         */
        public fun userDetails(block: aws.sdk.kotlin.services.rum.model.UserDetails.Builder.() -> kotlin.Unit) {
            this.userDetails = aws.sdk.kotlin.services.rum.model.UserDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (batchId == null) batchId = ""
            if (id == null) id = ""
            if (rumEvents == null) rumEvents = emptyList()
            return this
        }
    }
}
