// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that displays the definition of one extended metric that RUM sends to CloudWatch or CloudWatch Evidently. For more information, see [ Additional metrics that you can send to CloudWatch and CloudWatch Evidently](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-vended-metrics.html).
 */
public class MetricDefinition private constructor(builder: Builder) {
    /**
     * This field is a map of field paths to dimension names. It defines the dimensions to associate with this metric in CloudWatch The value of this field is used only if the metric destination is `CloudWatch`. If the metric destination is `Evidently`, the value of `DimensionKeys` is ignored.
     */
    public val dimensionKeys: Map<String, String>? = builder.dimensionKeys
    /**
     * The pattern that defines the metric. RUM checks events that happen in a user's session against the pattern, and events that match the pattern are sent to the metric destination.
     *
     * If the metrics destination is `CloudWatch` and the event also matches a value in `DimensionKeys`, then the metric is published with the specified dimensions.
     */
    public val eventPattern: kotlin.String? = builder.eventPattern
    /**
     * The ID of this metric definition.
     */
    public val metricDefinitionId: kotlin.String = requireNotNull(builder.metricDefinitionId) { "A non-null value must be provided for metricDefinitionId" }
    /**
     * The name of the metric that is defined in this structure.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * If this metric definition is for a custom metric instead of an extended metric, this field displays the metric namespace that the custom metric is published to.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * Use this field only if you are sending this metric to CloudWatch. It defines the CloudWatch metric unit that this metric is measured in.
     */
    public val unitLabel: kotlin.String? = builder.unitLabel
    /**
     * The field within the event object that the metric value is sourced from.
     */
    public val valueKey: kotlin.String? = builder.valueKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.MetricDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricDefinition(")
        append("dimensionKeys=$dimensionKeys,")
        append("eventPattern=$eventPattern,")
        append("metricDefinitionId=$metricDefinitionId,")
        append("name=$name,")
        append("namespace=$namespace,")
        append("unitLabel=$unitLabel,")
        append("valueKey=$valueKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensionKeys?.hashCode() ?: 0
        result = 31 * result + (eventPattern?.hashCode() ?: 0)
        result = 31 * result + (metricDefinitionId.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (unitLabel?.hashCode() ?: 0)
        result = 31 * result + (valueKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricDefinition

        if (dimensionKeys != other.dimensionKeys) return false
        if (eventPattern != other.eventPattern) return false
        if (metricDefinitionId != other.metricDefinitionId) return false
        if (name != other.name) return false
        if (namespace != other.namespace) return false
        if (unitLabel != other.unitLabel) return false
        if (valueKey != other.valueKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.MetricDefinition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This field is a map of field paths to dimension names. It defines the dimensions to associate with this metric in CloudWatch The value of this field is used only if the metric destination is `CloudWatch`. If the metric destination is `Evidently`, the value of `DimensionKeys` is ignored.
         */
        public var dimensionKeys: Map<String, String>? = null
        /**
         * The pattern that defines the metric. RUM checks events that happen in a user's session against the pattern, and events that match the pattern are sent to the metric destination.
         *
         * If the metrics destination is `CloudWatch` and the event also matches a value in `DimensionKeys`, then the metric is published with the specified dimensions.
         */
        public var eventPattern: kotlin.String? = null
        /**
         * The ID of this metric definition.
         */
        public var metricDefinitionId: kotlin.String? = null
        /**
         * The name of the metric that is defined in this structure.
         */
        public var name: kotlin.String? = null
        /**
         * If this metric definition is for a custom metric instead of an extended metric, this field displays the metric namespace that the custom metric is published to.
         */
        public var namespace: kotlin.String? = null
        /**
         * Use this field only if you are sending this metric to CloudWatch. It defines the CloudWatch metric unit that this metric is measured in.
         */
        public var unitLabel: kotlin.String? = null
        /**
         * The field within the event object that the metric value is sourced from.
         */
        public var valueKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.MetricDefinition) : this() {
            this.dimensionKeys = x.dimensionKeys
            this.eventPattern = x.eventPattern
            this.metricDefinitionId = x.metricDefinitionId
            this.name = x.name
            this.namespace = x.namespace
            this.unitLabel = x.unitLabel
            this.valueKey = x.valueKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.MetricDefinition = MetricDefinition(this)

        internal fun correctErrors(): Builder {
            if (metricDefinitionId == null) metricDefinitionId = ""
            if (name == null) name = ""
            return this
        }
    }
}
