// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DeleteRumMetricsDestinationRequest private constructor(builder: Builder) {
    /**
     * The name of the app monitor that is sending metrics to the destination that you want to delete.
     */
    public val appMonitorName: kotlin.String = requireNotNull(builder.appMonitorName) { "A non-null value must be provided for appMonitorName" }
    /**
     * The type of destination to delete. Valid values are `CloudWatch` and `Evidently`.
     */
    public val destination: aws.sdk.kotlin.services.rum.model.MetricDestination = requireNotNull(builder.destination) { "A non-null value must be provided for destination" }
    /**
     * This parameter is required if `Destination` is `Evidently`. If `Destination` is `CloudWatch`, do not use this parameter. This parameter specifies the ARN of the Evidently experiment that corresponds to the destination to delete.
     */
    public val destinationArn: kotlin.String? = builder.destinationArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.DeleteRumMetricsDestinationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteRumMetricsDestinationRequest(")
        append("appMonitorName=$appMonitorName,")
        append("destination=$destination,")
        append("destinationArn=$destinationArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appMonitorName.hashCode()
        result = 31 * result + (destination.hashCode())
        result = 31 * result + (destinationArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteRumMetricsDestinationRequest

        if (appMonitorName != other.appMonitorName) return false
        if (destination != other.destination) return false
        if (destinationArn != other.destinationArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.DeleteRumMetricsDestinationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the app monitor that is sending metrics to the destination that you want to delete.
         */
        public var appMonitorName: kotlin.String? = null
        /**
         * The type of destination to delete. Valid values are `CloudWatch` and `Evidently`.
         */
        public var destination: aws.sdk.kotlin.services.rum.model.MetricDestination? = null
        /**
         * This parameter is required if `Destination` is `Evidently`. If `Destination` is `CloudWatch`, do not use this parameter. This parameter specifies the ARN of the Evidently experiment that corresponds to the destination to delete.
         */
        public var destinationArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.DeleteRumMetricsDestinationRequest) : this() {
            this.appMonitorName = x.appMonitorName
            this.destination = x.destination
            this.destinationArn = x.destinationArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.DeleteRumMetricsDestinationRequest = DeleteRumMetricsDestinationRequest(this)

        internal fun correctErrors(): Builder {
            if (appMonitorName == null) appMonitorName = ""
            if (destination == null) destination = MetricDestination.SdkUnknown("no value provided")
            return this
        }
    }
}
