// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model

import aws.smithy.kotlin.runtime.SdkDsl

public class BatchGetRumMetricDefinitionsRequest private constructor(builder: Builder) {
    /**
     * The name of the CloudWatch RUM app monitor that is sending the metrics.
     */
    public val appMonitorName: kotlin.String = requireNotNull(builder.appMonitorName) { "A non-null value must be provided for appMonitorName" }
    /**
     * The type of destination that you want to view metrics for. Valid values are `CloudWatch` and `Evidently`.
     */
    public val destination: aws.sdk.kotlin.services.rum.model.MetricDestination = requireNotNull(builder.destination) { "A non-null value must be provided for destination" }
    /**
     * This parameter is required if `Destination` is `Evidently`. If `Destination` is `CloudWatch`, do not use this parameter.
     *
     * This parameter specifies the ARN of the Evidently experiment that corresponds to the destination.
     */
    public val destinationArn: kotlin.String? = builder.destinationArn
    /**
     * The maximum number of results to return in one operation. The default is 50. The maximum that you can specify is 100.
     *
     * To retrieve the remaining results, make another call with the returned `NextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Use the token returned by the previous operation to request the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.BatchGetRumMetricDefinitionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetRumMetricDefinitionsRequest(")
        append("appMonitorName=$appMonitorName,")
        append("destination=$destination,")
        append("destinationArn=$destinationArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appMonitorName.hashCode()
        result = 31 * result + (destination.hashCode())
        result = 31 * result + (destinationArn?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchGetRumMetricDefinitionsRequest

        if (appMonitorName != other.appMonitorName) return false
        if (destination != other.destination) return false
        if (destinationArn != other.destinationArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.BatchGetRumMetricDefinitionsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the CloudWatch RUM app monitor that is sending the metrics.
         */
        public var appMonitorName: kotlin.String? = null
        /**
         * The type of destination that you want to view metrics for. Valid values are `CloudWatch` and `Evidently`.
         */
        public var destination: aws.sdk.kotlin.services.rum.model.MetricDestination? = null
        /**
         * This parameter is required if `Destination` is `Evidently`. If `Destination` is `CloudWatch`, do not use this parameter.
         *
         * This parameter specifies the ARN of the Evidently experiment that corresponds to the destination.
         */
        public var destinationArn: kotlin.String? = null
        /**
         * The maximum number of results to return in one operation. The default is 50. The maximum that you can specify is 100.
         *
         * To retrieve the remaining results, make another call with the returned `NextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Use the token returned by the previous operation to request the next page of results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.BatchGetRumMetricDefinitionsRequest) : this() {
            this.appMonitorName = x.appMonitorName
            this.destination = x.destination
            this.destinationArn = x.destinationArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.BatchGetRumMetricDefinitionsRequest = BatchGetRumMetricDefinitionsRequest(this)

        internal fun correctErrors(): Builder {
            if (appMonitorName == null) appMonitorName = ""
            if (destination == null) destination = MetricDestination.SdkUnknown("no value provided")
            return this
        }
    }
}
