// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model

import aws.smithy.kotlin.runtime.SdkDsl

public class BatchDeleteRumMetricDefinitionsRequest private constructor(builder: Builder) {
    /**
     * The name of the CloudWatch RUM app monitor that is sending these metrics.
     */
    public val appMonitorName: kotlin.String = requireNotNull(builder.appMonitorName) { "A non-null value must be provided for appMonitorName" }
    /**
     * Defines the destination where you want to stop sending the specified metrics. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
     */
    public val destination: aws.sdk.kotlin.services.rum.model.MetricDestination = requireNotNull(builder.destination) { "A non-null value must be provided for destination" }
    /**
     * This parameter is required if `Destination` is `Evidently`. If `Destination` is `CloudWatch`, do not use this parameter.
     *
     * This parameter specifies the ARN of the Evidently experiment that was receiving the metrics that are being deleted.
     */
    public val destinationArn: kotlin.String? = builder.destinationArn
    /**
     * An array of structures which define the metrics that you want to stop sending.
     */
    public val metricDefinitionIds: List<String> = requireNotNull(builder.metricDefinitionIds) { "A non-null value must be provided for metricDefinitionIds" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.BatchDeleteRumMetricDefinitionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchDeleteRumMetricDefinitionsRequest(")
        append("appMonitorName=$appMonitorName,")
        append("destination=$destination,")
        append("destinationArn=$destinationArn,")
        append("metricDefinitionIds=$metricDefinitionIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appMonitorName.hashCode()
        result = 31 * result + (destination.hashCode())
        result = 31 * result + (destinationArn?.hashCode() ?: 0)
        result = 31 * result + (metricDefinitionIds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchDeleteRumMetricDefinitionsRequest

        if (appMonitorName != other.appMonitorName) return false
        if (destination != other.destination) return false
        if (destinationArn != other.destinationArn) return false
        if (metricDefinitionIds != other.metricDefinitionIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.BatchDeleteRumMetricDefinitionsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the CloudWatch RUM app monitor that is sending these metrics.
         */
        public var appMonitorName: kotlin.String? = null
        /**
         * Defines the destination where you want to stop sending the specified metrics. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
         */
        public var destination: aws.sdk.kotlin.services.rum.model.MetricDestination? = null
        /**
         * This parameter is required if `Destination` is `Evidently`. If `Destination` is `CloudWatch`, do not use this parameter.
         *
         * This parameter specifies the ARN of the Evidently experiment that was receiving the metrics that are being deleted.
         */
        public var destinationArn: kotlin.String? = null
        /**
         * An array of structures which define the metrics that you want to stop sending.
         */
        public var metricDefinitionIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.BatchDeleteRumMetricDefinitionsRequest) : this() {
            this.appMonitorName = x.appMonitorName
            this.destination = x.destination
            this.destinationArn = x.destinationArn
            this.metricDefinitionIds = x.metricDefinitionIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.BatchDeleteRumMetricDefinitionsRequest = BatchDeleteRumMetricDefinitionsRequest(this)

        internal fun correctErrors(): Builder {
            if (appMonitorName == null) appMonitorName = ""
            if (destination == null) destination = MetricDestination.SdkUnknown("no value provided")
            if (metricDefinitionIds == null) metricDefinitionIds = emptyList()
            return this
        }
    }
}
