// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A RUM app monitor collects telemetry data from your application and sends that data to RUM. The data includes performance and reliability information such as page load time, client-side errors, and user behavior.
 */
public class AppMonitor private constructor(builder: Builder) {
    /**
     * A structure that contains much of the configuration data for the app monitor.
     */
    public val appMonitorConfiguration: aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration? = builder.appMonitorConfiguration
    /**
     * The date and time that this app monitor was created.
     */
    public val created: kotlin.String? = builder.created
    /**
     * Specifies whether this app monitor allows the web client to define and send custom events.
     *
     * For more information about custom events, see [Send custom events](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-events.html).
     */
    public val customEvents: aws.sdk.kotlin.services.rum.model.CustomEvents? = builder.customEvents
    /**
     * A structure that contains information about whether this app monitor stores a copy of the telemetry data that RUM collects using CloudWatch Logs.
     */
    public val dataStorage: aws.sdk.kotlin.services.rum.model.DataStorage? = builder.dataStorage
    /**
     * A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
     */
    public val deobfuscationConfiguration: aws.sdk.kotlin.services.rum.model.DeobfuscationConfiguration? = builder.deobfuscationConfiguration
    /**
     * The top-level internet domain name for which your application has administrative authority.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * List the domain names for which your application has administrative authority.
     */
    public val domainList: List<String>? = builder.domainList
    /**
     * The unique ID of this app monitor.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The date and time of the most recent changes to this app monitor's configuration.
     */
    public val lastModified: kotlin.String? = builder.lastModified
    /**
     * The name of the app monitor.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The current state of the app monitor.
     */
    public val state: aws.sdk.kotlin.services.rum.model.StateEnum? = builder.state
    /**
     * The list of tag keys and values associated with this app monitor.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.AppMonitor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppMonitor(")
        append("appMonitorConfiguration=$appMonitorConfiguration,")
        append("created=$created,")
        append("customEvents=$customEvents,")
        append("dataStorage=$dataStorage,")
        append("deobfuscationConfiguration=$deobfuscationConfiguration,")
        append("domain=$domain,")
        append("domainList=$domainList,")
        append("id=$id,")
        append("lastModified=$lastModified,")
        append("name=$name,")
        append("state=$state,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appMonitorConfiguration?.hashCode() ?: 0
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (customEvents?.hashCode() ?: 0)
        result = 31 * result + (dataStorage?.hashCode() ?: 0)
        result = 31 * result + (deobfuscationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainList?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppMonitor

        if (appMonitorConfiguration != other.appMonitorConfiguration) return false
        if (created != other.created) return false
        if (customEvents != other.customEvents) return false
        if (dataStorage != other.dataStorage) return false
        if (deobfuscationConfiguration != other.deobfuscationConfiguration) return false
        if (domain != other.domain) return false
        if (domainList != other.domainList) return false
        if (id != other.id) return false
        if (lastModified != other.lastModified) return false
        if (name != other.name) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.AppMonitor = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A structure that contains much of the configuration data for the app monitor.
         */
        public var appMonitorConfiguration: aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration? = null
        /**
         * The date and time that this app monitor was created.
         */
        public var created: kotlin.String? = null
        /**
         * Specifies whether this app monitor allows the web client to define and send custom events.
         *
         * For more information about custom events, see [Send custom events](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-events.html).
         */
        public var customEvents: aws.sdk.kotlin.services.rum.model.CustomEvents? = null
        /**
         * A structure that contains information about whether this app monitor stores a copy of the telemetry data that RUM collects using CloudWatch Logs.
         */
        public var dataStorage: aws.sdk.kotlin.services.rum.model.DataStorage? = null
        /**
         * A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
         */
        public var deobfuscationConfiguration: aws.sdk.kotlin.services.rum.model.DeobfuscationConfiguration? = null
        /**
         * The top-level internet domain name for which your application has administrative authority.
         */
        public var domain: kotlin.String? = null
        /**
         * List the domain names for which your application has administrative authority.
         */
        public var domainList: List<String>? = null
        /**
         * The unique ID of this app monitor.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time of the most recent changes to this app monitor's configuration.
         */
        public var lastModified: kotlin.String? = null
        /**
         * The name of the app monitor.
         */
        public var name: kotlin.String? = null
        /**
         * The current state of the app monitor.
         */
        public var state: aws.sdk.kotlin.services.rum.model.StateEnum? = null
        /**
         * The list of tag keys and values associated with this app monitor.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.AppMonitor) : this() {
            this.appMonitorConfiguration = x.appMonitorConfiguration
            this.created = x.created
            this.customEvents = x.customEvents
            this.dataStorage = x.dataStorage
            this.deobfuscationConfiguration = x.deobfuscationConfiguration
            this.domain = x.domain
            this.domainList = x.domainList
            this.id = x.id
            this.lastModified = x.lastModified
            this.name = x.name
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.AppMonitor = AppMonitor(this)

        /**
         * construct an [aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration] inside the given [block]
         */
        public fun appMonitorConfiguration(block: aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration.Builder.() -> kotlin.Unit) {
            this.appMonitorConfiguration = aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rum.model.CustomEvents] inside the given [block]
         */
        public fun customEvents(block: aws.sdk.kotlin.services.rum.model.CustomEvents.Builder.() -> kotlin.Unit) {
            this.customEvents = aws.sdk.kotlin.services.rum.model.CustomEvents.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rum.model.DataStorage] inside the given [block]
         */
        public fun dataStorage(block: aws.sdk.kotlin.services.rum.model.DataStorage.Builder.() -> kotlin.Unit) {
            this.dataStorage = aws.sdk.kotlin.services.rum.model.DataStorage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rum.model.DeobfuscationConfiguration] inside the given [block]
         */
        public fun deobfuscationConfiguration(block: aws.sdk.kotlin.services.rum.model.DeobfuscationConfiguration.Builder.() -> kotlin.Unit) {
            this.deobfuscationConfiguration = aws.sdk.kotlin.services.rum.model.DeobfuscationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
