// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.rum.auth.DefaultRumAuthSchemeProvider
import aws.sdk.kotlin.services.rum.auth.RumAuthSchemeProvider
import aws.sdk.kotlin.services.rum.endpoints.DefaultRumEndpointProvider
import aws.sdk.kotlin.services.rum.endpoints.RumEndpointParameters
import aws.sdk.kotlin.services.rum.endpoints.RumEndpointProvider
import aws.sdk.kotlin.services.rum.model.BatchCreateRumMetricDefinitionsRequest
import aws.sdk.kotlin.services.rum.model.BatchCreateRumMetricDefinitionsResponse
import aws.sdk.kotlin.services.rum.model.BatchDeleteRumMetricDefinitionsRequest
import aws.sdk.kotlin.services.rum.model.BatchDeleteRumMetricDefinitionsResponse
import aws.sdk.kotlin.services.rum.model.BatchGetRumMetricDefinitionsRequest
import aws.sdk.kotlin.services.rum.model.BatchGetRumMetricDefinitionsResponse
import aws.sdk.kotlin.services.rum.model.CreateAppMonitorRequest
import aws.sdk.kotlin.services.rum.model.CreateAppMonitorResponse
import aws.sdk.kotlin.services.rum.model.DeleteAppMonitorRequest
import aws.sdk.kotlin.services.rum.model.DeleteAppMonitorResponse
import aws.sdk.kotlin.services.rum.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.rum.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.rum.model.DeleteRumMetricsDestinationRequest
import aws.sdk.kotlin.services.rum.model.DeleteRumMetricsDestinationResponse
import aws.sdk.kotlin.services.rum.model.GetAppMonitorDataRequest
import aws.sdk.kotlin.services.rum.model.GetAppMonitorDataResponse
import aws.sdk.kotlin.services.rum.model.GetAppMonitorRequest
import aws.sdk.kotlin.services.rum.model.GetAppMonitorResponse
import aws.sdk.kotlin.services.rum.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.rum.model.GetResourcePolicyResponse
import aws.sdk.kotlin.services.rum.model.ListAppMonitorsRequest
import aws.sdk.kotlin.services.rum.model.ListAppMonitorsResponse
import aws.sdk.kotlin.services.rum.model.ListRumMetricsDestinationsRequest
import aws.sdk.kotlin.services.rum.model.ListRumMetricsDestinationsResponse
import aws.sdk.kotlin.services.rum.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.rum.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.rum.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.rum.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.rum.model.PutRumEventsRequest
import aws.sdk.kotlin.services.rum.model.PutRumEventsResponse
import aws.sdk.kotlin.services.rum.model.PutRumMetricsDestinationRequest
import aws.sdk.kotlin.services.rum.model.PutRumMetricsDestinationResponse
import aws.sdk.kotlin.services.rum.model.TagResourceRequest
import aws.sdk.kotlin.services.rum.model.TagResourceResponse
import aws.sdk.kotlin.services.rum.model.UntagResourceRequest
import aws.sdk.kotlin.services.rum.model.UntagResourceResponse
import aws.sdk.kotlin.services.rum.model.UpdateAppMonitorRequest
import aws.sdk.kotlin.services.rum.model.UpdateAppMonitorResponse
import aws.sdk.kotlin.services.rum.model.UpdateRumMetricDefinitionRequest
import aws.sdk.kotlin.services.rum.model.UpdateRumMetricDefinitionResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "RUM"
public const val SdkVersion: String = "1.5.8"
public const val ServiceApiVersion: String = "2018-05-10"

/**
 * With Amazon CloudWatch RUM, you can perform real-user monitoring to collect client-side data about your web application performance from actual user sessions in real time. The data collected includes page load times, client-side errors, and user behavior. When you view this data, you can see it all aggregated together and also see breakdowns by the browsers and devices that your customers use.
 *
 * You can use the collected data to quickly identify and debug client-side performance issues. CloudWatch RUM helps you visualize anomalies in your application performance and find relevant debugging data such as error messages, stack traces, and user sessions. You can also use RUM to understand the range of end-user impact including the number of users, geolocations, and browsers used.
 */
public interface RumClient : SdkClient {
    /**
     * RumClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, RumClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Rum",
                "RUM",
                "rum",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, RumClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): RumClient = DefaultRumClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: RumEndpointProvider = builder.endpointProvider ?: DefaultRumEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: RumAuthSchemeProvider = builder.authSchemeProvider ?: DefaultRumAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "RUM"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: RumEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: RumAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Specifies the extended metrics and custom metrics that you want a CloudWatch RUM app monitor to send to a destination. Valid destinations include CloudWatch and Evidently.
     *
     * By default, RUM app monitors send some metrics to CloudWatch. These default metrics are listed in [CloudWatch metrics that you can collect with CloudWatch RUM](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-metrics.html).
     *
     * In addition to these default metrics, you can choose to send extended metrics, custom metrics, or both.
     * + Extended metrics let you send metrics with additional dimensions that aren't included in the default metrics. You can also send extended metrics to both Evidently and CloudWatch. The valid dimension names for the additional dimensions for extended metrics are `BrowserName`, `CountryCode`, `DeviceType`, `FileType`, `OSName`, and `PageId`. For more information, see [ Extended metrics that you can send to CloudWatch and CloudWatch Evidently](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-vended-metrics.html).
     * + Custom metrics are metrics that you define. You can send custom metrics to CloudWatch. CloudWatch Evidently, or both. With custom metrics, you can use any metric name and namespace. To derive the metrics, you can use any custom events, built-in events, custom attributes, or default attributes. You can't send custom metrics to the `AWS/RUM` namespace. You must send custom metrics to a custom namespace that you define. The namespace that you use can't start with `AWS/`. CloudWatch RUM prepends `RUM/CustomMetrics/` to the custom namespace that you define, so the final namespace for your metrics in CloudWatch is `RUM/CustomMetrics/<i>your-custom-namespace</i> `.
     *
     * The maximum number of metric definitions that you can specify in one `BatchCreateRumMetricDefinitions` operation is 200.
     *
     * The maximum number of metric definitions that one destination can contain is 2000.
     *
     * Extended metrics sent to CloudWatch and RUM custom metrics are charged as CloudWatch custom metrics. Each combination of additional dimension name and dimension value counts as a custom metric. For more information, see [Amazon CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
     *
     * You must have already created a destination for the metrics before you send them. For more information, see [PutRumMetricsDestination](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html).
     *
     * If some metric definitions specified in a `BatchCreateRumMetricDefinitions` operations are not valid, those metric definitions fail and return errors, but all valid metric definitions in the same operation still succeed.
     */
    public suspend fun batchCreateRumMetricDefinitions(input: BatchCreateRumMetricDefinitionsRequest): BatchCreateRumMetricDefinitionsResponse

    /**
     * Removes the specified metrics from being sent to an extended metrics destination.
     *
     * If some metric definition IDs specified in a `BatchDeleteRumMetricDefinitions` operations are not valid, those metric definitions fail and return errors, but all valid metric definition IDs in the same operation are still deleted.
     *
     * The maximum number of metric definitions that you can specify in one `BatchDeleteRumMetricDefinitions` operation is 200.
     */
    public suspend fun batchDeleteRumMetricDefinitions(input: BatchDeleteRumMetricDefinitionsRequest): BatchDeleteRumMetricDefinitionsResponse

    /**
     * Retrieves the list of metrics and dimensions that a RUM app monitor is sending to a single destination.
     */
    public suspend fun batchGetRumMetricDefinitions(input: BatchGetRumMetricDefinitionsRequest): BatchGetRumMetricDefinitionsResponse

    /**
     * Creates a Amazon CloudWatch RUM app monitor, which collects telemetry data from your application and sends that data to RUM. The data includes performance and reliability information such as page load time, client-side errors, and user behavior.
     *
     * You use this operation only to create a new app monitor. To update an existing app monitor, use [UpdateAppMonitor](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_UpdateAppMonitor.html) instead.
     *
     * After you create an app monitor, sign in to the CloudWatch RUM console to get the JavaScript code snippet to add to your web application. For more information, see [How do I find a code snippet that I've already generated?](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html)
     */
    public suspend fun createAppMonitor(input: CreateAppMonitorRequest): CreateAppMonitorResponse

    /**
     * Deletes an existing app monitor. This immediately stops the collection of data.
     */
    public suspend fun deleteAppMonitor(input: DeleteAppMonitorRequest): DeleteAppMonitorResponse

    /**
     * Removes the association of a resource-based policy from an app monitor.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes a destination for CloudWatch RUM extended metrics, so that the specified app monitor stops sending extended metrics to that destination.
     */
    public suspend fun deleteRumMetricsDestination(input: DeleteRumMetricsDestinationRequest): DeleteRumMetricsDestinationResponse

    /**
     * Retrieves the complete configuration information for one app monitor.
     */
    public suspend fun getAppMonitor(input: GetAppMonitorRequest): GetAppMonitorResponse

    /**
     * Retrieves the raw performance events that RUM has collected from your web application, so that you can do your own processing or analysis of this data.
     */
    public suspend fun getAppMonitorData(input: GetAppMonitorDataRequest): GetAppMonitorDataResponse

    /**
     * Use this operation to retrieve information about a resource-based policy that is attached to an app monitor.
     */
    public suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse

    /**
     * Returns a list of the Amazon CloudWatch RUM app monitors in the account.
     */
    public suspend fun listAppMonitors(input: ListAppMonitorsRequest = ListAppMonitorsRequest { }): ListAppMonitorsResponse

    /**
     * Returns a list of destinations that you have created to receive RUM extended metrics, for the specified app monitor.
     *
     * For more information about extended metrics, see [AddRumMetrics](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_AddRumMetrcs.html).
     */
    public suspend fun listRumMetricsDestinations(input: ListRumMetricsDestinationsRequest): ListRumMetricsDestinationsResponse

    /**
     * Displays the tags associated with a CloudWatch RUM resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Use this operation to assign a resource-based policy to a CloudWatch RUM app monitor to control access to it. Each app monitor can have one resource-based policy. The maximum size of the policy is 4 KB. To learn more about using resource policies with RUM, see [Using resource-based policies with CloudWatch RUM](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html).
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Sends telemetry events about your application performance and user behavior to CloudWatch RUM. The code snippet that RUM generates for you to add to your application includes `PutRumEvents` operations to send this data to RUM.
     *
     * Each `PutRumEvents` operation can send a batch of events from one user session.
     */
    public suspend fun putRumEvents(input: PutRumEventsRequest): PutRumEventsResponse

    /**
     * Creates or updates a destination to receive extended metrics from CloudWatch RUM. You can send extended metrics to CloudWatch or to a CloudWatch Evidently experiment.
     *
     * For more information about extended metrics, see [BatchCreateRumMetricDefinitions](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_BatchCreateRumMetricDefinitions.html).
     */
    public suspend fun putRumMetricsDestination(input: PutRumMetricsDestinationRequest): PutRumMetricsDestinationResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified CloudWatch RUM resource. Currently, the only resources that can be tagged app monitors.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     *
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.
     *
     * You can use the `TagResource` action with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate as many as 50 tags with a resource.
     *
     * For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the configuration of an existing app monitor. When you use this operation, only the parts of the app monitor configuration that you specify in this operation are changed. For any parameters that you omit, the existing values are kept.
     *
     * You can't use this operation to change the tags of an existing app monitor. To change the tags of an existing app monitor, use [TagResource](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_TagResource.html).
     *
     * To create a new app monitor, use [CreateAppMonitor](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_CreateAppMonitor.html).
     *
     * After you update an app monitor, sign in to the CloudWatch RUM console to get the updated JavaScript code snippet to add to your web application. For more information, see [How do I find a code snippet that I've already generated?](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html)
     */
    public suspend fun updateAppMonitor(input: UpdateAppMonitorRequest): UpdateAppMonitorResponse

    /**
     * Modifies one existing metric definition for CloudWatch RUM extended metrics. For more information about extended metrics, see [BatchCreateRumMetricsDefinitions](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_BatchCreateRumMetricsDefinitions.html).
     */
    public suspend fun updateRumMetricDefinition(input: UpdateRumMetricDefinitionRequest): UpdateRumMetricDefinitionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun RumClient.withConfig(block: RumClient.Config.Builder.() -> Unit): RumClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultRumClient(newConfig)
}

/**
 * Specifies the extended metrics and custom metrics that you want a CloudWatch RUM app monitor to send to a destination. Valid destinations include CloudWatch and Evidently.
 *
 * By default, RUM app monitors send some metrics to CloudWatch. These default metrics are listed in [CloudWatch metrics that you can collect with CloudWatch RUM](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-metrics.html).
 *
 * In addition to these default metrics, you can choose to send extended metrics, custom metrics, or both.
 * + Extended metrics let you send metrics with additional dimensions that aren't included in the default metrics. You can also send extended metrics to both Evidently and CloudWatch. The valid dimension names for the additional dimensions for extended metrics are `BrowserName`, `CountryCode`, `DeviceType`, `FileType`, `OSName`, and `PageId`. For more information, see [ Extended metrics that you can send to CloudWatch and CloudWatch Evidently](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-vended-metrics.html).
 * + Custom metrics are metrics that you define. You can send custom metrics to CloudWatch. CloudWatch Evidently, or both. With custom metrics, you can use any metric name and namespace. To derive the metrics, you can use any custom events, built-in events, custom attributes, or default attributes. You can't send custom metrics to the `AWS/RUM` namespace. You must send custom metrics to a custom namespace that you define. The namespace that you use can't start with `AWS/`. CloudWatch RUM prepends `RUM/CustomMetrics/` to the custom namespace that you define, so the final namespace for your metrics in CloudWatch is `RUM/CustomMetrics/<i>your-custom-namespace</i> `.
 *
 * The maximum number of metric definitions that you can specify in one `BatchCreateRumMetricDefinitions` operation is 200.
 *
 * The maximum number of metric definitions that one destination can contain is 2000.
 *
 * Extended metrics sent to CloudWatch and RUM custom metrics are charged as CloudWatch custom metrics. Each combination of additional dimension name and dimension value counts as a custom metric. For more information, see [Amazon CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
 *
 * You must have already created a destination for the metrics before you send them. For more information, see [PutRumMetricsDestination](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html).
 *
 * If some metric definitions specified in a `BatchCreateRumMetricDefinitions` operations are not valid, those metric definitions fail and return errors, but all valid metric definitions in the same operation still succeed.
 */
public suspend inline fun RumClient.batchCreateRumMetricDefinitions(crossinline block: BatchCreateRumMetricDefinitionsRequest.Builder.() -> Unit): BatchCreateRumMetricDefinitionsResponse = batchCreateRumMetricDefinitions(BatchCreateRumMetricDefinitionsRequest.Builder().apply(block).build())

/**
 * Removes the specified metrics from being sent to an extended metrics destination.
 *
 * If some metric definition IDs specified in a `BatchDeleteRumMetricDefinitions` operations are not valid, those metric definitions fail and return errors, but all valid metric definition IDs in the same operation are still deleted.
 *
 * The maximum number of metric definitions that you can specify in one `BatchDeleteRumMetricDefinitions` operation is 200.
 */
public suspend inline fun RumClient.batchDeleteRumMetricDefinitions(crossinline block: BatchDeleteRumMetricDefinitionsRequest.Builder.() -> Unit): BatchDeleteRumMetricDefinitionsResponse = batchDeleteRumMetricDefinitions(BatchDeleteRumMetricDefinitionsRequest.Builder().apply(block).build())

/**
 * Retrieves the list of metrics and dimensions that a RUM app monitor is sending to a single destination.
 */
public suspend inline fun RumClient.batchGetRumMetricDefinitions(crossinline block: BatchGetRumMetricDefinitionsRequest.Builder.() -> Unit): BatchGetRumMetricDefinitionsResponse = batchGetRumMetricDefinitions(BatchGetRumMetricDefinitionsRequest.Builder().apply(block).build())

/**
 * Creates a Amazon CloudWatch RUM app monitor, which collects telemetry data from your application and sends that data to RUM. The data includes performance and reliability information such as page load time, client-side errors, and user behavior.
 *
 * You use this operation only to create a new app monitor. To update an existing app monitor, use [UpdateAppMonitor](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_UpdateAppMonitor.html) instead.
 *
 * After you create an app monitor, sign in to the CloudWatch RUM console to get the JavaScript code snippet to add to your web application. For more information, see [How do I find a code snippet that I've already generated?](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html)
 */
public suspend inline fun RumClient.createAppMonitor(crossinline block: CreateAppMonitorRequest.Builder.() -> Unit): CreateAppMonitorResponse = createAppMonitor(CreateAppMonitorRequest.Builder().apply(block).build())

/**
 * Deletes an existing app monitor. This immediately stops the collection of data.
 */
public suspend inline fun RumClient.deleteAppMonitor(crossinline block: DeleteAppMonitorRequest.Builder.() -> Unit): DeleteAppMonitorResponse = deleteAppMonitor(DeleteAppMonitorRequest.Builder().apply(block).build())

/**
 * Removes the association of a resource-based policy from an app monitor.
 */
public suspend inline fun RumClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a destination for CloudWatch RUM extended metrics, so that the specified app monitor stops sending extended metrics to that destination.
 */
public suspend inline fun RumClient.deleteRumMetricsDestination(crossinline block: DeleteRumMetricsDestinationRequest.Builder.() -> Unit): DeleteRumMetricsDestinationResponse = deleteRumMetricsDestination(DeleteRumMetricsDestinationRequest.Builder().apply(block).build())

/**
 * Retrieves the complete configuration information for one app monitor.
 */
public suspend inline fun RumClient.getAppMonitor(crossinline block: GetAppMonitorRequest.Builder.() -> Unit): GetAppMonitorResponse = getAppMonitor(GetAppMonitorRequest.Builder().apply(block).build())

/**
 * Retrieves the raw performance events that RUM has collected from your web application, so that you can do your own processing or analysis of this data.
 */
public suspend inline fun RumClient.getAppMonitorData(crossinline block: GetAppMonitorDataRequest.Builder.() -> Unit): GetAppMonitorDataResponse = getAppMonitorData(GetAppMonitorDataRequest.Builder().apply(block).build())

/**
 * Use this operation to retrieve information about a resource-based policy that is attached to an app monitor.
 */
public suspend inline fun RumClient.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit): GetResourcePolicyResponse = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * Returns a list of the Amazon CloudWatch RUM app monitors in the account.
 */
public suspend inline fun RumClient.listAppMonitors(crossinline block: ListAppMonitorsRequest.Builder.() -> Unit): ListAppMonitorsResponse = listAppMonitors(ListAppMonitorsRequest.Builder().apply(block).build())

/**
 * Returns a list of destinations that you have created to receive RUM extended metrics, for the specified app monitor.
 *
 * For more information about extended metrics, see [AddRumMetrics](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_AddRumMetrcs.html).
 */
public suspend inline fun RumClient.listRumMetricsDestinations(crossinline block: ListRumMetricsDestinationsRequest.Builder.() -> Unit): ListRumMetricsDestinationsResponse = listRumMetricsDestinations(ListRumMetricsDestinationsRequest.Builder().apply(block).build())

/**
 * Displays the tags associated with a CloudWatch RUM resource.
 */
public suspend inline fun RumClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Use this operation to assign a resource-based policy to a CloudWatch RUM app monitor to control access to it. Each app monitor can have one resource-based policy. The maximum size of the policy is 4 KB. To learn more about using resource policies with RUM, see [Using resource-based policies with CloudWatch RUM](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html).
 */
public suspend inline fun RumClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Sends telemetry events about your application performance and user behavior to CloudWatch RUM. The code snippet that RUM generates for you to add to your application includes `PutRumEvents` operations to send this data to RUM.
 *
 * Each `PutRumEvents` operation can send a batch of events from one user session.
 */
public suspend inline fun RumClient.putRumEvents(crossinline block: PutRumEventsRequest.Builder.() -> Unit): PutRumEventsResponse = putRumEvents(PutRumEventsRequest.Builder().apply(block).build())

/**
 * Creates or updates a destination to receive extended metrics from CloudWatch RUM. You can send extended metrics to CloudWatch or to a CloudWatch Evidently experiment.
 *
 * For more information about extended metrics, see [BatchCreateRumMetricDefinitions](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_BatchCreateRumMetricDefinitions.html).
 */
public suspend inline fun RumClient.putRumMetricsDestination(crossinline block: PutRumMetricsDestinationRequest.Builder.() -> Unit): PutRumMetricsDestinationResponse = putRumMetricsDestination(PutRumMetricsDestinationRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified CloudWatch RUM resource. Currently, the only resources that can be tagged app monitors.
 *
 * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
 *
 * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.
 *
 * You can use the `TagResource` action with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
 *
 * You can associate as many as 50 tags with a resource.
 *
 * For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
 */
public suspend inline fun RumClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified resource.
 */
public suspend inline fun RumClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the configuration of an existing app monitor. When you use this operation, only the parts of the app monitor configuration that you specify in this operation are changed. For any parameters that you omit, the existing values are kept.
 *
 * You can't use this operation to change the tags of an existing app monitor. To change the tags of an existing app monitor, use [TagResource](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_TagResource.html).
 *
 * To create a new app monitor, use [CreateAppMonitor](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_CreateAppMonitor.html).
 *
 * After you update an app monitor, sign in to the CloudWatch RUM console to get the updated JavaScript code snippet to add to your web application. For more information, see [How do I find a code snippet that I've already generated?](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html)
 */
public suspend inline fun RumClient.updateAppMonitor(crossinline block: UpdateAppMonitorRequest.Builder.() -> Unit): UpdateAppMonitorResponse = updateAppMonitor(UpdateAppMonitorRequest.Builder().apply(block).build())

/**
 * Modifies one existing metric definition for CloudWatch RUM extended metrics. For more information about extended metrics, see [BatchCreateRumMetricsDefinitions](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_BatchCreateRumMetricsDefinitions.html).
 */
public suspend inline fun RumClient.updateRumMetricDefinition(crossinline block: UpdateRumMetricDefinitionRequest.Builder.() -> Unit): UpdateRumMetricDefinitionResponse = updateRumMetricDefinition(UpdateRumMetricDefinitionRequest.Builder().apply(block).build())
