// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.serde

import aws.sdk.kotlin.services.rum.model.AppMonitorDetails
import aws.sdk.kotlin.services.rum.model.PutRumEventsRequest
import aws.sdk.kotlin.services.rum.model.RumEvent
import aws.sdk.kotlin.services.rum.model.UserDetails
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PutRumEventsOperationSerializer: HttpSerializer.NonStreaming<PutRumEventsRequest> {
    override fun serialize(context: ExecutionContext, input: PutRumEventsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            require(input.id.isNotBlank() == true) { "id is bound to the URI and must be a non-blank value" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("appmonitors"))
                add(PercentEncoding.SmithyLabel.encode(input.id))
            }
        }

        val payload = serializePutRumEventsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePutRumEventsOperationBody(context: ExecutionContext, input: PutRumEventsRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Alias"))
    val APPMONITORDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AppMonitorDetails"))
    val BATCHID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BatchId"))
    val RUMEVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RumEvents"))
    val USERDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UserDetails"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALIAS_DESCRIPTOR)
        field(APPMONITORDETAILS_DESCRIPTOR)
        field(BATCHID_DESCRIPTOR)
        field(RUMEVENTS_DESCRIPTOR)
        field(USERDETAILS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.alias?.let { field(ALIAS_DESCRIPTOR, it) }
        input.appMonitorDetails?.let { field(APPMONITORDETAILS_DESCRIPTOR, it, ::serializeAppMonitorDetailsDocument) }
        field(BATCHID_DESCRIPTOR, input.batchId)
        listField(RUMEVENTS_DESCRIPTOR) {
            for (el0 in input.rumEvents) {
                serializeSdkSerializable(asSdkSerializable(el0, ::serializeRumEventDocument))
            }
        }
        input.userDetails?.let { field(USERDETAILS_DESCRIPTOR, it, ::serializeUserDetailsDocument) }
    }
    return serializer.toByteArray()
}
