// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateRumMetricDefinitionRequest private constructor(builder: Builder) {
    /**
     * The name of the CloudWatch RUM app monitor that sends these metrics.
     */
    public val appMonitorName: kotlin.String = requireNotNull(builder.appMonitorName) { "A non-null value must be provided for appMonitorName" }
    /**
     * The destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to write to the experiment.
     */
    public val destination: aws.sdk.kotlin.services.rum.model.MetricDestination = requireNotNull(builder.destination) { "A non-null value must be provided for destination" }
    /**
     * This parameter is required if `Destination` is `Evidently`. If `Destination` is `CloudWatch`, do not use this parameter.
     *
     * This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must have already defined this experiment as a valid destination. For more information, see [PutRumMetricsDestination](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html).
     */
    public val destinationArn: kotlin.String? = builder.destinationArn
    /**
     * A structure that contains the new definition that you want to use for this metric.
     */
    public val metricDefinition: aws.sdk.kotlin.services.rum.model.MetricDefinitionRequest? = builder.metricDefinition
    /**
     * The ID of the metric definition to update.
     */
    public val metricDefinitionId: kotlin.String = requireNotNull(builder.metricDefinitionId) { "A non-null value must be provided for metricDefinitionId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.UpdateRumMetricDefinitionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRumMetricDefinitionRequest(")
        append("appMonitorName=$appMonitorName,")
        append("destination=$destination,")
        append("destinationArn=$destinationArn,")
        append("metricDefinition=$metricDefinition,")
        append("metricDefinitionId=$metricDefinitionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appMonitorName.hashCode()
        result = 31 * result + (destination.hashCode())
        result = 31 * result + (destinationArn?.hashCode() ?: 0)
        result = 31 * result + (metricDefinition?.hashCode() ?: 0)
        result = 31 * result + (metricDefinitionId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRumMetricDefinitionRequest

        if (appMonitorName != other.appMonitorName) return false
        if (destination != other.destination) return false
        if (destinationArn != other.destinationArn) return false
        if (metricDefinition != other.metricDefinition) return false
        if (metricDefinitionId != other.metricDefinitionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.UpdateRumMetricDefinitionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the CloudWatch RUM app monitor that sends these metrics.
         */
        public var appMonitorName: kotlin.String? = null
        /**
         * The destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to write to the experiment.
         */
        public var destination: aws.sdk.kotlin.services.rum.model.MetricDestination? = null
        /**
         * This parameter is required if `Destination` is `Evidently`. If `Destination` is `CloudWatch`, do not use this parameter.
         *
         * This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must have already defined this experiment as a valid destination. For more information, see [PutRumMetricsDestination](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html).
         */
        public var destinationArn: kotlin.String? = null
        /**
         * A structure that contains the new definition that you want to use for this metric.
         */
        public var metricDefinition: aws.sdk.kotlin.services.rum.model.MetricDefinitionRequest? = null
        /**
         * The ID of the metric definition to update.
         */
        public var metricDefinitionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.UpdateRumMetricDefinitionRequest) : this() {
            this.appMonitorName = x.appMonitorName
            this.destination = x.destination
            this.destinationArn = x.destinationArn
            this.metricDefinition = x.metricDefinition
            this.metricDefinitionId = x.metricDefinitionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.UpdateRumMetricDefinitionRequest = UpdateRumMetricDefinitionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rum.model.MetricDefinitionRequest] inside the given [block]
         */
        public fun metricDefinition(block: aws.sdk.kotlin.services.rum.model.MetricDefinitionRequest.Builder.() -> kotlin.Unit) {
            this.metricDefinition = aws.sdk.kotlin.services.rum.model.MetricDefinitionRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (appMonitorName == null) appMonitorName = ""
            if (destination == null) destination = MetricDestination.SdkUnknown("no value provided")
            if (metricDefinitionId == null) metricDefinitionId = ""
            return this
        }
    }
}
