// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateAppMonitorRequest private constructor(builder: Builder) {
    /**
     * A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include `AppMonitorConfiguration`, you must set up your own authorization method. For more information, see [Authorize your application to send data to Amazon Web Services](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html).
     */
    public val appMonitorConfiguration: aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration? = builder.appMonitorConfiguration
    /**
     * Specifies whether this app monitor allows the web client to define and send custom events. The default is for custom events to be `DISABLED`.
     *
     * For more information about custom events, see [Send custom events](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-events.html).
     */
    public val customEvents: aws.sdk.kotlin.services.rum.model.CustomEvents? = builder.customEvents
    /**
     * Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
     */
    public val cwLogEnabled: kotlin.Boolean? = builder.cwLogEnabled
    /**
     * A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
     */
    public val deobfuscationConfiguration: aws.sdk.kotlin.services.rum.model.DeobfuscationConfiguration? = builder.deobfuscationConfiguration
    /**
     * The top-level internet domain name for which your application has administrative authority.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * List the domain names for which your application has administrative authority. The `UpdateAppMonitor` allows either the domain or the domain list.
     */
    public val domainList: List<String>? = builder.domainList
    /**
     * The name of the app monitor to update.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.UpdateAppMonitorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAppMonitorRequest(")
        append("appMonitorConfiguration=$appMonitorConfiguration,")
        append("customEvents=$customEvents,")
        append("cwLogEnabled=$cwLogEnabled,")
        append("deobfuscationConfiguration=$deobfuscationConfiguration,")
        append("domain=$domain,")
        append("domainList=$domainList,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appMonitorConfiguration?.hashCode() ?: 0
        result = 31 * result + (customEvents?.hashCode() ?: 0)
        result = 31 * result + (cwLogEnabled?.hashCode() ?: 0)
        result = 31 * result + (deobfuscationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainList?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAppMonitorRequest

        if (appMonitorConfiguration != other.appMonitorConfiguration) return false
        if (customEvents != other.customEvents) return false
        if (cwLogEnabled != other.cwLogEnabled) return false
        if (deobfuscationConfiguration != other.deobfuscationConfiguration) return false
        if (domain != other.domain) return false
        if (domainList != other.domainList) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.UpdateAppMonitorRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include `AppMonitorConfiguration`, you must set up your own authorization method. For more information, see [Authorize your application to send data to Amazon Web Services](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html).
         */
        public var appMonitorConfiguration: aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration? = null
        /**
         * Specifies whether this app monitor allows the web client to define and send custom events. The default is for custom events to be `DISABLED`.
         *
         * For more information about custom events, see [Send custom events](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-events.html).
         */
        public var customEvents: aws.sdk.kotlin.services.rum.model.CustomEvents? = null
        /**
         * Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
         */
        public var cwLogEnabled: kotlin.Boolean? = null
        /**
         * A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
         */
        public var deobfuscationConfiguration: aws.sdk.kotlin.services.rum.model.DeobfuscationConfiguration? = null
        /**
         * The top-level internet domain name for which your application has administrative authority.
         */
        public var domain: kotlin.String? = null
        /**
         * List the domain names for which your application has administrative authority. The `UpdateAppMonitor` allows either the domain or the domain list.
         */
        public var domainList: List<String>? = null
        /**
         * The name of the app monitor to update.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.UpdateAppMonitorRequest) : this() {
            this.appMonitorConfiguration = x.appMonitorConfiguration
            this.customEvents = x.customEvents
            this.cwLogEnabled = x.cwLogEnabled
            this.deobfuscationConfiguration = x.deobfuscationConfiguration
            this.domain = x.domain
            this.domainList = x.domainList
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.UpdateAppMonitorRequest = UpdateAppMonitorRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration] inside the given [block]
         */
        public fun appMonitorConfiguration(block: aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration.Builder.() -> kotlin.Unit) {
            this.appMonitorConfiguration = aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rum.model.CustomEvents] inside the given [block]
         */
        public fun customEvents(block: aws.sdk.kotlin.services.rum.model.CustomEvents.Builder.() -> kotlin.Unit) {
            this.customEvents = aws.sdk.kotlin.services.rum.model.CustomEvents.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rum.model.DeobfuscationConfiguration] inside the given [block]
         */
        public fun deobfuscationConfiguration(block: aws.sdk.kotlin.services.rum.model.DeobfuscationConfiguration.Builder.() -> kotlin.Unit) {
            this.deobfuscationConfiguration = aws.sdk.kotlin.services.rum.model.DeobfuscationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
