// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model

import aws.smithy.kotlin.runtime.SdkDsl

public class BatchCreateRumMetricDefinitionsRequest private constructor(builder: Builder) {
    /**
     * The name of the CloudWatch RUM app monitor that is to send the metrics.
     */
    public val appMonitorName: kotlin.String = requireNotNull(builder.appMonitorName) { "A non-null value must be provided for appMonitorName" }
    /**
     * The destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the Amazon Resource Name (ARN) of the CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to write to the experiment.
     */
    public val destination: aws.sdk.kotlin.services.rum.model.MetricDestination = requireNotNull(builder.destination) { "A non-null value must be provided for destination" }
    /**
     * This parameter is required if `Destination` is `Evidently`. If `Destination` is `CloudWatch`, do not use this parameter.
     *
     * This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must have already defined this experiment as a valid destination. For more information, see [PutRumMetricsDestination](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html).
     */
    public val destinationArn: kotlin.String? = builder.destinationArn
    /**
     * An array of structures which define the metrics that you want to send.
     */
    public val metricDefinitions: List<MetricDefinitionRequest> = requireNotNull(builder.metricDefinitions) { "A non-null value must be provided for metricDefinitions" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.BatchCreateRumMetricDefinitionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchCreateRumMetricDefinitionsRequest(")
        append("appMonitorName=$appMonitorName,")
        append("destination=$destination,")
        append("destinationArn=$destinationArn,")
        append("metricDefinitions=$metricDefinitions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appMonitorName.hashCode()
        result = 31 * result + (destination.hashCode())
        result = 31 * result + (destinationArn?.hashCode() ?: 0)
        result = 31 * result + (metricDefinitions.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchCreateRumMetricDefinitionsRequest

        if (appMonitorName != other.appMonitorName) return false
        if (destination != other.destination) return false
        if (destinationArn != other.destinationArn) return false
        if (metricDefinitions != other.metricDefinitions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.BatchCreateRumMetricDefinitionsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the CloudWatch RUM app monitor that is to send the metrics.
         */
        public var appMonitorName: kotlin.String? = null
        /**
         * The destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the Amazon Resource Name (ARN) of the CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to write to the experiment.
         */
        public var destination: aws.sdk.kotlin.services.rum.model.MetricDestination? = null
        /**
         * This parameter is required if `Destination` is `Evidently`. If `Destination` is `CloudWatch`, do not use this parameter.
         *
         * This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must have already defined this experiment as a valid destination. For more information, see [PutRumMetricsDestination](https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html).
         */
        public var destinationArn: kotlin.String? = null
        /**
         * An array of structures which define the metrics that you want to send.
         */
        public var metricDefinitions: List<MetricDefinitionRequest>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.BatchCreateRumMetricDefinitionsRequest) : this() {
            this.appMonitorName = x.appMonitorName
            this.destination = x.destination
            this.destinationArn = x.destinationArn
            this.metricDefinitions = x.metricDefinitions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.BatchCreateRumMetricDefinitionsRequest = BatchCreateRumMetricDefinitionsRequest(this)

        internal fun correctErrors(): Builder {
            if (appMonitorName == null) appMonitorName = ""
            if (destination == null) destination = MetricDestination.SdkUnknown("no value provided")
            if (metricDefinitions == null) metricDefinitions = emptyList()
            return this
        }
    }
}
