// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateResolverEndpointRequest private constructor(builder: Builder) {
    /**
     * The name of the Resolver endpoint that you want to update.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The protocols you want to use for the endpoint. DoH-FIPS is applicable for default inbound endpoints only.
     *
     * For a default inbound endpoint you can apply the protocols as follows:
     * +  Do53 and DoH in combination.
     * + Do53 and DoH-FIPS in combination.
     * + Do53 alone.
     * + DoH alone.
     * + DoH-FIPS alone.
     * + None, which is treated as Do53.
     *
     * For a delegation inbound endpoint you can use Do53 only.
     *
     * For an outbound endpoint you can apply the protocols as follows:
     * +  Do53 and DoH in combination.
     * + Do53 alone.
     * + DoH alone.
     * + None, which is treated as Do53.
     *
     *  You can't change the protocol of an inbound endpoint directly from only Do53 to only DoH, or DoH-FIPS. This is to prevent a sudden disruption to incoming traffic that relies on Do53. To change the protocol from Do53 to DoH, or DoH-FIPS, you must first enable both Do53 and DoH, or Do53 and DoH-FIPS, to make sure that all incoming traffic has transferred to using the DoH protocol, or DoH-FIPS, and then remove the Do53.
     */
    public val protocols: List<Protocol>? = builder.protocols
    /**
     * The ID of the Resolver endpoint that you want to update.
     */
    public val resolverEndpointId: kotlin.String? = builder.resolverEndpointId
    /**
     * Specifies the endpoint type for what type of IP address the endpoint uses to forward DNS queries.
     *
     * Updating to `IPV6` type isn't currently supported.
     */
    public val resolverEndpointType: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointType? = builder.resolverEndpointType
    /**
     * Specifies the IPv6 address when you update the Resolver endpoint from IPv4 to dual-stack. If you don't specify an IPv6 address, one will be automatically chosen from your subnet.
     */
    public val updateIpAddresses: List<UpdateIpAddress>? = builder.updateIpAddresses

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.UpdateResolverEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateResolverEndpointRequest(")
        append("name=$name,")
        append("protocols=$protocols,")
        append("resolverEndpointId=$resolverEndpointId,")
        append("resolverEndpointType=$resolverEndpointType,")
        append("updateIpAddresses=$updateIpAddresses")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (protocols?.hashCode() ?: 0)
        result = 31 * result + (resolverEndpointId?.hashCode() ?: 0)
        result = 31 * result + (resolverEndpointType?.hashCode() ?: 0)
        result = 31 * result + (updateIpAddresses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateResolverEndpointRequest

        if (name != other.name) return false
        if (protocols != other.protocols) return false
        if (resolverEndpointId != other.resolverEndpointId) return false
        if (resolverEndpointType != other.resolverEndpointType) return false
        if (updateIpAddresses != other.updateIpAddresses) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.UpdateResolverEndpointRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Resolver endpoint that you want to update.
         */
        public var name: kotlin.String? = null
        /**
         * The protocols you want to use for the endpoint. DoH-FIPS is applicable for default inbound endpoints only.
         *
         * For a default inbound endpoint you can apply the protocols as follows:
         * +  Do53 and DoH in combination.
         * + Do53 and DoH-FIPS in combination.
         * + Do53 alone.
         * + DoH alone.
         * + DoH-FIPS alone.
         * + None, which is treated as Do53.
         *
         * For a delegation inbound endpoint you can use Do53 only.
         *
         * For an outbound endpoint you can apply the protocols as follows:
         * +  Do53 and DoH in combination.
         * + Do53 alone.
         * + DoH alone.
         * + None, which is treated as Do53.
         *
         *  You can't change the protocol of an inbound endpoint directly from only Do53 to only DoH, or DoH-FIPS. This is to prevent a sudden disruption to incoming traffic that relies on Do53. To change the protocol from Do53 to DoH, or DoH-FIPS, you must first enable both Do53 and DoH, or Do53 and DoH-FIPS, to make sure that all incoming traffic has transferred to using the DoH protocol, or DoH-FIPS, and then remove the Do53.
         */
        public var protocols: List<Protocol>? = null
        /**
         * The ID of the Resolver endpoint that you want to update.
         */
        public var resolverEndpointId: kotlin.String? = null
        /**
         * Specifies the endpoint type for what type of IP address the endpoint uses to forward DNS queries.
         *
         * Updating to `IPV6` type isn't currently supported.
         */
        public var resolverEndpointType: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointType? = null
        /**
         * Specifies the IPv6 address when you update the Resolver endpoint from IPv4 to dual-stack. If you don't specify an IPv6 address, one will be automatically chosen from your subnet.
         */
        public var updateIpAddresses: List<UpdateIpAddress>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.UpdateResolverEndpointRequest) : this() {
            this.name = x.name
            this.protocols = x.protocols
            this.resolverEndpointId = x.resolverEndpointId
            this.resolverEndpointType = x.resolverEndpointType
            this.updateIpAddresses = x.updateIpAddresses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.UpdateResolverEndpointRequest = UpdateResolverEndpointRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
