// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * In the response to a [CreateResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html), [DeleteResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverEndpoint.html), [GetResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html), Updates the name, or ResolverEndpointType for an endpoint, or [UpdateResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html) request, a complex type that contains settings for an existing inbound or outbound Resolver endpoint.
 */
public class ResolverEndpoint private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) for the Resolver endpoint.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the endpoint was created, in Unix time format and Coordinated Universal Time (UTC).
     */
    public val creationTime: kotlin.String? = builder.creationTime
    /**
     * A unique string that identifies the request that created the Resolver endpoint. The `CreatorRequestId` allows failed requests to be retried without the risk of running the operation twice.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:
     * + `INBOUND`: allows DNS queries to your VPC from your network
     * + `OUTBOUND`: allows DNS queries from your VPC to your network
     * + `INBOUND_DELEGATION`: Resolver delegates queries to Route 53 private hosted zones from your network.
     */
    public val direction: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointDirection? = builder.direction
    /**
     * The ID of the VPC that you want to create the Resolver endpoint in.
     */
    public val hostVpcId: kotlin.String? = builder.hostVpcId
    /**
     * The ID of the Resolver endpoint.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The number of IP addresses that the Resolver endpoint can use for DNS queries.
     */
    public val ipAddressCount: kotlin.Int? = builder.ipAddressCount
    /**
     * The date and time that the endpoint was last modified, in Unix time format and Coordinated Universal Time (UTC).
     */
    public val modificationTime: kotlin.String? = builder.modificationTime
    /**
     * The name that you assigned to the Resolver endpoint when you submitted a [CreateResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html) request.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN (Amazon Resource Name) for the Outpost.
     */
    public val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The Amazon EC2 instance type.
     */
    public val preferredInstanceType: kotlin.String? = builder.preferredInstanceType
    /**
     * Protocols used for the endpoint. DoH-FIPS is applicable for a default inbound endpoints only.
     *
     * For an inbound endpoint you can apply the protocols as follows:
     * +  Do53 and DoH in combination.
     * + Do53 and DoH-FIPS in combination.
     * + Do53 alone.
     * + DoH alone.
     * + DoH-FIPS alone.
     * + None, which is treated as Do53.
     *
     * For a delegation inbound endpoint you can use Do53 only.
     *
     * For an outbound endpoint you can apply the protocols as follows:
     * +  Do53 and DoH in combination.
     * + Do53 alone.
     * + DoH alone.
     * + None, which is treated as Do53.
     */
    public val protocols: List<Protocol>? = builder.protocols
    /**
     * The Resolver endpoint IP address type.
     */
    public val resolverEndpointType: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointType? = builder.resolverEndpointType
    /**
     * The ID of one or more security groups that control access to this VPC. The security group must include one or more inbound rules (for inbound endpoints) or outbound rules (for outbound endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A code that specifies the current status of the Resolver endpoint. Valid values include the following:
     * + `CREATING`: Resolver is creating and configuring one or more Amazon VPC network interfaces for this endpoint.
     * + `OPERATIONAL`: The Amazon VPC network interfaces for this endpoint are correctly configured and able to pass inbound or outbound DNS queries between your network and Resolver.
     * + `UPDATING`: Resolver is associating or disassociating one or more network interfaces with this endpoint.
     * + `AUTO_RECOVERING`: Resolver is trying to recover one or more of the network interfaces that are associated with this endpoint. During the recovery process, the endpoint functions with limited capacity because of the limit on the number of DNS queries per IP address (per network interface). For the current limit, see [Limits on Route 53 Resolver](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html#limits-api-entities-resolver).
     * + `ACTION_NEEDED`: This endpoint is unhealthy, and Resolver can't automatically recover it. To resolve the problem, we recommend that you check each IP address that you associated with the endpoint. For each IP address that isn't available, add another IP address and then delete the IP address that isn't available. (An endpoint must always include at least two IP addresses.) A status of `ACTION_NEEDED` can have a variety of causes. Here are two common causes:
     *    + One or more of the network interfaces that are associated with the endpoint were deleted using Amazon VPC.
     *    + The network interface couldn't be created for some reason that's outside the control of Resolver.
     * + `DELETING`: Resolver is deleting this endpoint and the associated network interfaces.
     */
    public val status: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointStatus? = builder.status
    /**
     * A detailed description of the status of the Resolver endpoint.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ResolverEndpoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResolverEndpoint(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("creatorRequestId=$creatorRequestId,")
        append("direction=$direction,")
        append("hostVpcId=$hostVpcId,")
        append("id=$id,")
        append("ipAddressCount=$ipAddressCount,")
        append("modificationTime=$modificationTime,")
        append("name=$name,")
        append("outpostArn=$outpostArn,")
        append("preferredInstanceType=$preferredInstanceType,")
        append("protocols=$protocols,")
        append("resolverEndpointType=$resolverEndpointType,")
        append("securityGroupIds=$securityGroupIds,")
        append("status=$status,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (direction?.hashCode() ?: 0)
        result = 31 * result + (hostVpcId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (ipAddressCount ?: 0)
        result = 31 * result + (modificationTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (preferredInstanceType?.hashCode() ?: 0)
        result = 31 * result + (protocols?.hashCode() ?: 0)
        result = 31 * result + (resolverEndpointType?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResolverEndpoint

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (direction != other.direction) return false
        if (hostVpcId != other.hostVpcId) return false
        if (id != other.id) return false
        if (ipAddressCount != other.ipAddressCount) return false
        if (modificationTime != other.modificationTime) return false
        if (name != other.name) return false
        if (outpostArn != other.outpostArn) return false
        if (preferredInstanceType != other.preferredInstanceType) return false
        if (protocols != other.protocols) return false
        if (resolverEndpointType != other.resolverEndpointType) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ResolverEndpoint = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN (Amazon Resource Name) for the Resolver endpoint.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the endpoint was created, in Unix time format and Coordinated Universal Time (UTC).
         */
        public var creationTime: kotlin.String? = null
        /**
         * A unique string that identifies the request that created the Resolver endpoint. The `CreatorRequestId` allows failed requests to be retried without the risk of running the operation twice.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:
         * + `INBOUND`: allows DNS queries to your VPC from your network
         * + `OUTBOUND`: allows DNS queries from your VPC to your network
         * + `INBOUND_DELEGATION`: Resolver delegates queries to Route 53 private hosted zones from your network.
         */
        public var direction: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointDirection? = null
        /**
         * The ID of the VPC that you want to create the Resolver endpoint in.
         */
        public var hostVpcId: kotlin.String? = null
        /**
         * The ID of the Resolver endpoint.
         */
        public var id: kotlin.String? = null
        /**
         * The number of IP addresses that the Resolver endpoint can use for DNS queries.
         */
        public var ipAddressCount: kotlin.Int? = null
        /**
         * The date and time that the endpoint was last modified, in Unix time format and Coordinated Universal Time (UTC).
         */
        public var modificationTime: kotlin.String? = null
        /**
         * The name that you assigned to the Resolver endpoint when you submitted a [CreateResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html) request.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN (Amazon Resource Name) for the Outpost.
         */
        public var outpostArn: kotlin.String? = null
        /**
         * The Amazon EC2 instance type.
         */
        public var preferredInstanceType: kotlin.String? = null
        /**
         * Protocols used for the endpoint. DoH-FIPS is applicable for a default inbound endpoints only.
         *
         * For an inbound endpoint you can apply the protocols as follows:
         * +  Do53 and DoH in combination.
         * + Do53 and DoH-FIPS in combination.
         * + Do53 alone.
         * + DoH alone.
         * + DoH-FIPS alone.
         * + None, which is treated as Do53.
         *
         * For a delegation inbound endpoint you can use Do53 only.
         *
         * For an outbound endpoint you can apply the protocols as follows:
         * +  Do53 and DoH in combination.
         * + Do53 alone.
         * + DoH alone.
         * + None, which is treated as Do53.
         */
        public var protocols: List<Protocol>? = null
        /**
         * The Resolver endpoint IP address type.
         */
        public var resolverEndpointType: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointType? = null
        /**
         * The ID of one or more security groups that control access to this VPC. The security group must include one or more inbound rules (for inbound endpoints) or outbound rules (for outbound endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * A code that specifies the current status of the Resolver endpoint. Valid values include the following:
         * + `CREATING`: Resolver is creating and configuring one or more Amazon VPC network interfaces for this endpoint.
         * + `OPERATIONAL`: The Amazon VPC network interfaces for this endpoint are correctly configured and able to pass inbound or outbound DNS queries between your network and Resolver.
         * + `UPDATING`: Resolver is associating or disassociating one or more network interfaces with this endpoint.
         * + `AUTO_RECOVERING`: Resolver is trying to recover one or more of the network interfaces that are associated with this endpoint. During the recovery process, the endpoint functions with limited capacity because of the limit on the number of DNS queries per IP address (per network interface). For the current limit, see [Limits on Route 53 Resolver](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html#limits-api-entities-resolver).
         * + `ACTION_NEEDED`: This endpoint is unhealthy, and Resolver can't automatically recover it. To resolve the problem, we recommend that you check each IP address that you associated with the endpoint. For each IP address that isn't available, add another IP address and then delete the IP address that isn't available. (An endpoint must always include at least two IP addresses.) A status of `ACTION_NEEDED` can have a variety of causes. Here are two common causes:
         *    + One or more of the network interfaces that are associated with the endpoint were deleted using Amazon VPC.
         *    + The network interface couldn't be created for some reason that's outside the control of Resolver.
         * + `DELETING`: Resolver is deleting this endpoint and the associated network interfaces.
         */
        public var status: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointStatus? = null
        /**
         * A detailed description of the status of the Resolver endpoint.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpoint) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.creatorRequestId = x.creatorRequestId
            this.direction = x.direction
            this.hostVpcId = x.hostVpcId
            this.id = x.id
            this.ipAddressCount = x.ipAddressCount
            this.modificationTime = x.modificationTime
            this.name = x.name
            this.outpostArn = x.outpostArn
            this.preferredInstanceType = x.preferredInstanceType
            this.protocols = x.protocols
            this.resolverEndpointType = x.resolverEndpointType
            this.securityGroupIds = x.securityGroupIds
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ResolverEndpoint = ResolverEndpoint(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
