// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A complex type that contains information about a Resolver configuration for a VPC.
 */
public class ResolverConfig private constructor(builder: Builder) {
    /**
     * The status of whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is enabled by default. The status can be one of following:
     * + **ENABLING:** Autodefined rules for reverse DNS lookups are being enabled but are not complete.
     * + **ENABLED:** Autodefined rules for reverse DNS lookups are enabled.
     * + **DISABLING:** Autodefined rules for reverse DNS lookups are being disabled but are not complete.
     * + **DISABLED:** Autodefined rules for reverse DNS lookups are disabled.
     */
    public val autodefinedReverse: aws.sdk.kotlin.services.route53resolver.model.ResolverAutodefinedReverseStatus? = builder.autodefinedReverse
    /**
     * ID for the Resolver configuration.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The owner account ID of the Amazon Virtual Private Cloud VPC.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The ID of the Amazon Virtual Private Cloud VPC or a Route 53 Profile that you're configuring Resolver for.
     */
    public val resourceId: kotlin.String? = builder.resourceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ResolverConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResolverConfig(")
        append("autodefinedReverse=$autodefinedReverse,")
        append("id=$id,")
        append("ownerId=$ownerId,")
        append("resourceId=$resourceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autodefinedReverse?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResolverConfig

        if (autodefinedReverse != other.autodefinedReverse) return false
        if (id != other.id) return false
        if (ownerId != other.ownerId) return false
        if (resourceId != other.resourceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ResolverConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The status of whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is enabled by default. The status can be one of following:
         * + **ENABLING:** Autodefined rules for reverse DNS lookups are being enabled but are not complete.
         * + **ENABLED:** Autodefined rules for reverse DNS lookups are enabled.
         * + **DISABLING:** Autodefined rules for reverse DNS lookups are being disabled but are not complete.
         * + **DISABLED:** Autodefined rules for reverse DNS lookups are disabled.
         */
        public var autodefinedReverse: aws.sdk.kotlin.services.route53resolver.model.ResolverAutodefinedReverseStatus? = null
        /**
         * ID for the Resolver configuration.
         */
        public var id: kotlin.String? = null
        /**
         * The owner account ID of the Amazon Virtual Private Cloud VPC.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The ID of the Amazon Virtual Private Cloud VPC or a Route 53 Profile that you're configuring Resolver for.
         */
        public var resourceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ResolverConfig) : this() {
            this.autodefinedReverse = x.autodefinedReverse
            this.id = x.id
            this.ownerId = x.ownerId
            this.resourceId = x.resourceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ResolverConfig = ResolverConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
