// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListFirewallRulesRequest private constructor(builder: Builder) {
    /**
     * Optional additional filter for the rules to retrieve.
     *
     * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list, or a threat in a DNS Firewall Advanced rule:
     * + `ALLOW` - Permit the request to go through. Not availabe for DNS Firewall Advanced rules.
     * + `ALERT` - Permit the request to go through but send an alert to the logs.
     * + `BLOCK` - Disallow the request. If this is specified, additional handling details are provided in the rule's `BlockResponse` setting.
     */
    public val action: aws.sdk.kotlin.services.route53resolver.model.Action? = builder.action
    /**
     * The unique identifier of the firewall rule group that you want to retrieve the rules for.
     */
    public val firewallRuleGroupId: kotlin.String? = builder.firewallRuleGroupId
    /**
     * The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a `NextToken` value that you can use in a subsequent call to get the next batch of objects.
     *
     * If you don't specify a value for `MaxResults`, Resolver returns up to 100 objects.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * For the first call to this list request, omit this value.
     *
     * When you request a list of objects, Resolver returns at most the number of objects specified in `MaxResults`. If more objects are available for retrieval, Resolver returns a `NextToken` value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Optional additional filter for the rules to retrieve.
     *
     * The setting that determines the processing order of the rules in a rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
     */
    public val priority: kotlin.Int? = builder.priority

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ListFirewallRulesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListFirewallRulesRequest(")
        append("action=$action,")
        append("firewallRuleGroupId=$firewallRuleGroupId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("priority=$priority")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (firewallRuleGroupId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListFirewallRulesRequest

        if (action != other.action) return false
        if (firewallRuleGroupId != other.firewallRuleGroupId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (priority != other.priority) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ListFirewallRulesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Optional additional filter for the rules to retrieve.
         *
         * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list, or a threat in a DNS Firewall Advanced rule:
         * + `ALLOW` - Permit the request to go through. Not availabe for DNS Firewall Advanced rules.
         * + `ALERT` - Permit the request to go through but send an alert to the logs.
         * + `BLOCK` - Disallow the request. If this is specified, additional handling details are provided in the rule's `BlockResponse` setting.
         */
        public var action: aws.sdk.kotlin.services.route53resolver.model.Action? = null
        /**
         * The unique identifier of the firewall rule group that you want to retrieve the rules for.
         */
        public var firewallRuleGroupId: kotlin.String? = null
        /**
         * The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a `NextToken` value that you can use in a subsequent call to get the next batch of objects.
         *
         * If you don't specify a value for `MaxResults`, Resolver returns up to 100 objects.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * For the first call to this list request, omit this value.
         *
         * When you request a list of objects, Resolver returns at most the number of objects specified in `MaxResults`. If more objects are available for retrieval, Resolver returns a `NextToken` value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Optional additional filter for the rules to retrieve.
         *
         * The setting that determines the processing order of the rules in a rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
         */
        public var priority: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ListFirewallRulesRequest) : this() {
            this.action = x.action
            this.firewallRuleGroupId = x.firewallRuleGroupId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.priority = x.priority
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ListFirewallRulesRequest = ListFirewallRulesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
