// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateOutpostResolverRequest private constructor(builder: Builder) {
    /**
     * A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice.
     *
     * `CreatorRequestId` can be any unique string, for example, a date/time stamp.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * Number of Amazon EC2 instances for the Resolver on Outpost. The default and minimal value is 4.
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the Outpost. If you specify this, you must also specify a value for the `PreferredInstanceType`.
     */
    public val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The Amazon EC2 instance type. If you specify this, you must also specify a value for the `OutpostArn`.
     */
    public val preferredInstanceType: kotlin.String? = builder.preferredInstanceType
    /**
     * A string that helps identify the Route 53 Resolvers on Outpost.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.CreateOutpostResolverRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateOutpostResolverRequest(")
        append("creatorRequestId=$creatorRequestId,")
        append("instanceCount=$instanceCount,")
        append("name=$name,")
        append("outpostArn=$outpostArn,")
        append("preferredInstanceType=$preferredInstanceType,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creatorRequestId?.hashCode() ?: 0
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (preferredInstanceType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateOutpostResolverRequest

        if (creatorRequestId != other.creatorRequestId) return false
        if (instanceCount != other.instanceCount) return false
        if (name != other.name) return false
        if (outpostArn != other.outpostArn) return false
        if (preferredInstanceType != other.preferredInstanceType) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.CreateOutpostResolverRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice.
         *
         * `CreatorRequestId` can be any unique string, for example, a date/time stamp.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * Number of Amazon EC2 instances for the Resolver on Outpost. The default and minimal value is 4.
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost. If you specify this, you must also specify a value for the `PreferredInstanceType`.
         */
        public var outpostArn: kotlin.String? = null
        /**
         * The Amazon EC2 instance type. If you specify this, you must also specify a value for the `OutpostArn`.
         */
        public var preferredInstanceType: kotlin.String? = null
        /**
         * A string that helps identify the Route 53 Resolvers on Outpost.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.CreateOutpostResolverRequest) : this() {
            this.creatorRequestId = x.creatorRequestId
            this.instanceCount = x.instanceCount
            this.name = x.name
            this.outpostArn = x.outpostArn
            this.preferredInstanceType = x.preferredInstanceType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.CreateOutpostResolverRequest = CreateOutpostResolverRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
