// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.serde

import aws.sdk.kotlin.services.route53resolver.model.GetResolverEndpointResponse
import aws.sdk.kotlin.services.route53resolver.model.ResolverEndpoint
import aws.sdk.kotlin.services.route53resolver.model.Route53ResolverException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetResolverEndpointOperationDeserializer: HttpDeserializer.NonStreaming<GetResolverEndpointResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetResolverEndpointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetResolverEndpointError(context, call, payload)
        }
        val builder = GetResolverEndpointResponse.Builder()

        if (payload != null) {
            deserializeGetResolverEndpointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetResolverEndpointError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Route53ResolverException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> Route53ResolverException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetResolverEndpointOperationBody(builder: GetResolverEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESOLVERENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ResolverEndpoint"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESOLVERENDPOINT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESOLVERENDPOINT_DESCRIPTOR.index -> builder.resolverEndpoint = deserializeResolverEndpointDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
