// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateFirewallRuleRequest private constructor(builder: Builder) {
    /**
     * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list, or a threat in a DNS Firewall Advanced rule:
     * + `ALLOW` - Permit the request to go through. Not available for DNS Firewall Advanced rules.
     * + `ALERT` - Permit the request to go through but send an alert to the logs.
     * + `BLOCK` - Disallow the request. This option requires additional details in the rule's `BlockResponse`.
     */
    public val action: aws.sdk.kotlin.services.route53resolver.model.Action? = builder.action
    /**
     * The DNS record's type. This determines the format of the record value that you provided in `BlockOverrideDomain`. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
     */
    public val blockOverrideDnsType: aws.sdk.kotlin.services.route53resolver.model.BlockOverrideDnsType? = builder.blockOverrideDnsType
    /**
     * The custom DNS record to send back in response to the query. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
     */
    public val blockOverrideDomain: kotlin.String? = builder.blockOverrideDomain
    /**
     * The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
     */
    public val blockOverrideTtl: kotlin.Int? = builder.blockOverrideTtl
    /**
     * The way that you want DNS Firewall to block the request. Used for the rule action setting `BLOCK`.
     * + `NODATA` - Respond indicating that the query was successful, but no response is available for it.
     * + `NXDOMAIN` - Respond indicating that the domain name that's in the query doesn't exist.
     * + `OVERRIDE` - Provide a custom override in the response. This option requires custom handling details in the rule's `BlockOverride*` settings.
     */
    public val blockResponse: aws.sdk.kotlin.services.route53resolver.model.BlockResponse? = builder.blockResponse
    /**
     * The confidence threshold for DNS Firewall Advanced. You must provide this value when you create a DNS Firewall Advanced rule. The confidence level values mean:
     * + `LOW`: Provides the highest detection rate for threats, but also increases false positives.
     * + `MEDIUM`: Provides a balance between detecting threats and false positives.
     * + `HIGH`: Detects only the most well corroborated threats with a low rate of false positives.
     */
    public val confidenceThreshold: aws.sdk.kotlin.services.route53resolver.model.ConfidenceThreshold? = builder.confidenceThreshold
    /**
     * The type of the DNS Firewall Advanced rule. Valid values are:
     * + `DGA`: Domain generation algorithms detection. DGAs are used by attackers to generate a large number of domains to to launch malware attacks.
     * + `DNS_TUNNELING`: DNS tunneling detection. DNS tunneling is used by attackers to exfiltrate data from the client by using the DNS tunnel without making a network connection to the client.
     */
    public val dnsThreatProtection: aws.sdk.kotlin.services.route53resolver.model.DnsThreatProtection? = builder.dnsThreatProtection
    /**
     * The ID of the domain list to use in the rule.
     */
    public val firewallDomainListId: kotlin.String? = builder.firewallDomainListId
    /**
     * How you want the the rule to evaluate DNS redirection in the DNS redirection chain, such as CNAME or DNAME.
     *
     * `INSPECT_REDIRECTION_DOMAIN`: (Default) inspects all domains in the redirection chain. The individual domains in the redirection chain must be added to the domain list.
     *
     * `TRUST_REDIRECTION_DOMAIN`: Inspects only the first domain in the redirection chain. You don't need to add the subsequent domains in the domain in the redirection list to the domain list.
     */
    public val firewallDomainRedirectionAction: aws.sdk.kotlin.services.route53resolver.model.FirewallDomainRedirectionAction? = builder.firewallDomainRedirectionAction
    /**
     * The unique identifier of the firewall rule group for the rule.
     */
    public val firewallRuleGroupId: kotlin.String? = builder.firewallRuleGroupId
    /**
     * The DNS Firewall Advanced rule ID.
     */
    public val firewallThreatProtectionId: kotlin.String? = builder.firewallThreatProtectionId
    /**
     * The name of the rule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
     *
     * You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * The DNS query type you want the rule to evaluate. Allowed values are;
     * +  A: Returns an IPv4 address.
     * + AAAA: Returns an Ipv6 address.
     * + CAA: Restricts CAs that can create SSL/TLS certifications for the domain.
     * + CNAME: Returns another domain name.
     * + DS: Record that identifies the DNSSEC signing key of a delegated zone.
     * + MX: Specifies mail servers.
     * + NAPTR: Regular-expression-based rewriting of domain names.
     * + NS: Authoritative name servers.
     * + PTR: Maps an IP address to a domain name.
     * + SOA: Start of authority record for the zone.
     * + SPF: Lists the servers authorized to send emails from a domain.
     * + SRV: Application specific values that identify servers.
     * + TXT: Verifies email senders and application-specific values.
     * + A query type you define by using the DNS type ID, for example 28 for AAAA. The values must be defined as TYPENUMBER, where the NUMBER can be 1-65334, for example, TYPE28. For more information, see [List of DNS record types](https://en.wikipedia.org/wiki/List_of_DNS_record_types).If you set up a firewall BLOCK rule with action NXDOMAIN on query type equals AAAA, this action will not be applied to synthetic IPv6 addresses generated when DNS64 is enabled.
     */
    public val qtype: kotlin.String? = builder.qtype

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFirewallRuleRequest(")
        append("action=$action,")
        append("blockOverrideDnsType=$blockOverrideDnsType,")
        append("blockOverrideDomain=$blockOverrideDomain,")
        append("blockOverrideTtl=$blockOverrideTtl,")
        append("blockResponse=$blockResponse,")
        append("confidenceThreshold=$confidenceThreshold,")
        append("dnsThreatProtection=$dnsThreatProtection,")
        append("firewallDomainListId=$firewallDomainListId,")
        append("firewallDomainRedirectionAction=$firewallDomainRedirectionAction,")
        append("firewallRuleGroupId=$firewallRuleGroupId,")
        append("firewallThreatProtectionId=$firewallThreatProtectionId,")
        append("name=$name,")
        append("priority=$priority,")
        append("qtype=$qtype")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (blockOverrideDnsType?.hashCode() ?: 0)
        result = 31 * result + (blockOverrideDomain?.hashCode() ?: 0)
        result = 31 * result + (blockOverrideTtl ?: 0)
        result = 31 * result + (blockResponse?.hashCode() ?: 0)
        result = 31 * result + (confidenceThreshold?.hashCode() ?: 0)
        result = 31 * result + (dnsThreatProtection?.hashCode() ?: 0)
        result = 31 * result + (firewallDomainListId?.hashCode() ?: 0)
        result = 31 * result + (firewallDomainRedirectionAction?.hashCode() ?: 0)
        result = 31 * result + (firewallRuleGroupId?.hashCode() ?: 0)
        result = 31 * result + (firewallThreatProtectionId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (qtype?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFirewallRuleRequest

        if (action != other.action) return false
        if (blockOverrideDnsType != other.blockOverrideDnsType) return false
        if (blockOverrideDomain != other.blockOverrideDomain) return false
        if (blockOverrideTtl != other.blockOverrideTtl) return false
        if (blockResponse != other.blockResponse) return false
        if (confidenceThreshold != other.confidenceThreshold) return false
        if (dnsThreatProtection != other.dnsThreatProtection) return false
        if (firewallDomainListId != other.firewallDomainListId) return false
        if (firewallDomainRedirectionAction != other.firewallDomainRedirectionAction) return false
        if (firewallRuleGroupId != other.firewallRuleGroupId) return false
        if (firewallThreatProtectionId != other.firewallThreatProtectionId) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (qtype != other.qtype) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallRuleRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list, or a threat in a DNS Firewall Advanced rule:
         * + `ALLOW` - Permit the request to go through. Not available for DNS Firewall Advanced rules.
         * + `ALERT` - Permit the request to go through but send an alert to the logs.
         * + `BLOCK` - Disallow the request. This option requires additional details in the rule's `BlockResponse`.
         */
        public var action: aws.sdk.kotlin.services.route53resolver.model.Action? = null
        /**
         * The DNS record's type. This determines the format of the record value that you provided in `BlockOverrideDomain`. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
         */
        public var blockOverrideDnsType: aws.sdk.kotlin.services.route53resolver.model.BlockOverrideDnsType? = null
        /**
         * The custom DNS record to send back in response to the query. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
         */
        public var blockOverrideDomain: kotlin.String? = null
        /**
         * The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
         */
        public var blockOverrideTtl: kotlin.Int? = null
        /**
         * The way that you want DNS Firewall to block the request. Used for the rule action setting `BLOCK`.
         * + `NODATA` - Respond indicating that the query was successful, but no response is available for it.
         * + `NXDOMAIN` - Respond indicating that the domain name that's in the query doesn't exist.
         * + `OVERRIDE` - Provide a custom override in the response. This option requires custom handling details in the rule's `BlockOverride*` settings.
         */
        public var blockResponse: aws.sdk.kotlin.services.route53resolver.model.BlockResponse? = null
        /**
         * The confidence threshold for DNS Firewall Advanced. You must provide this value when you create a DNS Firewall Advanced rule. The confidence level values mean:
         * + `LOW`: Provides the highest detection rate for threats, but also increases false positives.
         * + `MEDIUM`: Provides a balance between detecting threats and false positives.
         * + `HIGH`: Detects only the most well corroborated threats with a low rate of false positives.
         */
        public var confidenceThreshold: aws.sdk.kotlin.services.route53resolver.model.ConfidenceThreshold? = null
        /**
         * The type of the DNS Firewall Advanced rule. Valid values are:
         * + `DGA`: Domain generation algorithms detection. DGAs are used by attackers to generate a large number of domains to to launch malware attacks.
         * + `DNS_TUNNELING`: DNS tunneling detection. DNS tunneling is used by attackers to exfiltrate data from the client by using the DNS tunnel without making a network connection to the client.
         */
        public var dnsThreatProtection: aws.sdk.kotlin.services.route53resolver.model.DnsThreatProtection? = null
        /**
         * The ID of the domain list to use in the rule.
         */
        public var firewallDomainListId: kotlin.String? = null
        /**
         * How you want the the rule to evaluate DNS redirection in the DNS redirection chain, such as CNAME or DNAME.
         *
         * `INSPECT_REDIRECTION_DOMAIN`: (Default) inspects all domains in the redirection chain. The individual domains in the redirection chain must be added to the domain list.
         *
         * `TRUST_REDIRECTION_DOMAIN`: Inspects only the first domain in the redirection chain. You don't need to add the subsequent domains in the domain in the redirection list to the domain list.
         */
        public var firewallDomainRedirectionAction: aws.sdk.kotlin.services.route53resolver.model.FirewallDomainRedirectionAction? = null
        /**
         * The unique identifier of the firewall rule group for the rule.
         */
        public var firewallRuleGroupId: kotlin.String? = null
        /**
         * The DNS Firewall Advanced rule ID.
         */
        public var firewallThreatProtectionId: kotlin.String? = null
        /**
         * The name of the rule.
         */
        public var name: kotlin.String? = null
        /**
         * The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
         *
         * You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time.
         */
        public var priority: kotlin.Int? = null
        /**
         * The DNS query type you want the rule to evaluate. Allowed values are;
         * +  A: Returns an IPv4 address.
         * + AAAA: Returns an Ipv6 address.
         * + CAA: Restricts CAs that can create SSL/TLS certifications for the domain.
         * + CNAME: Returns another domain name.
         * + DS: Record that identifies the DNSSEC signing key of a delegated zone.
         * + MX: Specifies mail servers.
         * + NAPTR: Regular-expression-based rewriting of domain names.
         * + NS: Authoritative name servers.
         * + PTR: Maps an IP address to a domain name.
         * + SOA: Start of authority record for the zone.
         * + SPF: Lists the servers authorized to send emails from a domain.
         * + SRV: Application specific values that identify servers.
         * + TXT: Verifies email senders and application-specific values.
         * + A query type you define by using the DNS type ID, for example 28 for AAAA. The values must be defined as TYPENUMBER, where the NUMBER can be 1-65334, for example, TYPE28. For more information, see [List of DNS record types](https://en.wikipedia.org/wiki/List_of_DNS_record_types).If you set up a firewall BLOCK rule with action NXDOMAIN on query type equals AAAA, this action will not be applied to synthetic IPv6 addresses generated when DNS64 is enabled.
         */
        public var qtype: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallRuleRequest) : this() {
            this.action = x.action
            this.blockOverrideDnsType = x.blockOverrideDnsType
            this.blockOverrideDomain = x.blockOverrideDomain
            this.blockOverrideTtl = x.blockOverrideTtl
            this.blockResponse = x.blockResponse
            this.confidenceThreshold = x.confidenceThreshold
            this.dnsThreatProtection = x.dnsThreatProtection
            this.firewallDomainListId = x.firewallDomainListId
            this.firewallDomainRedirectionAction = x.firewallDomainRedirectionAction
            this.firewallRuleGroupId = x.firewallRuleGroupId
            this.firewallThreatProtectionId = x.firewallThreatProtectionId
            this.name = x.name
            this.priority = x.priority
            this.qtype = x.qtype
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallRuleRequest = UpdateFirewallRuleRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
