// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * In a [CreateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html) request, an array of the IPs that you want to forward DNS queries to.
 */
public class TargetAddress private constructor(builder: Builder) {
    /**
     * One IPv4 address that you want to forward DNS queries to.
     */
    public val ip: kotlin.String? = builder.ip
    /**
     * One IPv6 address that you want to forward DNS queries to.
     */
    public val ipv6: kotlin.String? = builder.ipv6
    /**
     * The port at `Ip` that you want to forward DNS queries to.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The protocols for the target address. The protocol you choose needs to be supported by the outbound endpoint of the Resolver rule.
     */
    public val protocol: aws.sdk.kotlin.services.route53resolver.model.Protocol? = builder.protocol
    /**
     * The Server Name Indication of the DoH server that you want to forward queries to. This is only used if the Protocol of the `TargetAddress` is `DoH`.
     */
    public val serverNameIndication: kotlin.String? = builder.serverNameIndication

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.TargetAddress = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetAddress(")
        append("ip=$ip,")
        append("ipv6=$ipv6,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("serverNameIndication=$serverNameIndication")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ip?.hashCode() ?: 0
        result = 31 * result + (ipv6?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (serverNameIndication?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetAddress

        if (ip != other.ip) return false
        if (ipv6 != other.ipv6) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (serverNameIndication != other.serverNameIndication) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.TargetAddress = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * One IPv4 address that you want to forward DNS queries to.
         */
        public var ip: kotlin.String? = null
        /**
         * One IPv6 address that you want to forward DNS queries to.
         */
        public var ipv6: kotlin.String? = null
        /**
         * The port at `Ip` that you want to forward DNS queries to.
         */
        public var port: kotlin.Int? = null
        /**
         * The protocols for the target address. The protocol you choose needs to be supported by the outbound endpoint of the Resolver rule.
         */
        public var protocol: aws.sdk.kotlin.services.route53resolver.model.Protocol? = null
        /**
         * The Server Name Indication of the DoH server that you want to forward queries to. This is only used if the Protocol of the `TargetAddress` is `DoH`.
         */
        public var serverNameIndication: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.TargetAddress) : this() {
            this.ip = x.ip
            this.ipv6 = x.ipv6
            this.port = x.port
            this.protocol = x.protocol
            this.serverNameIndication = x.serverNameIndication
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.TargetAddress = TargetAddress(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
