// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * For queries that originate in your VPC, detailed information about a Resolver rule, which specifies how to route DNS queries out of the VPC. The `ResolverRule` parameter appears in the response to a [CreateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html), [DeleteResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverRule.html), [GetResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html), [ListResolverRules](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html), or [UpdateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html) request.
 */
public class ResolverRule private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) for the Resolver rule specified by `Id`.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the Resolver rule was created, in Unix time format and Coordinated Universal Time (UTC).
     */
    public val creationTime: kotlin.String? = builder.creationTime
    /**
     * A unique string that you specified when you created the Resolver rule. `CreatorRequestId` identifies the request and allows failed requests to be retried without the risk of running the operation twice.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * DNS queries with delegation records that point to this domain name are forwarded to resolvers on your network.
     */
    public val delegationRecord: kotlin.String? = builder.delegationRecord
    /**
     * DNS queries for this domain name are forwarded to the IP addresses that are specified in `TargetIps`. If a query matches multiple Resolver rules (example.com and www.example.com), the query is routed using the Resolver rule that contains the most specific domain name (www.example.com).
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The ID that Resolver assigned to the Resolver rule when you created it.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The date and time that the Resolver rule was last updated, in Unix time format and Coordinated Universal Time (UTC).
     */
    public val modificationTime: kotlin.String? = builder.modificationTime
    /**
     * The name for the Resolver rule, which you specified when you created the Resolver rule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * When a rule is shared with another Amazon Web Services account, the account ID of the account that the rule is shared with.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The ID of the endpoint that the rule is associated with.
     */
    public val resolverEndpointId: kotlin.String? = builder.resolverEndpointId
    /**
     * When you want to forward DNS queries for specified domain name to resolvers on your network, specify `FORWARD` or `DELEGATE`. If a query matches multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains the most specific domain name (www.example.com).
     *
     * When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify `SYSTEM`.
     *
     * For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify `FORWARD` for `RuleType`. To then have Resolver process queries for apex.example.com, you create a rule and specify `SYSTEM` for `RuleType`.
     *
     * Currently, only Resolver can create rules that have a value of `RECURSIVE` for `RuleType`.
     */
    public val ruleType: aws.sdk.kotlin.services.route53resolver.model.RuleTypeOption? = builder.ruleType
    /**
     * Whether the rule is shared and, if so, whether the current account is sharing the rule with another account, or another account is sharing the rule with the current account.
     */
    public val shareStatus: aws.sdk.kotlin.services.route53resolver.model.ShareStatus? = builder.shareStatus
    /**
     * A code that specifies the current status of the Resolver rule.
     */
    public val status: aws.sdk.kotlin.services.route53resolver.model.ResolverRuleStatus? = builder.status
    /**
     * A detailed description of the status of a Resolver rule.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * An array that contains the IP addresses and ports that an outbound endpoint forwards DNS queries to. Typically, these are the IP addresses of DNS resolvers on your network.
     */
    public val targetIps: List<TargetAddress>? = builder.targetIps

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ResolverRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResolverRule(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("creatorRequestId=$creatorRequestId,")
        append("delegationRecord=$delegationRecord,")
        append("domainName=$domainName,")
        append("id=$id,")
        append("modificationTime=$modificationTime,")
        append("name=$name,")
        append("ownerId=$ownerId,")
        append("resolverEndpointId=$resolverEndpointId,")
        append("ruleType=$ruleType,")
        append("shareStatus=$shareStatus,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("targetIps=$targetIps")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (delegationRecord?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (modificationTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (resolverEndpointId?.hashCode() ?: 0)
        result = 31 * result + (ruleType?.hashCode() ?: 0)
        result = 31 * result + (shareStatus?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (targetIps?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResolverRule

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (delegationRecord != other.delegationRecord) return false
        if (domainName != other.domainName) return false
        if (id != other.id) return false
        if (modificationTime != other.modificationTime) return false
        if (name != other.name) return false
        if (ownerId != other.ownerId) return false
        if (resolverEndpointId != other.resolverEndpointId) return false
        if (ruleType != other.ruleType) return false
        if (shareStatus != other.shareStatus) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (targetIps != other.targetIps) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ResolverRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN (Amazon Resource Name) for the Resolver rule specified by `Id`.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the Resolver rule was created, in Unix time format and Coordinated Universal Time (UTC).
         */
        public var creationTime: kotlin.String? = null
        /**
         * A unique string that you specified when you created the Resolver rule. `CreatorRequestId` identifies the request and allows failed requests to be retried without the risk of running the operation twice.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * DNS queries with delegation records that point to this domain name are forwarded to resolvers on your network.
         */
        public var delegationRecord: kotlin.String? = null
        /**
         * DNS queries for this domain name are forwarded to the IP addresses that are specified in `TargetIps`. If a query matches multiple Resolver rules (example.com and www.example.com), the query is routed using the Resolver rule that contains the most specific domain name (www.example.com).
         */
        public var domainName: kotlin.String? = null
        /**
         * The ID that Resolver assigned to the Resolver rule when you created it.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time that the Resolver rule was last updated, in Unix time format and Coordinated Universal Time (UTC).
         */
        public var modificationTime: kotlin.String? = null
        /**
         * The name for the Resolver rule, which you specified when you created the Resolver rule.
         */
        public var name: kotlin.String? = null
        /**
         * When a rule is shared with another Amazon Web Services account, the account ID of the account that the rule is shared with.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The ID of the endpoint that the rule is associated with.
         */
        public var resolverEndpointId: kotlin.String? = null
        /**
         * When you want to forward DNS queries for specified domain name to resolvers on your network, specify `FORWARD` or `DELEGATE`. If a query matches multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains the most specific domain name (www.example.com).
         *
         * When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify `SYSTEM`.
         *
         * For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify `FORWARD` for `RuleType`. To then have Resolver process queries for apex.example.com, you create a rule and specify `SYSTEM` for `RuleType`.
         *
         * Currently, only Resolver can create rules that have a value of `RECURSIVE` for `RuleType`.
         */
        public var ruleType: aws.sdk.kotlin.services.route53resolver.model.RuleTypeOption? = null
        /**
         * Whether the rule is shared and, if so, whether the current account is sharing the rule with another account, or another account is sharing the rule with the current account.
         */
        public var shareStatus: aws.sdk.kotlin.services.route53resolver.model.ShareStatus? = null
        /**
         * A code that specifies the current status of the Resolver rule.
         */
        public var status: aws.sdk.kotlin.services.route53resolver.model.ResolverRuleStatus? = null
        /**
         * A detailed description of the status of a Resolver rule.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * An array that contains the IP addresses and ports that an outbound endpoint forwards DNS queries to. Typically, these are the IP addresses of DNS resolvers on your network.
         */
        public var targetIps: List<TargetAddress>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ResolverRule) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.creatorRequestId = x.creatorRequestId
            this.delegationRecord = x.delegationRecord
            this.domainName = x.domainName
            this.id = x.id
            this.modificationTime = x.modificationTime
            this.name = x.name
            this.ownerId = x.ownerId
            this.resolverEndpointId = x.resolverEndpointId
            this.ruleType = x.ruleType
            this.shareStatus = x.shareStatus
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.targetIps = x.targetIps
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ResolverRule = ResolverRule(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
