// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A complex type that contains information about a configuration for DNSSEC validation.
 */
public class ResolverDnssecConfig private constructor(builder: Builder) {
    /**
     * The ID for a configuration for DNSSEC validation.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The owner account ID of the virtual private cloud (VPC) for a configuration for DNSSEC validation.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The ID of the virtual private cloud (VPC) that you're configuring the DNSSEC validation status for.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The validation status for a DNSSEC configuration. The status can be one of the following:
     * + **ENABLING:** DNSSEC validation is being enabled but is not complete.
     * + **ENABLED:** DNSSEC validation is enabled.
     * + **DISABLING:** DNSSEC validation is being disabled but is not complete.
     * + **DISABLED** DNSSEC validation is disabled.
     */
    public val validationStatus: aws.sdk.kotlin.services.route53resolver.model.ResolverDnssecValidationStatus? = builder.validationStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ResolverDnssecConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResolverDnssecConfig(")
        append("id=$id,")
        append("ownerId=$ownerId,")
        append("resourceId=$resourceId,")
        append("validationStatus=$validationStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (validationStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResolverDnssecConfig

        if (id != other.id) return false
        if (ownerId != other.ownerId) return false
        if (resourceId != other.resourceId) return false
        if (validationStatus != other.validationStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ResolverDnssecConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID for a configuration for DNSSEC validation.
         */
        public var id: kotlin.String? = null
        /**
         * The owner account ID of the virtual private cloud (VPC) for a configuration for DNSSEC validation.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The ID of the virtual private cloud (VPC) that you're configuring the DNSSEC validation status for.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The validation status for a DNSSEC configuration. The status can be one of the following:
         * + **ENABLING:** DNSSEC validation is being enabled but is not complete.
         * + **ENABLED:** DNSSEC validation is enabled.
         * + **DISABLING:** DNSSEC validation is being disabled but is not complete.
         * + **DISABLED** DNSSEC validation is disabled.
         */
        public var validationStatus: aws.sdk.kotlin.services.route53resolver.model.ResolverDnssecValidationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ResolverDnssecConfig) : this() {
            this.id = x.id
            this.ownerId = x.ownerId
            this.resourceId = x.resourceId
            this.validationStatus = x.validationStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ResolverDnssecConfig = ResolverDnssecConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
