// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListResolverRulesRequest private constructor(builder: Builder) {
    /**
     * An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.
     *
     * If you submit a second or subsequent `ListResolverRules` request and specify the `NextToken` parameter, you must use the same values for `Filters`, if any, as in the previous request.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of Resolver rules that you want to return in the response to a `ListResolverRules` request. If you don't specify a value for `MaxResults`, Resolver returns up to 100 Resolver rules.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * For the first `ListResolverRules` request, omit this value.
     *
     * If you have more than `MaxResults` Resolver rules, you can submit another `ListResolverRules` request to get the next group of Resolver rules. In the next request, specify the value of `NextToken` from the previous response.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListResolverRulesRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListResolverRulesRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.
         *
         * If you submit a second or subsequent `ListResolverRules` request and specify the `NextToken` parameter, you must use the same values for `Filters`, if any, as in the previous request.
         */
        public var filters: List<Filter>? = null
        /**
         * The maximum number of Resolver rules that you want to return in the response to a `ListResolverRules` request. If you don't specify a value for `MaxResults`, Resolver returns up to 100 Resolver rules.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * For the first `ListResolverRules` request, omit this value.
         *
         * If you have more than `MaxResults` Resolver rules, you can submit another `ListResolverRules` request to get the next group of Resolver rules. In the next request, specify the value of `NextToken` from the previous response.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesRequest = ListResolverRulesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
