// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * In a [CreateResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html) request, the IP address that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). `IpAddressRequest` also includes the ID of the subnet that contains the IP address.
 */
public class IpAddressRequest private constructor(builder: Builder) {
    /**
     * The IPv4 address that you want to use for DNS queries.
     */
    public val ip: kotlin.String? = builder.ip
    /**
     * The IPv6 address that you want to use for DNS queries.
     */
    public val ipv6: kotlin.String? = builder.ipv6
    /**
     * The ID of the subnet that contains the IP address.
     */
    public val subnetId: kotlin.String = requireNotNull(builder.subnetId) { "A non-null value must be provided for subnetId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.IpAddressRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpAddressRequest(")
        append("ip=$ip,")
        append("ipv6=$ipv6,")
        append("subnetId=$subnetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ip?.hashCode() ?: 0
        result = 31 * result + (ipv6?.hashCode() ?: 0)
        result = 31 * result + (subnetId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpAddressRequest

        if (ip != other.ip) return false
        if (ipv6 != other.ipv6) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.IpAddressRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The IPv4 address that you want to use for DNS queries.
         */
        public var ip: kotlin.String? = null
        /**
         * The IPv6 address that you want to use for DNS queries.
         */
        public var ipv6: kotlin.String? = null
        /**
         * The ID of the subnet that contains the IP address.
         */
        public var subnetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.IpAddressRequest) : this() {
            this.ip = x.ip
            this.ipv6 = x.ipv6
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.IpAddressRequest = IpAddressRequest(this)

        internal fun correctErrors(): Builder {
            if (subnetId == null) subnetId = ""
            return this
        }
    }
}
