// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



/**
 * In the response to an [AssociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html), [DisassociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html), [GetResolverQueryLogConfigAssociation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfigAssociation.html), or [ListResolverQueryLogConfigAssociations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html), request, a complex type that contains settings for a specified association between an Amazon VPC and a query logging configuration.
 */
public class ResolverQueryLogConfigAssociation private constructor(builder: Builder) {
    /**
     * The date and time that the VPC was associated with the query logging configuration, in Unix time format and Coordinated Universal Time (UTC).
     */
    public val creationTime: kotlin.String? = builder.creationTime
    /**
     * If the value of `Status` is `FAILED`, the value of `Error` indicates the cause:
     * + `DESTINATION_NOT_FOUND`: The specified destination (for example, an Amazon S3 bucket) was deleted.
     * + `ACCESS_DENIED`: Permissions don't allow sending logs to the destination.
     *
     * If the value of `Status` is a value other than `FAILED`, `Error` is null.
     */
    public val error: aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfigAssociationError? = builder.error
    /**
     * Contains additional information about the error. If the value or `Error` is null, the value of `ErrorMessage` also is null.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The ID of the query logging association.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The ID of the query logging configuration that a VPC is associated with.
     */
    public val resolverQueryLogConfigId: kotlin.String? = builder.resolverQueryLogConfigId
    /**
     * The ID of the Amazon VPC that is associated with the query logging configuration.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The status of the specified query logging association. Valid values include the following:
     * + `CREATING`: Resolver is creating an association between an Amazon VPC and a query logging configuration.
     * + `CREATED`: The association between an Amazon VPC and a query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.
     * + `DELETING`: Resolver is deleting this query logging association.
     * + `FAILED`: Resolver either couldn't create or couldn't delete the query logging association.
     */
    public val status: aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfigAssociationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfigAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResolverQueryLogConfigAssociation(")
        append("creationTime=$creationTime,")
        append("error=$error,")
        append("errorMessage=$errorMessage,")
        append("id=$id,")
        append("resolverQueryLogConfigId=$resolverQueryLogConfigId,")
        append("resourceId=$resourceId,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (resolverQueryLogConfigId?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResolverQueryLogConfigAssociation

        if (creationTime != other.creationTime) return false
        if (error != other.error) return false
        if (errorMessage != other.errorMessage) return false
        if (id != other.id) return false
        if (resolverQueryLogConfigId != other.resolverQueryLogConfigId) return false
        if (resourceId != other.resourceId) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfigAssociation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time that the VPC was associated with the query logging configuration, in Unix time format and Coordinated Universal Time (UTC).
         */
        public var creationTime: kotlin.String? = null
        /**
         * If the value of `Status` is `FAILED`, the value of `Error` indicates the cause:
         * + `DESTINATION_NOT_FOUND`: The specified destination (for example, an Amazon S3 bucket) was deleted.
         * + `ACCESS_DENIED`: Permissions don't allow sending logs to the destination.
         *
         * If the value of `Status` is a value other than `FAILED`, `Error` is null.
         */
        public var error: aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfigAssociationError? = null
        /**
         * Contains additional information about the error. If the value or `Error` is null, the value of `ErrorMessage` also is null.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * The ID of the query logging association.
         */
        public var id: kotlin.String? = null
        /**
         * The ID of the query logging configuration that a VPC is associated with.
         */
        public var resolverQueryLogConfigId: kotlin.String? = null
        /**
         * The ID of the Amazon VPC that is associated with the query logging configuration.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The status of the specified query logging association. Valid values include the following:
         * + `CREATING`: Resolver is creating an association between an Amazon VPC and a query logging configuration.
         * + `CREATED`: The association between an Amazon VPC and a query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.
         * + `DELETING`: Resolver is deleting this query logging association.
         * + `FAILED`: Resolver either couldn't create or couldn't delete the query logging association.
         */
        public var status: aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfigAssociationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfigAssociation) : this() {
            this.creationTime = x.creationTime
            this.error = x.error
            this.errorMessage = x.errorMessage
            this.id = x.id
            this.resolverQueryLogConfigId = x.resolverQueryLogConfigId
            this.resourceId = x.resourceId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfigAssociation = ResolverQueryLogConfigAssociation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
