// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



/**
 * In the response to a [CreateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverQueryLogConfig.html), [DeleteResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverQueryLogConfig.html), [GetResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfig.html), or [ListResolverQueryLogConfigs](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html) request, a complex type that contains settings for one query logging configuration.
 */
public class ResolverQueryLogConfig private constructor(builder: Builder) {
    /**
     * The ARN for the query logging configuration.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The number of VPCs that are associated with the query logging configuration.
     */
    public val associationCount: kotlin.Int = builder.associationCount
    /**
     * The date and time that the query logging configuration was created, in Unix time format and Coordinated Universal Time (UTC).
     */
    public val creationTime: kotlin.String? = builder.creationTime
    /**
     * A unique string that identifies the request that created the query logging configuration. The `CreatorRequestId` allows failed requests to be retried without the risk of running the operation twice.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The ARN of the resource that you want Resolver to send query logs: an Amazon S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream.
     */
    public val destinationArn: kotlin.String? = builder.destinationArn
    /**
     * The ID for the query logging configuration.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the query logging configuration.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services account ID for the account that created the query logging configuration.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * An indication of whether the query logging configuration is shared with other Amazon Web Services accounts, or was shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).
     */
    public val shareStatus: aws.sdk.kotlin.services.route53resolver.model.ShareStatus? = builder.shareStatus
    /**
     * The status of the specified query logging configuration. Valid values include the following:
     * + `CREATING`: Resolver is creating the query logging configuration.
     * + `CREATED`: The query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.
     * + `DELETING`: Resolver is deleting this query logging configuration.
     * + `FAILED`: Resolver can't deliver logs to the location that is specified in the query logging configuration. Here are two common causes:
     *    + The specified destination (for example, an Amazon S3 bucket) was deleted.
     *    + Permissions don't allow sending logs to the destination.
     */
    public val status: aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfigStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResolverQueryLogConfig(")
        append("arn=$arn,")
        append("associationCount=$associationCount,")
        append("creationTime=$creationTime,")
        append("creatorRequestId=$creatorRequestId,")
        append("destinationArn=$destinationArn,")
        append("id=$id,")
        append("name=$name,")
        append("ownerId=$ownerId,")
        append("shareStatus=$shareStatus,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (associationCount)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (destinationArn?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (shareStatus?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResolverQueryLogConfig

        if (arn != other.arn) return false
        if (associationCount != other.associationCount) return false
        if (creationTime != other.creationTime) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (destinationArn != other.destinationArn) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (ownerId != other.ownerId) return false
        if (shareStatus != other.shareStatus) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN for the query logging configuration.
         */
        public var arn: kotlin.String? = null
        /**
         * The number of VPCs that are associated with the query logging configuration.
         */
        public var associationCount: kotlin.Int = 0
        /**
         * The date and time that the query logging configuration was created, in Unix time format and Coordinated Universal Time (UTC).
         */
        public var creationTime: kotlin.String? = null
        /**
         * A unique string that identifies the request that created the query logging configuration. The `CreatorRequestId` allows failed requests to be retried without the risk of running the operation twice.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * The ARN of the resource that you want Resolver to send query logs: an Amazon S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream.
         */
        public var destinationArn: kotlin.String? = null
        /**
         * The ID for the query logging configuration.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the query logging configuration.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services account ID for the account that created the query logging configuration.
         */
        public var ownerId: kotlin.String? = null
        /**
         * An indication of whether the query logging configuration is shared with other Amazon Web Services accounts, or was shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).
         */
        public var shareStatus: aws.sdk.kotlin.services.route53resolver.model.ShareStatus? = null
        /**
         * The status of the specified query logging configuration. Valid values include the following:
         * + `CREATING`: Resolver is creating the query logging configuration.
         * + `CREATED`: The query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.
         * + `DELETING`: Resolver is deleting this query logging configuration.
         * + `FAILED`: Resolver can't deliver logs to the location that is specified in the query logging configuration. Here are two common causes:
         *    + The specified destination (for example, an Amazon S3 bucket) was deleted.
         *    + Permissions don't allow sending logs to the destination.
         */
        public var status: aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfigStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfig) : this() {
            this.arn = x.arn
            this.associationCount = x.associationCount
            this.creationTime = x.creationTime
            this.creatorRequestId = x.creatorRequestId
            this.destinationArn = x.destinationArn
            this.id = x.id
            this.name = x.name
            this.ownerId = x.ownerId
            this.shareStatus = x.shareStatus
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfig = ResolverQueryLogConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
