// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



/**
 * Minimal high-level information for a firewall rule group. The action ListFirewallRuleGroups returns an array of these objects.
 *
 * To retrieve full information for a firewall rule group, call GetFirewallRuleGroup and ListFirewallRules.
 */
public class FirewallRuleGroupMetadata private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) of the rule group.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The ID of the rule group.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the rule group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services account ID for the account that created the rule group. When a rule group is shared with your account, this is the account that has shared the rule group with you.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * Whether the rule group is shared with other Amazon Web Services accounts, or was shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).
     */
    public val shareStatus: aws.sdk.kotlin.services.route53resolver.model.ShareStatus? = builder.shareStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirewallRuleGroupMetadata(")
        append("arn=$arn,")
        append("creatorRequestId=$creatorRequestId,")
        append("id=$id,")
        append("name=$name,")
        append("ownerId=$ownerId,")
        append("shareStatus=$shareStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (shareStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirewallRuleGroupMetadata

        if (arn != other.arn) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (ownerId != other.ownerId) return false
        if (shareStatus != other.shareStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN (Amazon Resource Name) of the rule group.
         */
        public var arn: kotlin.String? = null
        /**
         * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * The ID of the rule group.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the rule group.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services account ID for the account that created the rule group. When a rule group is shared with your account, this is the account that has shared the rule group with you.
         */
        public var ownerId: kotlin.String? = null
        /**
         * Whether the rule group is shared with other Amazon Web Services accounts, or was shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).
         */
        public var shareStatus: aws.sdk.kotlin.services.route53resolver.model.ShareStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupMetadata) : this() {
            this.arn = x.arn
            this.creatorRequestId = x.creatorRequestId
            this.id = x.id
            this.name = x.name
            this.ownerId = x.ownerId
            this.shareStatus = x.shareStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupMetadata = FirewallRuleGroupMetadata(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
