// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



/**
 * An association between a firewall rule group and a VPC, which enables DNS filtering for the VPC.
 */
public class FirewallRuleGroupAssociation private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the firewall rule group association.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the association was created, in Unix time format and Coordinated Universal Time (UTC).
     */
    public val creationTime: kotlin.String? = builder.creationTime
    /**
     * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The unique identifier of the firewall rule group.
     */
    public val firewallRuleGroupId: kotlin.String? = builder.firewallRuleGroupId
    /**
     * The identifier for the association.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The owner of the association, used only for associations that are not managed by you. If you use Firewall Manager to manage your DNS Firewalls, then this reports Firewall Manager as the managed owner.
     */
    public val managedOwnerName: kotlin.String? = builder.managedOwnerName
    /**
     * The date and time that the association was last modified, in Unix time format and Coordinated Universal Time (UTC).
     */
    public val modificationTime: kotlin.String? = builder.modificationTime
    /**
     * If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections.
     */
    public val mutationProtection: aws.sdk.kotlin.services.route53resolver.model.MutationProtectionStatus? = builder.mutationProtection
    /**
     * The name of the association.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting from rule group with the lowest numeric priority setting.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * The current status of the association.
     */
    public val status: aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupAssociationStatus? = builder.status
    /**
     * Additional information about the status of the response, if available.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The unique identifier of the VPC that is associated with the rule group.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirewallRuleGroupAssociation(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("creatorRequestId=$creatorRequestId,")
        append("firewallRuleGroupId=$firewallRuleGroupId,")
        append("id=$id,")
        append("managedOwnerName=$managedOwnerName,")
        append("modificationTime=$modificationTime,")
        append("mutationProtection=$mutationProtection,")
        append("name=$name,")
        append("priority=$priority,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (firewallRuleGroupId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (managedOwnerName?.hashCode() ?: 0)
        result = 31 * result + (modificationTime?.hashCode() ?: 0)
        result = 31 * result + (mutationProtection?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirewallRuleGroupAssociation

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (firewallRuleGroupId != other.firewallRuleGroupId) return false
        if (id != other.id) return false
        if (managedOwnerName != other.managedOwnerName) return false
        if (modificationTime != other.modificationTime) return false
        if (mutationProtection != other.mutationProtection) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupAssociation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the firewall rule group association.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the association was created, in Unix time format and Coordinated Universal Time (UTC).
         */
        public var creationTime: kotlin.String? = null
        /**
         * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * The unique identifier of the firewall rule group.
         */
        public var firewallRuleGroupId: kotlin.String? = null
        /**
         * The identifier for the association.
         */
        public var id: kotlin.String? = null
        /**
         * The owner of the association, used only for associations that are not managed by you. If you use Firewall Manager to manage your DNS Firewalls, then this reports Firewall Manager as the managed owner.
         */
        public var managedOwnerName: kotlin.String? = null
        /**
         * The date and time that the association was last modified, in Unix time format and Coordinated Universal Time (UTC).
         */
        public var modificationTime: kotlin.String? = null
        /**
         * If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections.
         */
        public var mutationProtection: aws.sdk.kotlin.services.route53resolver.model.MutationProtectionStatus? = null
        /**
         * The name of the association.
         */
        public var name: kotlin.String? = null
        /**
         * The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting from rule group with the lowest numeric priority setting.
         */
        public var priority: kotlin.Int? = null
        /**
         * The current status of the association.
         */
        public var status: aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupAssociationStatus? = null
        /**
         * Additional information about the status of the response, if available.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The unique identifier of the VPC that is associated with the rule group.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupAssociation) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.creatorRequestId = x.creatorRequestId
            this.firewallRuleGroupId = x.firewallRuleGroupId
            this.id = x.id
            this.managedOwnerName = x.managedOwnerName
            this.modificationTime = x.modificationTime
            this.mutationProtection = x.mutationProtection
            this.name = x.name
            this.priority = x.priority
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupAssociation = FirewallRuleGroupAssociation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
