// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



/**
 * High-level information about a list of firewall domains for use in a FirewallRule. This is returned by GetFirewallDomainList.
 *
 * To retrieve the domains that are defined for this domain list, call ListFirewallDomains.
 */
public class FirewallDomainList private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the firewall domain list.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the domain list was created, in Unix time format and Coordinated Universal Time (UTC).
     */
    public val creationTime: kotlin.String? = builder.creationTime
    /**
     * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The number of domain names that are specified in the domain list.
     */
    public val domainCount: kotlin.Int? = builder.domainCount
    /**
     * The ID of the domain list.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The owner of the list, used only for lists that are not managed by you. For example, the managed domain list `AWSManagedDomainsMalwareDomainList` has the managed owner name `Route 53 Resolver DNS Firewall`.
     */
    public val managedOwnerName: kotlin.String? = builder.managedOwnerName
    /**
     * The date and time that the domain list was last modified, in Unix time format and Coordinated Universal Time (UTC).
     */
    public val modificationTime: kotlin.String? = builder.modificationTime
    /**
     * The name of the domain list.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the domain list.
     */
    public val status: aws.sdk.kotlin.services.route53resolver.model.FirewallDomainListStatus? = builder.status
    /**
     * Additional information about the status of the list, if available.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.FirewallDomainList = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirewallDomainList(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("creatorRequestId=$creatorRequestId,")
        append("domainCount=$domainCount,")
        append("id=$id,")
        append("managedOwnerName=$managedOwnerName,")
        append("modificationTime=$modificationTime,")
        append("name=$name,")
        append("status=$status,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (domainCount ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (managedOwnerName?.hashCode() ?: 0)
        result = 31 * result + (modificationTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirewallDomainList

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (domainCount != other.domainCount) return false
        if (id != other.id) return false
        if (managedOwnerName != other.managedOwnerName) return false
        if (modificationTime != other.modificationTime) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.FirewallDomainList = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the firewall domain list.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the domain list was created, in Unix time format and Coordinated Universal Time (UTC).
         */
        public var creationTime: kotlin.String? = null
        /**
         * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * The number of domain names that are specified in the domain list.
         */
        public var domainCount: kotlin.Int? = null
        /**
         * The ID of the domain list.
         */
        public var id: kotlin.String? = null
        /**
         * The owner of the list, used only for lists that are not managed by you. For example, the managed domain list `AWSManagedDomainsMalwareDomainList` has the managed owner name `Route 53 Resolver DNS Firewall`.
         */
        public var managedOwnerName: kotlin.String? = null
        /**
         * The date and time that the domain list was last modified, in Unix time format and Coordinated Universal Time (UTC).
         */
        public var modificationTime: kotlin.String? = null
        /**
         * The name of the domain list.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the domain list.
         */
        public var status: aws.sdk.kotlin.services.route53resolver.model.FirewallDomainListStatus? = null
        /**
         * Additional information about the status of the list, if available.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.FirewallDomainList) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.creatorRequestId = x.creatorRequestId
            this.domainCount = x.domainCount
            this.id = x.id
            this.managedOwnerName = x.managedOwnerName
            this.modificationTime = x.modificationTime
            this.name = x.name
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.FirewallDomainList = FirewallDomainList(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
