// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



/**
 * Configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
 */
public class FirewallConfig private constructor(builder: Builder) {
    /**
     * Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply.
     * + By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall returns a failure error when it is unable to properly evaluate a query.
     * + If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them.
     *
     * This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
     */
    public val firewallFailOpen: aws.sdk.kotlin.services.route53resolver.model.FirewallFailOpenStatus? = builder.firewallFailOpen
    /**
     * The ID of the firewall configuration.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The Amazon Web Services account ID of the owner of the VPC that this firewall configuration applies to.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The ID of the VPC that this firewall configuration applies to.
     */
    public val resourceId: kotlin.String? = builder.resourceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.FirewallConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirewallConfig(")
        append("firewallFailOpen=$firewallFailOpen,")
        append("id=$id,")
        append("ownerId=$ownerId,")
        append("resourceId=$resourceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = firewallFailOpen?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirewallConfig

        if (firewallFailOpen != other.firewallFailOpen) return false
        if (id != other.id) return false
        if (ownerId != other.ownerId) return false
        if (resourceId != other.resourceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.FirewallConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply.
         * + By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall returns a failure error when it is unable to properly evaluate a query.
         * + If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them.
         *
         * This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
         */
        public var firewallFailOpen: aws.sdk.kotlin.services.route53resolver.model.FirewallFailOpenStatus? = null
        /**
         * The ID of the firewall configuration.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the owner of the VPC that this firewall configuration applies to.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The ID of the VPC that this firewall configuration applies to.
         */
        public var resourceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.FirewallConfig) : this() {
            this.firewallFailOpen = x.firewallFailOpen
            this.id = x.id
            this.ownerId = x.ownerId
            this.resourceId = x.resourceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.FirewallConfig = FirewallConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
