// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



public class CreateResolverEndpointRequest private constructor(builder: Builder) {
    /**
     * A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. `CreatorRequestId` can be any unique string, for example, a date/time stamp.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * Specify the applicable value:
     * + `INBOUND`: Resolver forwards DNS queries to the DNS service for a VPC from your network
     * + `OUTBOUND`: Resolver forwards DNS queries from the DNS service for a VPC to your network
     */
    public val direction: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointDirection? = builder.direction
    /**
     * The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
     *
     * Even though the minimum is 1, Route 53 requires that you create at least two.
     */
    public val ipAddresses: List<IpAddressRequest>? = builder.ipAddresses
    /**
     * A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the Outpost. If you specify this, you must also specify a value for the `PreferredInstanceType`.
     */
    public val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The instance type. If you specify this, you must also specify a value for the `OutpostArn`.
     */
    public val preferredInstanceType: kotlin.String? = builder.preferredInstanceType
    /**
     * The protocols you want to use for the endpoint. DoH-FIPS is applicable for inbound endpoints only.
     *
     * For an inbound endpoint you can apply the protocols as follows:
     * +  Do53 and DoH in combination.
     * + Do53 and DoH-FIPS in combination.
     * + Do53 alone.
     * + DoH alone.
     * + DoH-FIPS alone.
     * + None, which is treated as Do53.
     *
     * For an outbound endpoint you can apply the protocols as follows:
     * +  Do53 and DoH in combination.
     * + Do53 alone.
     * + DoH alone.
     * + None, which is treated as Do53.
     */
    public val protocols: List<Protocol>? = builder.protocols
    /**
     * For the endpoint type you can choose either IPv4, IPv6, or dual-stack. A dual-stack endpoint means that it will resolve via both IPv4 and IPv6. This endpoint type is applied to all IP addresses.
     */
    public val resolverEndpointType: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointType? = builder.resolverEndpointType
    /**
     * The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A list of the tag keys and values that you want to associate with the endpoint.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.CreateResolverEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateResolverEndpointRequest(")
        append("creatorRequestId=$creatorRequestId,")
        append("direction=$direction,")
        append("ipAddresses=$ipAddresses,")
        append("name=$name,")
        append("outpostArn=$outpostArn,")
        append("preferredInstanceType=$preferredInstanceType,")
        append("protocols=$protocols,")
        append("resolverEndpointType=$resolverEndpointType,")
        append("securityGroupIds=$securityGroupIds,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creatorRequestId?.hashCode() ?: 0
        result = 31 * result + (direction?.hashCode() ?: 0)
        result = 31 * result + (ipAddresses?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (preferredInstanceType?.hashCode() ?: 0)
        result = 31 * result + (protocols?.hashCode() ?: 0)
        result = 31 * result + (resolverEndpointType?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateResolverEndpointRequest

        if (creatorRequestId != other.creatorRequestId) return false
        if (direction != other.direction) return false
        if (ipAddresses != other.ipAddresses) return false
        if (name != other.name) return false
        if (outpostArn != other.outpostArn) return false
        if (preferredInstanceType != other.preferredInstanceType) return false
        if (protocols != other.protocols) return false
        if (resolverEndpointType != other.resolverEndpointType) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.CreateResolverEndpointRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. `CreatorRequestId` can be any unique string, for example, a date/time stamp.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * Specify the applicable value:
         * + `INBOUND`: Resolver forwards DNS queries to the DNS service for a VPC from your network
         * + `OUTBOUND`: Resolver forwards DNS queries from the DNS service for a VPC to your network
         */
        public var direction: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointDirection? = null
        /**
         * The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
         *
         * Even though the minimum is 1, Route 53 requires that you create at least two.
         */
        public var ipAddresses: List<IpAddressRequest>? = null
        /**
         * A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost. If you specify this, you must also specify a value for the `PreferredInstanceType`.
         */
        public var outpostArn: kotlin.String? = null
        /**
         * The instance type. If you specify this, you must also specify a value for the `OutpostArn`.
         */
        public var preferredInstanceType: kotlin.String? = null
        /**
         * The protocols you want to use for the endpoint. DoH-FIPS is applicable for inbound endpoints only.
         *
         * For an inbound endpoint you can apply the protocols as follows:
         * +  Do53 and DoH in combination.
         * + Do53 and DoH-FIPS in combination.
         * + Do53 alone.
         * + DoH alone.
         * + DoH-FIPS alone.
         * + None, which is treated as Do53.
         *
         * For an outbound endpoint you can apply the protocols as follows:
         * +  Do53 and DoH in combination.
         * + Do53 alone.
         * + DoH alone.
         * + None, which is treated as Do53.
         */
        public var protocols: List<Protocol>? = null
        /**
         * For the endpoint type you can choose either IPv4, IPv6, or dual-stack. A dual-stack endpoint means that it will resolve via both IPv4 and IPv6. This endpoint type is applied to all IP addresses.
         */
        public var resolverEndpointType: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointType? = null
        /**
         * The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * A list of the tag keys and values that you want to associate with the endpoint.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.CreateResolverEndpointRequest) : this() {
            this.creatorRequestId = x.creatorRequestId
            this.direction = x.direction
            this.ipAddresses = x.ipAddresses
            this.name = x.name
            this.outpostArn = x.outpostArn
            this.preferredInstanceType = x.preferredInstanceType
            this.protocols = x.protocols
            this.resolverEndpointType = x.resolverEndpointType
            this.securityGroupIds = x.securityGroupIds
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.CreateResolverEndpointRequest = CreateResolverEndpointRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
