// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.route53resolver.auth.Route53ResolverAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.route53resolver.auth.Route53ResolverIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.route53resolver.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.route53resolver.model.*
import aws.sdk.kotlin.services.route53resolver.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultRoute53ResolverClient(override val config: Route53ResolverClient.Config) : Route53ResolverClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = Route53ResolverIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "route53resolver")
        }
        toMap()
    }
    private val authSchemeAdapter = Route53ResolverAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.route53resolver"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Associates a FirewallRuleGroup with a VPC, to provide DNS filtering for the VPC.
     */
    override suspend fun associateFirewallRuleGroup(input: AssociateFirewallRuleGroupRequest): AssociateFirewallRuleGroupResponse {
        val op = SdkHttpOperation.build<AssociateFirewallRuleGroupRequest, AssociateFirewallRuleGroupResponse> {
            serializer = AssociateFirewallRuleGroupOperationSerializer()
            deserializer = AssociateFirewallRuleGroupOperationDeserializer()
            operationName = "AssociateFirewallRuleGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address, submit one `AssociateResolverEndpointIpAddress` request for each IP address.
     *
     * To remove an IP address from an endpoint, see [DisassociateResolverEndpointIpAddress](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html).
     */
    override suspend fun associateResolverEndpointIpAddress(input: AssociateResolverEndpointIpAddressRequest): AssociateResolverEndpointIpAddressResponse {
        val op = SdkHttpOperation.build<AssociateResolverEndpointIpAddressRequest, AssociateResolverEndpointIpAddressResponse> {
            serializer = AssociateResolverEndpointIpAddressOperationSerializer()
            deserializer = AssociateResolverEndpointIpAddressOperationDeserializer()
            operationName = "AssociateResolverEndpointIpAddress"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To associate more than one VPC with a configuration, submit one `AssociateResolverQueryLogConfig` request for each VPC.
     *
     * The VPCs that you associate with a query logging configuration must be in the same Region as the configuration.
     *
     * To remove a VPC from a query logging configuration, see [DisassociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
     */
    override suspend fun associateResolverQueryLogConfig(input: AssociateResolverQueryLogConfigRequest): AssociateResolverQueryLogConfigResponse {
        val op = SdkHttpOperation.build<AssociateResolverQueryLogConfigRequest, AssociateResolverQueryLogConfigResponse> {
            serializer = AssociateResolverQueryLogConfigOperationSerializer()
            deserializer = AssociateResolverQueryLogConfigOperationDeserializer()
            operationName = "AssociateResolverQueryLogConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see [CreateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html).
     */
    override suspend fun associateResolverRule(input: AssociateResolverRuleRequest): AssociateResolverRuleResponse {
        val op = SdkHttpOperation.build<AssociateResolverRuleRequest, AssociateResolverRuleResponse> {
            serializer = AssociateResolverRuleOperationSerializer()
            deserializer = AssociateResolverRuleOperationDeserializer()
            operationName = "AssociateResolverRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an empty firewall domain list for use in DNS Firewall rules. You can populate the domains for the new list with a file, using ImportFirewallDomains, or with domain strings, using UpdateFirewallDomains.
     */
    override suspend fun createFirewallDomainList(input: CreateFirewallDomainListRequest): CreateFirewallDomainListResponse {
        val op = SdkHttpOperation.build<CreateFirewallDomainListRequest, CreateFirewallDomainListResponse> {
            serializer = CreateFirewallDomainListOperationSerializer()
            deserializer = CreateFirewallDomainListOperationDeserializer()
            operationName = "CreateFirewallDomainList"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.
     */
    override suspend fun createFirewallRule(input: CreateFirewallRuleRequest): CreateFirewallRuleResponse {
        val op = SdkHttpOperation.build<CreateFirewallRuleRequest, CreateFirewallRuleResponse> {
            serializer = CreateFirewallRuleOperationSerializer()
            deserializer = CreateFirewallRuleOperationDeserializer()
            operationName = "CreateFirewallRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You can add rules to the new rule group by calling CreateFirewallRule.
     */
    override suspend fun createFirewallRuleGroup(input: CreateFirewallRuleGroupRequest): CreateFirewallRuleGroupResponse {
        val op = SdkHttpOperation.build<CreateFirewallRuleGroupRequest, CreateFirewallRuleGroupResponse> {
            serializer = CreateFirewallRuleGroupOperationSerializer()
            deserializer = CreateFirewallRuleGroupOperationDeserializer()
            operationName = "CreateFirewallRuleGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Route 53 Resolver on an Outpost.
     */
    override suspend fun createOutpostResolver(input: CreateOutpostResolverRequest): CreateOutpostResolverResponse {
        val op = SdkHttpOperation.build<CreateOutpostResolverRequest, CreateOutpostResolverResponse> {
            serializer = CreateOutpostResolverOperationSerializer()
            deserializer = CreateOutpostResolverOperationDeserializer()
            operationName = "CreateOutpostResolver"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:
     * + An *inbound Resolver endpoint* forwards DNS queries to the DNS service for a VPC from your network.
     * + An *outbound Resolver endpoint* forwards DNS queries from the DNS service for a VPC to your network.
     */
    override suspend fun createResolverEndpoint(input: CreateResolverEndpointRequest): CreateResolverEndpointResponse {
        val op = SdkHttpOperation.build<CreateResolverEndpointRequest, CreateResolverEndpointResponse> {
            serializer = CreateResolverEndpointOperationSerializer()
            deserializer = CreateResolverEndpointOperationDeserializer()
            operationName = "CreateResolverEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that originate in your VPCs. Resolver can log queries only for VPCs that are in the same Region as the query logging configuration.
     *
     * To specify which VPCs you want to log queries for, you use `AssociateResolverQueryLogConfig`. For more information, see [AssociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html).
     *
     * You can optionally use Resource Access Manager (RAM) to share a query logging configuration with other Amazon Web Services accounts. The other accounts can then associate VPCs with the configuration. The query logs that Resolver creates for a configuration include all DNS queries that originate in all VPCs that are associated with the configuration.
     */
    override suspend fun createResolverQueryLogConfig(input: CreateResolverQueryLogConfigRequest): CreateResolverQueryLogConfigResponse {
        val op = SdkHttpOperation.build<CreateResolverQueryLogConfigRequest, CreateResolverQueryLogConfigResponse> {
            serializer = CreateResolverQueryLogConfigOperationSerializer()
            deserializer = CreateResolverQueryLogConfigOperationDeserializer()
            operationName = "CreateResolverQueryLogConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.
     */
    override suspend fun createResolverRule(input: CreateResolverRuleRequest): CreateResolverRuleResponse {
        val op = SdkHttpOperation.build<CreateResolverRuleRequest, CreateResolverRuleResponse> {
            serializer = CreateResolverRuleOperationSerializer()
            deserializer = CreateResolverRuleOperationDeserializer()
            operationName = "CreateResolverRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified domain list.
     */
    override suspend fun deleteFirewallDomainList(input: DeleteFirewallDomainListRequest): DeleteFirewallDomainListResponse {
        val op = SdkHttpOperation.build<DeleteFirewallDomainListRequest, DeleteFirewallDomainListResponse> {
            serializer = DeleteFirewallDomainListOperationSerializer()
            deserializer = DeleteFirewallDomainListOperationDeserializer()
            operationName = "DeleteFirewallDomainList"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified firewall rule.
     */
    override suspend fun deleteFirewallRule(input: DeleteFirewallRuleRequest): DeleteFirewallRuleResponse {
        val op = SdkHttpOperation.build<DeleteFirewallRuleRequest, DeleteFirewallRuleResponse> {
            serializer = DeleteFirewallRuleOperationSerializer()
            deserializer = DeleteFirewallRuleOperationDeserializer()
            operationName = "DeleteFirewallRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified firewall rule group.
     */
    override suspend fun deleteFirewallRuleGroup(input: DeleteFirewallRuleGroupRequest): DeleteFirewallRuleGroupResponse {
        val op = SdkHttpOperation.build<DeleteFirewallRuleGroupRequest, DeleteFirewallRuleGroupResponse> {
            serializer = DeleteFirewallRuleGroupOperationSerializer()
            deserializer = DeleteFirewallRuleGroupOperationDeserializer()
            operationName = "DeleteFirewallRuleGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Resolver on the Outpost.
     */
    override suspend fun deleteOutpostResolver(input: DeleteOutpostResolverRequest): DeleteOutpostResolverResponse {
        val op = SdkHttpOperation.build<DeleteOutpostResolverRequest, DeleteOutpostResolverResponse> {
            serializer = DeleteOutpostResolverOperationSerializer()
            deserializer = DeleteOutpostResolverOperationDeserializer()
            operationName = "DeleteOutpostResolver"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it's an inbound or an outbound Resolver endpoint:
     * + **Inbound**: DNS queries from your network are no longer routed to the DNS service for the specified VPC.
     * + **Outbound**: DNS queries from a VPC are no longer routed to your network.
     */
    override suspend fun deleteResolverEndpoint(input: DeleteResolverEndpointRequest): DeleteResolverEndpointResponse {
        val op = SdkHttpOperation.build<DeleteResolverEndpointRequest, DeleteResolverEndpointResponse> {
            serializer = DeleteResolverEndpointOperationSerializer()
            deserializer = DeleteResolverEndpointOperationDeserializer()
            operationName = "DeleteResolverEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for all of the Amazon VPCs that are associated with the configuration. This also applies if the query logging configuration is shared with other Amazon Web Services accounts, and the other accounts have associated VPCs with the shared configuration.
     *
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. See [DisassociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
     *
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, you must stop sharing the configuration before you can delete a configuration. The accounts that you shared the configuration with can first disassociate VPCs that they associated with the configuration, but that's not necessary. If you stop sharing the configuration, those VPCs are automatically disassociated from the configuration.
     */
    override suspend fun deleteResolverQueryLogConfig(input: DeleteResolverQueryLogConfigRequest): DeleteResolverQueryLogConfigResponse {
        val op = SdkHttpOperation.build<DeleteResolverQueryLogConfigRequest, DeleteResolverQueryLogConfigResponse> {
            serializer = DeleteResolverQueryLogConfigOperationSerializer()
            deserializer = DeleteResolverQueryLogConfigOperationDeserializer()
            operationName = "DeleteResolverQueryLogConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that you associated the Resolver rule with. For more information, see [DisassociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html).
     */
    override suspend fun deleteResolverRule(input: DeleteResolverRuleRequest): DeleteResolverRuleResponse {
        val op = SdkHttpOperation.build<DeleteResolverRuleRequest, DeleteResolverRuleResponse> {
            serializer = DeleteResolverRuleOperationSerializer()
            deserializer = DeleteResolverRuleOperationDeserializer()
            operationName = "DeleteResolverRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a FirewallRuleGroup from a VPC, to remove DNS filtering from the VPC.
     */
    override suspend fun disassociateFirewallRuleGroup(input: DisassociateFirewallRuleGroupRequest): DisassociateFirewallRuleGroupResponse {
        val op = SdkHttpOperation.build<DisassociateFirewallRuleGroupRequest, DisassociateFirewallRuleGroupResponse> {
            serializer = DisassociateFirewallRuleGroupOperationSerializer()
            deserializer = DisassociateFirewallRuleGroupOperationDeserializer()
            operationName = "DisassociateFirewallRuleGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP address, submit one `DisassociateResolverEndpointIpAddress` request for each IP address.
     *
     * To add an IP address to an endpoint, see [AssociateResolverEndpointIpAddress](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html).
     */
    override suspend fun disassociateResolverEndpointIpAddress(input: DisassociateResolverEndpointIpAddressRequest): DisassociateResolverEndpointIpAddressResponse {
        val op = SdkHttpOperation.build<DisassociateResolverEndpointIpAddressRequest, DisassociateResolverEndpointIpAddressResponse> {
            serializer = DisassociateResolverEndpointIpAddressOperationSerializer()
            deserializer = DisassociateResolverEndpointIpAddressOperationDeserializer()
            operationName = "DisassociateResolverEndpointIpAddress"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a VPC from a query logging configuration.
     *
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, VPCs can be disassociated from the configuration in the following ways:
     * + The accounts that you shared the configuration with can disassociate VPCs from the configuration.
     * + You can stop sharing the configuration.
     */
    override suspend fun disassociateResolverQueryLogConfig(input: DisassociateResolverQueryLogConfigRequest): DisassociateResolverQueryLogConfigResponse {
        val op = SdkHttpOperation.build<DisassociateResolverQueryLogConfigRequest, DisassociateResolverQueryLogConfigResponse> {
            serializer = DisassociateResolverQueryLogConfigOperationSerializer()
            deserializer = DisassociateResolverQueryLogConfigOperationDeserializer()
            operationName = "DisassociateResolverQueryLogConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the association between a specified Resolver rule and a specified VPC.
     *
     * If you disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the domain name that you specified in the Resolver rule.
     */
    override suspend fun disassociateResolverRule(input: DisassociateResolverRuleRequest): DisassociateResolverRuleResponse {
        val op = SdkHttpOperation.build<DisassociateResolverRuleRequest, DisassociateResolverRuleResponse> {
            serializer = DisassociateResolverRuleOperationSerializer()
            deserializer = DisassociateResolverRuleOperationDeserializer()
            operationName = "DisassociateResolverRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
     */
    override suspend fun getFirewallConfig(input: GetFirewallConfigRequest): GetFirewallConfigResponse {
        val op = SdkHttpOperation.build<GetFirewallConfigRequest, GetFirewallConfigResponse> {
            serializer = GetFirewallConfigOperationSerializer()
            deserializer = GetFirewallConfigOperationDeserializer()
            operationName = "GetFirewallConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the specified firewall domain list.
     */
    override suspend fun getFirewallDomainList(input: GetFirewallDomainListRequest): GetFirewallDomainListResponse {
        val op = SdkHttpOperation.build<GetFirewallDomainListRequest, GetFirewallDomainListResponse> {
            serializer = GetFirewallDomainListOperationSerializer()
            deserializer = GetFirewallDomainListOperationDeserializer()
            operationName = "GetFirewallDomainList"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the specified firewall rule group.
     */
    override suspend fun getFirewallRuleGroup(input: GetFirewallRuleGroupRequest): GetFirewallRuleGroupResponse {
        val op = SdkHttpOperation.build<GetFirewallRuleGroupRequest, GetFirewallRuleGroupResponse> {
            serializer = GetFirewallRuleGroupOperationSerializer()
            deserializer = GetFirewallRuleGroupOperationDeserializer()
            operationName = "GetFirewallRuleGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one rule group. A VPC can have more than one firewall rule group association, and a rule group can be associated with more than one VPC.
     */
    override suspend fun getFirewallRuleGroupAssociation(input: GetFirewallRuleGroupAssociationRequest): GetFirewallRuleGroupAssociationResponse {
        val op = SdkHttpOperation.build<GetFirewallRuleGroupAssociationRequest, GetFirewallRuleGroupAssociationResponse> {
            serializer = GetFirewallRuleGroupAssociationOperationSerializer()
            deserializer = GetFirewallRuleGroupAssociationOperationDeserializer()
            operationName = "GetFirewallRuleGroupAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule group. You can use the policy to share the rule group using Resource Access Manager (RAM).
     */
    override suspend fun getFirewallRuleGroupPolicy(input: GetFirewallRuleGroupPolicyRequest): GetFirewallRuleGroupPolicyResponse {
        val op = SdkHttpOperation.build<GetFirewallRuleGroupPolicyRequest, GetFirewallRuleGroupPolicyResponse> {
            serializer = GetFirewallRuleGroupPolicyOperationSerializer()
            deserializer = GetFirewallRuleGroupPolicyOperationDeserializer()
            operationName = "GetFirewallRuleGroupPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a specified Resolver on the Outpost, such as its instance count and type, name, and the current status of the Resolver.
     */
    override suspend fun getOutpostResolver(input: GetOutpostResolverRequest): GetOutpostResolverResponse {
        val op = SdkHttpOperation.build<GetOutpostResolverRequest, GetOutpostResolverResponse> {
            serializer = GetOutpostResolverOperationSerializer()
            deserializer = GetOutpostResolverOperationDeserializer()
            operationName = "GetOutpostResolver"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.
     */
    override suspend fun getResolverConfig(input: GetResolverConfigRequest): GetResolverConfigResponse {
        val op = SdkHttpOperation.build<GetResolverConfigRequest, GetResolverConfigResponse> {
            serializer = GetResolverConfigOperationSerializer()
            deserializer = GetResolverConfigOperationDeserializer()
            operationName = "GetResolverConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets DNSSEC validation information for a specified resource.
     */
    override suspend fun getResolverDnssecConfig(input: GetResolverDnssecConfigRequest): GetResolverDnssecConfigResponse {
        val op = SdkHttpOperation.build<GetResolverDnssecConfigRequest, GetResolverDnssecConfigResponse> {
            serializer = GetResolverDnssecConfigOperationSerializer()
            deserializer = GetResolverDnssecConfigOperationDeserializer()
            operationName = "GetResolverDnssecConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a specified Resolver endpoint, such as whether it's an inbound or an outbound Resolver endpoint, and the current status of the endpoint.
     */
    override suspend fun getResolverEndpoint(input: GetResolverEndpointRequest): GetResolverEndpointResponse {
        val op = SdkHttpOperation.build<GetResolverEndpointRequest, GetResolverEndpointResponse> {
            serializer = GetResolverEndpointOperationSerializer()
            deserializer = GetResolverEndpointOperationDeserializer()
            operationName = "GetResolverEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the configuration is logging queries for and the location that logs are sent to.
     */
    override suspend fun getResolverQueryLogConfig(input: GetResolverQueryLogConfigRequest): GetResolverQueryLogConfigResponse {
        val op = SdkHttpOperation.build<GetResolverQueryLogConfigRequest, GetResolverQueryLogConfigResponse> {
            serializer = GetResolverQueryLogConfigOperationSerializer()
            deserializer = GetResolverQueryLogConfigOperationDeserializer()
            operationName = "GetResolverQueryLogConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC. When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that VPC.
     */
    override suspend fun getResolverQueryLogConfigAssociation(input: GetResolverQueryLogConfigAssociationRequest): GetResolverQueryLogConfigAssociationResponse {
        val op = SdkHttpOperation.build<GetResolverQueryLogConfigAssociationRequest, GetResolverQueryLogConfigAssociationResponse> {
            serializer = GetResolverQueryLogConfigAssociationOperationSerializer()
            deserializer = GetResolverQueryLogConfigAssociationOperationDeserializer()
            operationName = "GetResolverQueryLogConfigAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a query logging policy. A query logging policy specifies the Resolver query logging operations and resources that you want to allow another Amazon Web Services account to be able to use.
     */
    override suspend fun getResolverQueryLogConfigPolicy(input: GetResolverQueryLogConfigPolicyRequest): GetResolverQueryLogConfigPolicyResponse {
        val op = SdkHttpOperation.build<GetResolverQueryLogConfigPolicyRequest, GetResolverQueryLogConfigPolicyResponse> {
            serializer = GetResolverQueryLogConfigPolicyOperationSerializer()
            deserializer = GetResolverQueryLogConfigPolicyOperationDeserializer()
            operationName = "GetResolverQueryLogConfigPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for and the ID of the outbound Resolver endpoint that the rule is associated with.
     */
    override suspend fun getResolverRule(input: GetResolverRuleRequest): GetResolverRuleResponse {
        val op = SdkHttpOperation.build<GetResolverRuleRequest, GetResolverRuleResponse> {
            serializer = GetResolverRuleOperationSerializer()
            deserializer = GetResolverRuleOperationDeserializer()
            operationName = "GetResolverRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule and a VPC using [AssociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html).
     */
    override suspend fun getResolverRuleAssociation(input: GetResolverRuleAssociationRequest): GetResolverRuleAssociationResponse {
        val op = SdkHttpOperation.build<GetResolverRuleAssociationRequest, GetResolverRuleAssociationResponse> {
            serializer = GetResolverRuleAssociationOperationSerializer()
            deserializer = GetResolverRuleAssociationOperationDeserializer()
            operationName = "GetResolverRuleAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule that you want to share with another account, the account that you want to share the rule with, and the Resolver operations that you want to allow the account to use.
     */
    override suspend fun getResolverRulePolicy(input: GetResolverRulePolicyRequest): GetResolverRulePolicyResponse {
        val op = SdkHttpOperation.build<GetResolverRulePolicyRequest, GetResolverRulePolicyResponse> {
            serializer = GetResolverRulePolicyOperationSerializer()
            deserializer = GetResolverRulePolicyOperationDeserializer()
            operationName = "GetResolverRulePolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Imports domain names from a file into a domain list, for use in a DNS firewall rule group.
     *
     * Each domain specification in your domain list must satisfy the following requirements:
     * + It can optionally start with `*` (asterisk).
     * + With the exception of the optional starting asterisk, it must only contain the following characters: `A-Z`, `a-z`, `0-9`, `-` (hyphen).
     * + It must be from 1-255 characters in length.
     */
    override suspend fun importFirewallDomains(input: ImportFirewallDomainsRequest): ImportFirewallDomainsResponse {
        val op = SdkHttpOperation.build<ImportFirewallDomainsRequest, ImportFirewallDomainsResponse> {
            serializer = ImportFirewallDomainsOperationSerializer()
            deserializer = ImportFirewallDomainsOperationDeserializer()
            operationName = "ImportFirewallDomains"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage firewall behavior for your VPCs.
     *
     * A single call might return only a partial list of the configurations. For information, see `MaxResults`.
     */
    override suspend fun listFirewallConfigs(input: ListFirewallConfigsRequest): ListFirewallConfigsResponse {
        val op = SdkHttpOperation.build<ListFirewallConfigsRequest, ListFirewallConfigsResponse> {
            serializer = ListFirewallConfigsOperationSerializer()
            deserializer = ListFirewallConfigsOperationDeserializer()
            operationName = "ListFirewallConfigs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the domains that are defined for a list by calling ListFirewallDomains.
     *
     * A single call to this list operation might return only a partial list of the domain lists. For information, see `MaxResults`.
     */
    override suspend fun listFirewallDomainLists(input: ListFirewallDomainListsRequest): ListFirewallDomainListsResponse {
        val op = SdkHttpOperation.build<ListFirewallDomainListsRequest, ListFirewallDomainListsResponse> {
            serializer = ListFirewallDomainListsOperationSerializer()
            deserializer = ListFirewallDomainListsOperationDeserializer()
            operationName = "ListFirewallDomainLists"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the domains that you have defined for the specified firewall domain list.
     *
     * A single call might return only a partial list of the domains. For information, see `MaxResults`.
     */
    override suspend fun listFirewallDomains(input: ListFirewallDomainsRequest): ListFirewallDomainsResponse {
        val op = SdkHttpOperation.build<ListFirewallDomainsRequest, ListFirewallDomainsResponse> {
            serializer = ListFirewallDomainsOperationSerializer()
            deserializer = ListFirewallDomainsOperationDeserializer()
            operationName = "ListFirewallDomains"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for a VPC with one rule group.
     *
     * A single call might return only a partial list of the associations. For information, see `MaxResults`.
     */
    override suspend fun listFirewallRuleGroupAssociations(input: ListFirewallRuleGroupAssociationsRequest): ListFirewallRuleGroupAssociationsResponse {
        val op = SdkHttpOperation.build<ListFirewallRuleGroupAssociationsRequest, ListFirewallRuleGroupAssociationsResponse> {
            serializer = ListFirewallRuleGroupAssociationsOperationSerializer()
            deserializer = ListFirewallRuleGroupAssociationsOperationDeserializer()
            operationName = "ListFirewallRuleGroupAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the minimal high-level information for the rule groups that you have defined.
     *
     * A single call might return only a partial list of the rule groups. For information, see `MaxResults`.
     */
    override suspend fun listFirewallRuleGroups(input: ListFirewallRuleGroupsRequest): ListFirewallRuleGroupsResponse {
        val op = SdkHttpOperation.build<ListFirewallRuleGroupsRequest, ListFirewallRuleGroupsResponse> {
            serializer = ListFirewallRuleGroupsOperationSerializer()
            deserializer = ListFirewallRuleGroupsOperationDeserializer()
            operationName = "ListFirewallRuleGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the rules in a rule group to filter DNS network traffic for a VPC.
     *
     * A single call might return only a partial list of the rules. For information, see `MaxResults`.
     */
    override suspend fun listFirewallRules(input: ListFirewallRulesRequest): ListFirewallRulesResponse {
        val op = SdkHttpOperation.build<ListFirewallRulesRequest, ListFirewallRulesResponse> {
            serializer = ListFirewallRulesOperationSerializer()
            deserializer = ListFirewallRulesOperationDeserializer()
            operationName = "ListFirewallRules"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the Resolvers on Outposts that were created using the current Amazon Web Services account.
     */
    override suspend fun listOutpostResolvers(input: ListOutpostResolversRequest): ListOutpostResolversResponse {
        val op = SdkHttpOperation.build<ListOutpostResolversRequest, ListOutpostResolversResponse> {
            serializer = ListOutpostResolversOperationSerializer()
            deserializer = ListOutpostResolversOperationDeserializer()
            operationName = "ListOutpostResolvers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the configurations to manage DNS resolution behavior for your VPCs.
     */
    override suspend fun listResolverConfigs(input: ListResolverConfigsRequest): ListResolverConfigsResponse {
        val op = SdkHttpOperation.build<ListResolverConfigsRequest, ListResolverConfigsResponse> {
            serializer = ListResolverConfigsOperationSerializer()
            deserializer = ListResolverConfigsOperationDeserializer()
            operationName = "ListResolverConfigs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.
     */
    override suspend fun listResolverDnssecConfigs(input: ListResolverDnssecConfigsRequest): ListResolverDnssecConfigsResponse {
        val op = SdkHttpOperation.build<ListResolverDnssecConfigsRequest, ListResolverDnssecConfigsResponse> {
            serializer = ListResolverDnssecConfigsOperationSerializer()
            deserializer = ListResolverDnssecConfigsOperationDeserializer()
            operationName = "ListResolverDnssecConfigs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the IP addresses for a specified Resolver endpoint.
     */
    override suspend fun listResolverEndpointIpAddresses(input: ListResolverEndpointIpAddressesRequest): ListResolverEndpointIpAddressesResponse {
        val op = SdkHttpOperation.build<ListResolverEndpointIpAddressesRequest, ListResolverEndpointIpAddressesResponse> {
            serializer = ListResolverEndpointIpAddressesOperationSerializer()
            deserializer = ListResolverEndpointIpAddressesOperationDeserializer()
            operationName = "ListResolverEndpointIpAddresses"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the Resolver endpoints that were created using the current Amazon Web Services account.
     */
    override suspend fun listResolverEndpoints(input: ListResolverEndpointsRequest): ListResolverEndpointsResponse {
        val op = SdkHttpOperation.build<ListResolverEndpointsRequest, ListResolverEndpointsResponse> {
            serializer = ListResolverEndpointsOperationSerializer()
            deserializer = ListResolverEndpointsOperationDeserializer()
            operationName = "ListResolverEndpoints"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about associations between Amazon VPCs and query logging configurations.
     */
    override suspend fun listResolverQueryLogConfigAssociations(input: ListResolverQueryLogConfigAssociationsRequest): ListResolverQueryLogConfigAssociationsResponse {
        val op = SdkHttpOperation.build<ListResolverQueryLogConfigAssociationsRequest, ListResolverQueryLogConfigAssociationsResponse> {
            serializer = ListResolverQueryLogConfigAssociationsOperationSerializer()
            deserializer = ListResolverQueryLogConfigAssociationsOperationDeserializer()
            operationName = "ListResolverQueryLogConfigAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about the specified query logging configurations. Each configuration defines where you want Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
     */
    override suspend fun listResolverQueryLogConfigs(input: ListResolverQueryLogConfigsRequest): ListResolverQueryLogConfigsResponse {
        val op = SdkHttpOperation.build<ListResolverQueryLogConfigsRequest, ListResolverQueryLogConfigsResponse> {
            serializer = ListResolverQueryLogConfigsOperationSerializer()
            deserializer = ListResolverQueryLogConfigsOperationDeserializer()
            operationName = "ListResolverQueryLogConfigs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services account.
     */
    override suspend fun listResolverRuleAssociations(input: ListResolverRuleAssociationsRequest): ListResolverRuleAssociationsResponse {
        val op = SdkHttpOperation.build<ListResolverRuleAssociationsRequest, ListResolverRuleAssociationsResponse> {
            serializer = ListResolverRuleAssociationsOperationSerializer()
            deserializer = ListResolverRuleAssociationsOperationDeserializer()
            operationName = "ListResolverRuleAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Resolver rules that were created using the current Amazon Web Services account.
     */
    override suspend fun listResolverRules(input: ListResolverRulesRequest): ListResolverRulesResponse {
        val op = SdkHttpOperation.build<ListResolverRulesRequest, ListResolverRulesResponse> {
            serializer = ListResolverRulesOperationSerializer()
            deserializer = ListResolverRulesOperationDeserializer()
            operationName = "ListResolverRules"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags that you associated with the specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches an Identity and Access Management (Amazon Web Services IAM) policy for sharing the rule group. You can use the policy to share the rule group using Resource Access Manager (RAM).
     */
    override suspend fun putFirewallRuleGroupPolicy(input: PutFirewallRuleGroupPolicyRequest): PutFirewallRuleGroupPolicyResponse {
        val op = SdkHttpOperation.build<PutFirewallRuleGroupPolicyRequest, PutFirewallRuleGroupPolicyResponse> {
            serializer = PutFirewallRuleGroupPolicyOperationSerializer()
            deserializer = PutFirewallRuleGroupPolicyOperationDeserializer()
            operationName = "PutFirewallRuleGroupPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Specifies an Amazon Web Services account that you want to share a query logging configuration with, the query logging configuration that you want to share, and the operations that you want the account to be able to perform on the configuration.
     */
    override suspend fun putResolverQueryLogConfigPolicy(input: PutResolverQueryLogConfigPolicyRequest): PutResolverQueryLogConfigPolicyResponse {
        val op = SdkHttpOperation.build<PutResolverQueryLogConfigPolicyRequest, PutResolverQueryLogConfigPolicyResponse> {
            serializer = PutResolverQueryLogConfigPolicyOperationSerializer()
            deserializer = PutResolverQueryLogConfigPolicyOperationDeserializer()
            operationName = "PutResolverQueryLogConfigPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Specifies an Amazon Web Services rule that you want to share with another account, the account that you want to share the rule with, and the operations that you want the account to be able to perform on the rule.
     */
    override suspend fun putResolverRulePolicy(input: PutResolverRulePolicyRequest): PutResolverRulePolicyResponse {
        val op = SdkHttpOperation.build<PutResolverRulePolicyRequest, PutResolverRulePolicyResponse> {
            serializer = PutResolverRulePolicyOperationSerializer()
            deserializer = PutResolverRulePolicyOperationDeserializer()
            operationName = "PutResolverRulePolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more tags to a specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from a specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
     */
    override suspend fun updateFirewallConfig(input: UpdateFirewallConfigRequest): UpdateFirewallConfigResponse {
        val op = SdkHttpOperation.build<UpdateFirewallConfigRequest, UpdateFirewallConfigResponse> {
            serializer = UpdateFirewallConfigOperationSerializer()
            deserializer = UpdateFirewallConfigOperationDeserializer()
            operationName = "UpdateFirewallConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the firewall domain list from an array of domain specifications.
     */
    override suspend fun updateFirewallDomains(input: UpdateFirewallDomainsRequest): UpdateFirewallDomainsResponse {
        val op = SdkHttpOperation.build<UpdateFirewallDomainsRequest, UpdateFirewallDomainsResponse> {
            serializer = UpdateFirewallDomainsOperationSerializer()
            deserializer = UpdateFirewallDomainsOperationDeserializer()
            operationName = "UpdateFirewallDomains"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified firewall rule.
     */
    override suspend fun updateFirewallRule(input: UpdateFirewallRuleRequest): UpdateFirewallRuleResponse {
        val op = SdkHttpOperation.build<UpdateFirewallRuleRequest, UpdateFirewallRuleResponse> {
            serializer = UpdateFirewallRuleOperationSerializer()
            deserializer = UpdateFirewallRuleOperationDeserializer()
            operationName = "UpdateFirewallRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes the association of a FirewallRuleGroup with a VPC. The association enables DNS filtering for the VPC.
     */
    override suspend fun updateFirewallRuleGroupAssociation(input: UpdateFirewallRuleGroupAssociationRequest): UpdateFirewallRuleGroupAssociationResponse {
        val op = SdkHttpOperation.build<UpdateFirewallRuleGroupAssociationRequest, UpdateFirewallRuleGroupAssociationResponse> {
            serializer = UpdateFirewallRuleGroupAssociationOperationSerializer()
            deserializer = UpdateFirewallRuleGroupAssociationOperationDeserializer()
            operationName = "UpdateFirewallRuleGroupAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * You can use `UpdateOutpostResolver` to update the instance count, type, or name of a Resolver on an Outpost.
     */
    override suspend fun updateOutpostResolver(input: UpdateOutpostResolverRequest): UpdateOutpostResolverResponse {
        val op = SdkHttpOperation.build<UpdateOutpostResolverRequest, UpdateOutpostResolverResponse> {
            serializer = UpdateOutpostResolverOperationSerializer()
            deserializer = UpdateOutpostResolverOperationDeserializer()
            operationName = "UpdateOutpostResolver"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.
     */
    override suspend fun updateResolverConfig(input: UpdateResolverConfigRequest): UpdateResolverConfigResponse {
        val op = SdkHttpOperation.build<UpdateResolverConfigRequest, UpdateResolverConfigResponse> {
            serializer = UpdateResolverConfigOperationSerializer()
            deserializer = UpdateResolverConfigOperationDeserializer()
            operationName = "UpdateResolverConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one is created.
     */
    override suspend fun updateResolverDnssecConfig(input: UpdateResolverDnssecConfigRequest): UpdateResolverDnssecConfigResponse {
        val op = SdkHttpOperation.build<UpdateResolverDnssecConfigRequest, UpdateResolverDnssecConfigResponse> {
            serializer = UpdateResolverDnssecConfigOperationSerializer()
            deserializer = UpdateResolverDnssecConfigOperationDeserializer()
            operationName = "UpdateResolverDnssecConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name, or endpoint type for an inbound or an outbound Resolver endpoint. You can only update between IPV4 and DUALSTACK, IPV6 endpoint type can't be updated to other type.
     */
    override suspend fun updateResolverEndpoint(input: UpdateResolverEndpointRequest): UpdateResolverEndpointResponse {
        val op = SdkHttpOperation.build<UpdateResolverEndpointRequest, UpdateResolverEndpointResponse> {
            serializer = UpdateResolverEndpointOperationSerializer()
            deserializer = UpdateResolverEndpointOperationDeserializer()
            operationName = "UpdateResolverEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates settings for a specified Resolver rule. `ResolverRuleId` is required, and all other parameters are optional. If you don't specify a parameter, it retains its current value.
     */
    override suspend fun updateResolverRule(input: UpdateResolverRuleRequest): UpdateResolverRuleResponse {
        val op = SdkHttpOperation.build<UpdateResolverRuleRequest, UpdateResolverRuleResponse> {
            serializer = UpdateResolverRuleOperationSerializer()
            deserializer = UpdateResolverRuleOperationDeserializer()
            operationName = "UpdateResolverRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("Route53Resolver", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "route53resolver")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
