// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.paginators

import aws.sdk.kotlin.services.route53resolver.Route53ResolverClient
import aws.sdk.kotlin.services.route53resolver.model.FirewallConfig
import aws.sdk.kotlin.services.route53resolver.model.FirewallDomainListMetadata
import aws.sdk.kotlin.services.route53resolver.model.FirewallRule
import aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupAssociation
import aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupMetadata
import aws.sdk.kotlin.services.route53resolver.model.IpAddressResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallConfigsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallConfigsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallDomainListsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallDomainListsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallDomainsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallDomainsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRulesRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRulesResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverConfigsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverConfigsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverDnssecConfigsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverDnssecConfigsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverEndpointIpAddressesRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverEndpointIpAddressesResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverEndpointsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverEndpointsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverRuleAssociationsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverRuleAssociationsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesResponse
import aws.sdk.kotlin.services.route53resolver.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.route53resolver.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.route53resolver.model.ResolverConfig
import aws.sdk.kotlin.services.route53resolver.model.ResolverDnssecConfig
import aws.sdk.kotlin.services.route53resolver.model.ResolverEndpoint
import aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfig
import aws.sdk.kotlin.services.route53resolver.model.ResolverQueryLogConfigAssociation
import aws.sdk.kotlin.services.route53resolver.model.ResolverRule
import aws.sdk.kotlin.services.route53resolver.model.ResolverRuleAssociation
import aws.sdk.kotlin.services.route53resolver.model.Tag
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListFirewallConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallConfigsResponse]
 */
public fun Route53ResolverClient.listFirewallConfigsPaginated(initialRequest: ListFirewallConfigsRequest): Flow<ListFirewallConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallConfigsPaginated.listFirewallConfigs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallConfigsResponse]
 */
public fun Route53ResolverClient.listFirewallConfigsPaginated(block: ListFirewallConfigsRequest.Builder.() -> Unit): Flow<ListFirewallConfigsResponse> =
    listFirewallConfigsPaginated(ListFirewallConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFirewallConfigsPaginated]
 * to access the nested member [FirewallConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FirewallConfig]
 */
@JvmName("listFirewallConfigsResponseFirewallConfig")
public fun Flow<ListFirewallConfigsResponse>.firewallConfigs(): Flow<FirewallConfig> =
    transform() { response ->
        response.firewallConfigs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFirewallDomainListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallDomainListsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallDomainListsResponse]
 */
public fun Route53ResolverClient.listFirewallDomainListsPaginated(initialRequest: ListFirewallDomainListsRequest): Flow<ListFirewallDomainListsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallDomainListsPaginated.listFirewallDomainLists(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallDomainListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallDomainListsResponse]
 */
public fun Route53ResolverClient.listFirewallDomainListsPaginated(block: ListFirewallDomainListsRequest.Builder.() -> Unit): Flow<ListFirewallDomainListsResponse> =
    listFirewallDomainListsPaginated(ListFirewallDomainListsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFirewallDomainListsPaginated]
 * to access the nested member [FirewallDomainListMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FirewallDomainListMetadata]
 */
@JvmName("listFirewallDomainListsResponseFirewallDomainListMetadata")
public fun Flow<ListFirewallDomainListsResponse>.firewallDomainLists(): Flow<FirewallDomainListMetadata> =
    transform() { response ->
        response.firewallDomainLists?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFirewallDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallDomainsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallDomainsResponse]
 */
public fun Route53ResolverClient.listFirewallDomainsPaginated(initialRequest: ListFirewallDomainsRequest): Flow<ListFirewallDomainsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallDomainsPaginated.listFirewallDomains(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallDomainsResponse]
 */
public fun Route53ResolverClient.listFirewallDomainsPaginated(block: ListFirewallDomainsRequest.Builder.() -> Unit): Flow<ListFirewallDomainsResponse> =
    listFirewallDomainsPaginated(ListFirewallDomainsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFirewallDomainsPaginated]
 * to access the nested member [FirewallDomainName]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FirewallDomainName]
 */
@JvmName("listFirewallDomainsResponseFirewallDomainName")
public fun Flow<ListFirewallDomainsResponse>.domains(): Flow<String> =
    transform() { response ->
        response.domains?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFirewallRuleGroupAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallRuleGroupAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallRuleGroupAssociationsResponse]
 */
public fun Route53ResolverClient.listFirewallRuleGroupAssociationsPaginated(initialRequest: ListFirewallRuleGroupAssociationsRequest): Flow<ListFirewallRuleGroupAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallRuleGroupAssociationsPaginated.listFirewallRuleGroupAssociations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallRuleGroupAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallRuleGroupAssociationsResponse]
 */
public fun Route53ResolverClient.listFirewallRuleGroupAssociationsPaginated(block: ListFirewallRuleGroupAssociationsRequest.Builder.() -> Unit): Flow<ListFirewallRuleGroupAssociationsResponse> =
    listFirewallRuleGroupAssociationsPaginated(ListFirewallRuleGroupAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFirewallRuleGroupAssociationsPaginated]
 * to access the nested member [FirewallRuleGroupAssociation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FirewallRuleGroupAssociation]
 */
@JvmName("listFirewallRuleGroupAssociationsResponseFirewallRuleGroupAssociation")
public fun Flow<ListFirewallRuleGroupAssociationsResponse>.firewallRuleGroupAssociations(): Flow<FirewallRuleGroupAssociation> =
    transform() { response ->
        response.firewallRuleGroupAssociations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFirewallRuleGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallRuleGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallRuleGroupsResponse]
 */
public fun Route53ResolverClient.listFirewallRuleGroupsPaginated(initialRequest: ListFirewallRuleGroupsRequest): Flow<ListFirewallRuleGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallRuleGroupsPaginated.listFirewallRuleGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallRuleGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallRuleGroupsResponse]
 */
public fun Route53ResolverClient.listFirewallRuleGroupsPaginated(block: ListFirewallRuleGroupsRequest.Builder.() -> Unit): Flow<ListFirewallRuleGroupsResponse> =
    listFirewallRuleGroupsPaginated(ListFirewallRuleGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFirewallRuleGroupsPaginated]
 * to access the nested member [FirewallRuleGroupMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FirewallRuleGroupMetadata]
 */
@JvmName("listFirewallRuleGroupsResponseFirewallRuleGroupMetadata")
public fun Flow<ListFirewallRuleGroupsResponse>.firewallRuleGroups(): Flow<FirewallRuleGroupMetadata> =
    transform() { response ->
        response.firewallRuleGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFirewallRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallRulesResponse]
 */
public fun Route53ResolverClient.listFirewallRulesPaginated(initialRequest: ListFirewallRulesRequest): Flow<ListFirewallRulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallRulesPaginated.listFirewallRules(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallRulesResponse]
 */
public fun Route53ResolverClient.listFirewallRulesPaginated(block: ListFirewallRulesRequest.Builder.() -> Unit): Flow<ListFirewallRulesResponse> =
    listFirewallRulesPaginated(ListFirewallRulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFirewallRulesPaginated]
 * to access the nested member [FirewallRule]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FirewallRule]
 */
@JvmName("listFirewallRulesResponseFirewallRule")
public fun Flow<ListFirewallRulesResponse>.firewallRules(): Flow<FirewallRule> =
    transform() { response ->
        response.firewallRules?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResolverConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverConfigsResponse]
 */
public fun Route53ResolverClient.listResolverConfigsPaginated(initialRequest: ListResolverConfigsRequest): Flow<ListResolverConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverConfigsPaginated.listResolverConfigs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverConfigsResponse]
 */
public fun Route53ResolverClient.listResolverConfigsPaginated(block: ListResolverConfigsRequest.Builder.() -> Unit): Flow<ListResolverConfigsResponse> =
    listResolverConfigsPaginated(ListResolverConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResolverConfigsPaginated]
 * to access the nested member [ResolverConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResolverConfig]
 */
@JvmName("listResolverConfigsResponseResolverConfig")
public fun Flow<ListResolverConfigsResponse>.resolverConfigs(): Flow<ResolverConfig> =
    transform() { response ->
        response.resolverConfigs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResolverDnssecConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverDnssecConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverDnssecConfigsResponse]
 */
public fun Route53ResolverClient.listResolverDnssecConfigsPaginated(initialRequest: ListResolverDnssecConfigsRequest): Flow<ListResolverDnssecConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverDnssecConfigsPaginated.listResolverDnssecConfigs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverDnssecConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverDnssecConfigsResponse]
 */
public fun Route53ResolverClient.listResolverDnssecConfigsPaginated(block: ListResolverDnssecConfigsRequest.Builder.() -> Unit): Flow<ListResolverDnssecConfigsResponse> =
    listResolverDnssecConfigsPaginated(ListResolverDnssecConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResolverDnssecConfigsPaginated]
 * to access the nested member [ResolverDnssecConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResolverDnssecConfig]
 */
@JvmName("listResolverDnssecConfigsResponseResolverDnssecConfig")
public fun Flow<ListResolverDnssecConfigsResponse>.resolverDnssecConfigs(): Flow<ResolverDnssecConfig> =
    transform() { response ->
        response.resolverDnssecConfigs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResolverEndpointIpAddressesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverEndpointIpAddressesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverEndpointIpAddressesResponse]
 */
public fun Route53ResolverClient.listResolverEndpointIpAddressesPaginated(initialRequest: ListResolverEndpointIpAddressesRequest): Flow<ListResolverEndpointIpAddressesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverEndpointIpAddressesPaginated.listResolverEndpointIpAddresses(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverEndpointIpAddressesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverEndpointIpAddressesResponse]
 */
public fun Route53ResolverClient.listResolverEndpointIpAddressesPaginated(block: ListResolverEndpointIpAddressesRequest.Builder.() -> Unit): Flow<ListResolverEndpointIpAddressesResponse> =
    listResolverEndpointIpAddressesPaginated(ListResolverEndpointIpAddressesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResolverEndpointIpAddressesPaginated]
 * to access the nested member [IpAddressResponse]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IpAddressResponse]
 */
@JvmName("listResolverEndpointIpAddressesResponseIpAddressResponse")
public fun Flow<ListResolverEndpointIpAddressesResponse>.ipAddresses(): Flow<IpAddressResponse> =
    transform() { response ->
        response.ipAddresses?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResolverEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverEndpointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverEndpointsResponse]
 */
public fun Route53ResolverClient.listResolverEndpointsPaginated(initialRequest: ListResolverEndpointsRequest): Flow<ListResolverEndpointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverEndpointsPaginated.listResolverEndpoints(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverEndpointsResponse]
 */
public fun Route53ResolverClient.listResolverEndpointsPaginated(block: ListResolverEndpointsRequest.Builder.() -> Unit): Flow<ListResolverEndpointsResponse> =
    listResolverEndpointsPaginated(ListResolverEndpointsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResolverEndpointsPaginated]
 * to access the nested member [ResolverEndpoint]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResolverEndpoint]
 */
@JvmName("listResolverEndpointsResponseResolverEndpoint")
public fun Flow<ListResolverEndpointsResponse>.resolverEndpoints(): Flow<ResolverEndpoint> =
    transform() { response ->
        response.resolverEndpoints?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResolverQueryLogConfigAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverQueryLogConfigAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverQueryLogConfigAssociationsResponse]
 */
public fun Route53ResolverClient.listResolverQueryLogConfigAssociationsPaginated(initialRequest: ListResolverQueryLogConfigAssociationsRequest): Flow<ListResolverQueryLogConfigAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverQueryLogConfigAssociationsPaginated.listResolverQueryLogConfigAssociations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverQueryLogConfigAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverQueryLogConfigAssociationsResponse]
 */
public fun Route53ResolverClient.listResolverQueryLogConfigAssociationsPaginated(block: ListResolverQueryLogConfigAssociationsRequest.Builder.() -> Unit): Flow<ListResolverQueryLogConfigAssociationsResponse> =
    listResolverQueryLogConfigAssociationsPaginated(ListResolverQueryLogConfigAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResolverQueryLogConfigAssociationsPaginated]
 * to access the nested member [ResolverQueryLogConfigAssociation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResolverQueryLogConfigAssociation]
 */
@JvmName("listResolverQueryLogConfigAssociationsResponseResolverQueryLogConfigAssociation")
public fun Flow<ListResolverQueryLogConfigAssociationsResponse>.resolverQueryLogConfigAssociations(): Flow<ResolverQueryLogConfigAssociation> =
    transform() { response ->
        response.resolverQueryLogConfigAssociations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResolverQueryLogConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverQueryLogConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverQueryLogConfigsResponse]
 */
public fun Route53ResolverClient.listResolverQueryLogConfigsPaginated(initialRequest: ListResolverQueryLogConfigsRequest): Flow<ListResolverQueryLogConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverQueryLogConfigsPaginated.listResolverQueryLogConfigs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverQueryLogConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverQueryLogConfigsResponse]
 */
public fun Route53ResolverClient.listResolverQueryLogConfigsPaginated(block: ListResolverQueryLogConfigsRequest.Builder.() -> Unit): Flow<ListResolverQueryLogConfigsResponse> =
    listResolverQueryLogConfigsPaginated(ListResolverQueryLogConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResolverQueryLogConfigsPaginated]
 * to access the nested member [ResolverQueryLogConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResolverQueryLogConfig]
 */
@JvmName("listResolverQueryLogConfigsResponseResolverQueryLogConfig")
public fun Flow<ListResolverQueryLogConfigsResponse>.resolverQueryLogConfigs(): Flow<ResolverQueryLogConfig> =
    transform() { response ->
        response.resolverQueryLogConfigs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResolverRuleAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverRuleAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverRuleAssociationsResponse]
 */
public fun Route53ResolverClient.listResolverRuleAssociationsPaginated(initialRequest: ListResolverRuleAssociationsRequest): Flow<ListResolverRuleAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverRuleAssociationsPaginated.listResolverRuleAssociations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverRuleAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverRuleAssociationsResponse]
 */
public fun Route53ResolverClient.listResolverRuleAssociationsPaginated(block: ListResolverRuleAssociationsRequest.Builder.() -> Unit): Flow<ListResolverRuleAssociationsResponse> =
    listResolverRuleAssociationsPaginated(ListResolverRuleAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResolverRuleAssociationsPaginated]
 * to access the nested member [ResolverRuleAssociation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResolverRuleAssociation]
 */
@JvmName("listResolverRuleAssociationsResponseResolverRuleAssociation")
public fun Flow<ListResolverRuleAssociationsResponse>.resolverRuleAssociations(): Flow<ResolverRuleAssociation> =
    transform() { response ->
        response.resolverRuleAssociations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResolverRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverRulesResponse]
 */
public fun Route53ResolverClient.listResolverRulesPaginated(initialRequest: ListResolverRulesRequest): Flow<ListResolverRulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverRulesPaginated.listResolverRules(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverRulesResponse]
 */
public fun Route53ResolverClient.listResolverRulesPaginated(block: ListResolverRulesRequest.Builder.() -> Unit): Flow<ListResolverRulesResponse> =
    listResolverRulesPaginated(ListResolverRulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResolverRulesPaginated]
 * to access the nested member [ResolverRule]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResolverRule]
 */
@JvmName("listResolverRulesResponseResolverRule")
public fun Flow<ListResolverRulesResponse>.resolverRules(): Flow<ResolverRule> =
    transform() { response ->
        response.resolverRules?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun Route53ResolverClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun Route53ResolverClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
public fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }
