// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



public class UpdateFirewallConfigRequest private constructor(builder: Builder) {
    /**
     * Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply.
     * + By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly.
     * + If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them.
     *
     * This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
     */
    public val firewallFailOpen: aws.sdk.kotlin.services.route53resolver.model.FirewallFailOpenStatus? = builder.firewallFailOpen
    /**
     * The ID of the VPC that the configuration is for.
     */
    public val resourceId: kotlin.String? = builder.resourceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFirewallConfigRequest(")
        append("firewallFailOpen=$firewallFailOpen,")
        append("resourceId=$resourceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = firewallFailOpen?.hashCode() ?: 0
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFirewallConfigRequest

        if (firewallFailOpen != other.firewallFailOpen) return false
        if (resourceId != other.resourceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallConfigRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply.
         * + By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly.
         * + If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them.
         *
         * This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
         */
        public var firewallFailOpen: aws.sdk.kotlin.services.route53resolver.model.FirewallFailOpenStatus? = null
        /**
         * The ID of the VPC that the configuration is for.
         */
        public var resourceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallConfigRequest) : this() {
            this.firewallFailOpen = x.firewallFailOpen
            this.resourceId = x.resourceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallConfigRequest = UpdateFirewallConfigRequest(this)
    }
}
