// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



public class ListResolverQueryLogConfigAssociationsRequest private constructor(builder: Builder) {
    /**
     * An optional specification to return a subset of query logging associations.
     *
     * If you submit a second or subsequent `ListResolverQueryLogConfigAssociations` request and specify the `NextToken` parameter, you must use the same values for `Filters`, if any, as in the previous request.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of query logging associations that you want to return in the response to a `ListResolverQueryLogConfigAssociations` request. If you don't specify a value for `MaxResults`, Resolver returns up to 100 query logging associations.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * For the first `ListResolverQueryLogConfigAssociations` request, omit this value.
     *
     * If there are more than `MaxResults` query logging associations that match the values that you specify for `Filters`, you can submit another `ListResolverQueryLogConfigAssociations` request to get the next group of associations. In the next request, specify the value of `NextToken` from the previous response.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The element that you want Resolver to sort query logging associations by.
     *
     * If you submit a second or subsequent `ListResolverQueryLogConfigAssociations` request and specify the `NextToken` parameter, you must use the same value for `SortBy`, if any, as in the previous request.
     *
     * Valid values include the following elements:
     * + `CreationTime`: The ID of the query logging association.
     * + `Error`: If the value of `Status` is `FAILED`, the value of `Error` indicates the cause:
     *    + `DESTINATION_NOT_FOUND`: The specified destination (for example, an Amazon S3 bucket) was deleted.
     *    + `ACCESS_DENIED`: Permissions don't allow sending logs to the destination.
     * If `Status` is a value other than `FAILED`, `ERROR` is null.
     * + `Id`: The ID of the query logging association
     * + `ResolverQueryLogConfigId`: The ID of the query logging configuration
     * + `ResourceId`: The ID of the VPC that is associated with the query logging configuration
     * + `Status`: The current status of the configuration. Valid values include the following:
     *    + `CREATING`: Resolver is creating an association between an Amazon VPC and a query logging configuration.
     *    + `CREATED`: The association between an Amazon VPC and a query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.
     *    + `DELETING`: Resolver is deleting this query logging association.
     *    + `FAILED`: Resolver either couldn't create or couldn't delete the query logging association. Here are two common causes:
     *       + The specified destination (for example, an Amazon S3 bucket) was deleted.
     *       + Permissions don't allow sending logs to the destination.
     */
    public val sortBy: kotlin.String? = builder.sortBy
    /**
     * If you specified a value for `SortBy`, the order that you want query logging associations to be listed in, `ASCENDING` or `DESCENDING`.
     *
     * If you submit a second or subsequent `ListResolverQueryLogConfigAssociations` request and specify the `NextToken` parameter, you must use the same value for `SortOrder`, if any, as in the previous request.
     */
    public val sortOrder: aws.sdk.kotlin.services.route53resolver.model.SortOrder? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListResolverQueryLogConfigAssociationsRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListResolverQueryLogConfigAssociationsRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An optional specification to return a subset of query logging associations.
         *
         * If you submit a second or subsequent `ListResolverQueryLogConfigAssociations` request and specify the `NextToken` parameter, you must use the same values for `Filters`, if any, as in the previous request.
         */
        public var filters: List<Filter>? = null
        /**
         * The maximum number of query logging associations that you want to return in the response to a `ListResolverQueryLogConfigAssociations` request. If you don't specify a value for `MaxResults`, Resolver returns up to 100 query logging associations.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * For the first `ListResolverQueryLogConfigAssociations` request, omit this value.
         *
         * If there are more than `MaxResults` query logging associations that match the values that you specify for `Filters`, you can submit another `ListResolverQueryLogConfigAssociations` request to get the next group of associations. In the next request, specify the value of `NextToken` from the previous response.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The element that you want Resolver to sort query logging associations by.
         *
         * If you submit a second or subsequent `ListResolverQueryLogConfigAssociations` request and specify the `NextToken` parameter, you must use the same value for `SortBy`, if any, as in the previous request.
         *
         * Valid values include the following elements:
         * + `CreationTime`: The ID of the query logging association.
         * + `Error`: If the value of `Status` is `FAILED`, the value of `Error` indicates the cause:
         *    + `DESTINATION_NOT_FOUND`: The specified destination (for example, an Amazon S3 bucket) was deleted.
         *    + `ACCESS_DENIED`: Permissions don't allow sending logs to the destination.
         * If `Status` is a value other than `FAILED`, `ERROR` is null.
         * + `Id`: The ID of the query logging association
         * + `ResolverQueryLogConfigId`: The ID of the query logging configuration
         * + `ResourceId`: The ID of the VPC that is associated with the query logging configuration
         * + `Status`: The current status of the configuration. Valid values include the following:
         *    + `CREATING`: Resolver is creating an association between an Amazon VPC and a query logging configuration.
         *    + `CREATED`: The association between an Amazon VPC and a query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.
         *    + `DELETING`: Resolver is deleting this query logging association.
         *    + `FAILED`: Resolver either couldn't create or couldn't delete the query logging association. Here are two common causes:
         *       + The specified destination (for example, an Amazon S3 bucket) was deleted.
         *       + Permissions don't allow sending logs to the destination.
         */
        public var sortBy: kotlin.String? = null
        /**
         * If you specified a value for `SortBy`, the order that you want query logging associations to be listed in, `ASCENDING` or `DESCENDING`.
         *
         * If you submit a second or subsequent `ListResolverQueryLogConfigAssociations` request and specify the `NextToken` parameter, you must use the same value for `SortOrder`, if any, as in the previous request.
         */
        public var sortOrder: aws.sdk.kotlin.services.route53resolver.model.SortOrder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest = ListResolverQueryLogConfigAssociationsRequest(this)
    }
}
