// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



public class ListFirewallRuleGroupAssociationsRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the firewall rule group that you want to retrieve the associations for. Leave this blank to retrieve associations for any rule group.
     */
    public val firewallRuleGroupId: kotlin.String? = builder.firewallRuleGroupId
    /**
     * The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a `NextToken` value that you can use in a subsequent call to get the next batch of objects.
     *
     * If you don't specify a value for `MaxResults`, Resolver returns up to 100 objects.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * For the first call to this list request, omit this value.
     *
     * When you request a list of objects, Resolver returns at most the number of objects specified in `MaxResults`. If more objects are available for retrieval, Resolver returns a `NextToken` value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * The association `Status` setting that you want DNS Firewall to filter on for the list. If you don't specify this, then DNS Firewall returns all associations, regardless of status.
     */
    public val status: aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupAssociationStatus? = builder.status
    /**
     * The unique identifier of the VPC that you want to retrieve the associations for. Leave this blank to retrieve associations for any VPC.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListFirewallRuleGroupAssociationsRequest(")
        append("firewallRuleGroupId=$firewallRuleGroupId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("priority=$priority,")
        append("status=$status,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = firewallRuleGroupId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListFirewallRuleGroupAssociationsRequest

        if (firewallRuleGroupId != other.firewallRuleGroupId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (priority != other.priority) return false
        if (status != other.status) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier of the firewall rule group that you want to retrieve the associations for. Leave this blank to retrieve associations for any rule group.
         */
        public var firewallRuleGroupId: kotlin.String? = null
        /**
         * The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a `NextToken` value that you can use in a subsequent call to get the next batch of objects.
         *
         * If you don't specify a value for `MaxResults`, Resolver returns up to 100 objects.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * For the first call to this list request, omit this value.
         *
         * When you request a list of objects, Resolver returns at most the number of objects specified in `MaxResults`. If more objects are available for retrieval, Resolver returns a `NextToken` value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting.
         */
        public var priority: kotlin.Int? = null
        /**
         * The association `Status` setting that you want DNS Firewall to filter on for the list. If you don't specify this, then DNS Firewall returns all associations, regardless of status.
         */
        public var status: aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupAssociationStatus? = null
        /**
         * The unique identifier of the VPC that you want to retrieve the associations for. Leave this blank to retrieve associations for any VPC.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest) : this() {
            this.firewallRuleGroupId = x.firewallRuleGroupId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.priority = x.priority
            this.status = x.status
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest = ListFirewallRuleGroupAssociationsRequest(this)
    }
}
