// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



/**
 * In an [UpdateResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html) request, information about an IP address to update.
 */
public class IpAddressUpdate private constructor(builder: Builder) {
    /**
     * The new IPv4 address.
     */
    public val ip: kotlin.String? = builder.ip
    /**
     * *Only when removing an IP address from a Resolver endpoint*: The ID of the IP address that you want to remove. To get this ID, use [GetResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html).
     */
    public val ipId: kotlin.String? = builder.ipId
    /**
     * The new IPv6 address.
     */
    public val ipv6: kotlin.String? = builder.ipv6
    /**
     * The ID of the subnet that includes the IP address that you want to update. To get this ID, use [GetResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html).
     */
    public val subnetId: kotlin.String? = builder.subnetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.IpAddressUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpAddressUpdate(")
        append("ip=$ip,")
        append("ipId=$ipId,")
        append("ipv6=$ipv6,")
        append("subnetId=$subnetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ip?.hashCode() ?: 0
        result = 31 * result + (ipId?.hashCode() ?: 0)
        result = 31 * result + (ipv6?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpAddressUpdate

        if (ip != other.ip) return false
        if (ipId != other.ipId) return false
        if (ipv6 != other.ipv6) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.IpAddressUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The new IPv4 address.
         */
        public var ip: kotlin.String? = null
        /**
         * *Only when removing an IP address from a Resolver endpoint*: The ID of the IP address that you want to remove. To get this ID, use [GetResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html).
         */
        public var ipId: kotlin.String? = null
        /**
         * The new IPv6 address.
         */
        public var ipv6: kotlin.String? = null
        /**
         * The ID of the subnet that includes the IP address that you want to update. To get this ID, use [GetResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html).
         */
        public var subnetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.IpAddressUpdate) : this() {
            this.ip = x.ip
            this.ipId = x.ipId
            this.ipv6 = x.ipv6
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.IpAddressUpdate = IpAddressUpdate(this)
    }
}
