// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



/**
 * In the response to a [GetResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html) request, information about the IP addresses that the Resolver endpoint uses for DNS queries.
 */
public class IpAddressResponse private constructor(builder: Builder) {
    /**
     * The date and time that the IP address was created, in Unix time format and Coordinated Universal Time (UTC).
     */
    public val creationTime: kotlin.String? = builder.creationTime
    /**
     * One IPv4 address that the Resolver endpoint uses for DNS queries.
     */
    public val ip: kotlin.String? = builder.ip
    /**
     * The ID of one IP address.
     */
    public val ipId: kotlin.String? = builder.ipId
    /**
     * One IPv6 address that the Resolver endpoint uses for DNS queries.
     */
    public val ipv6: kotlin.String? = builder.ipv6
    /**
     * The date and time that the IP address was last modified, in Unix time format and Coordinated Universal Time (UTC).
     */
    public val modificationTime: kotlin.String? = builder.modificationTime
    /**
     * A status code that gives the current status of the request.
     */
    public val status: aws.sdk.kotlin.services.route53resolver.model.IpAddressStatus? = builder.status
    /**
     * A message that provides additional information about the status of the request.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The ID of one subnet.
     */
    public val subnetId: kotlin.String? = builder.subnetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.IpAddressResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpAddressResponse(")
        append("creationTime=$creationTime,")
        append("ip=$ip,")
        append("ipId=$ipId,")
        append("ipv6=$ipv6,")
        append("modificationTime=$modificationTime,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("subnetId=$subnetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (ip?.hashCode() ?: 0)
        result = 31 * result + (ipId?.hashCode() ?: 0)
        result = 31 * result + (ipv6?.hashCode() ?: 0)
        result = 31 * result + (modificationTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpAddressResponse

        if (creationTime != other.creationTime) return false
        if (ip != other.ip) return false
        if (ipId != other.ipId) return false
        if (ipv6 != other.ipv6) return false
        if (modificationTime != other.modificationTime) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.IpAddressResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time that the IP address was created, in Unix time format and Coordinated Universal Time (UTC).
         */
        public var creationTime: kotlin.String? = null
        /**
         * One IPv4 address that the Resolver endpoint uses for DNS queries.
         */
        public var ip: kotlin.String? = null
        /**
         * The ID of one IP address.
         */
        public var ipId: kotlin.String? = null
        /**
         * One IPv6 address that the Resolver endpoint uses for DNS queries.
         */
        public var ipv6: kotlin.String? = null
        /**
         * The date and time that the IP address was last modified, in Unix time format and Coordinated Universal Time (UTC).
         */
        public var modificationTime: kotlin.String? = null
        /**
         * A status code that gives the current status of the request.
         */
        public var status: aws.sdk.kotlin.services.route53resolver.model.IpAddressStatus? = null
        /**
         * A message that provides additional information about the status of the request.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The ID of one subnet.
         */
        public var subnetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.IpAddressResponse) : this() {
            this.creationTime = x.creationTime
            this.ip = x.ip
            this.ipId = x.ipId
            this.ipv6 = x.ipv6
            this.modificationTime = x.modificationTime
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.IpAddressResponse = IpAddressResponse(this)
    }
}
