// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



public class CreateFirewallRuleRequest private constructor(builder: Builder) {
    /**
     * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:
     * + `ALLOW` - Permit the request to go through.
     * + `ALERT` - Permit the request and send metrics and logs to Cloud Watch.
     * + `BLOCK` - Disallow the request. This option requires additional details in the rule's `BlockResponse`.
     */
    public val action: aws.sdk.kotlin.services.route53resolver.model.Action? = builder.action
    /**
     * The DNS record's type. This determines the format of the record value that you provided in `BlockOverrideDomain`. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
     *
     * This setting is required if the `BlockResponse` setting is `OVERRIDE`.
     */
    public val blockOverrideDnsType: aws.sdk.kotlin.services.route53resolver.model.BlockOverrideDnsType? = builder.blockOverrideDnsType
    /**
     * The custom DNS record to send back in response to the query. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
     *
     * This setting is required if the `BlockResponse` setting is `OVERRIDE`.
     */
    public val blockOverrideDomain: kotlin.String? = builder.blockOverrideDomain
    /**
     * The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
     *
     * This setting is required if the `BlockResponse` setting is `OVERRIDE`.
     */
    public val blockOverrideTtl: kotlin.Int? = builder.blockOverrideTtl
    /**
     * The way that you want DNS Firewall to block the request, used with the rule action setting `BLOCK`.
     * + `NODATA` - Respond indicating that the query was successful, but no response is available for it.
     * + `NXDOMAIN` - Respond indicating that the domain name that's in the query doesn't exist.
     * + `OVERRIDE` - Provide a custom override in the response. This option requires custom handling details in the rule's `BlockOverride*` settings.
     *
     * This setting is required if the rule action setting is `BLOCK`.
     */
    public val blockResponse: aws.sdk.kotlin.services.route53resolver.model.BlockResponse? = builder.blockResponse
    /**
     * A unique string that identifies the request and that allows you to retry failed requests without the risk of running the operation twice. `CreatorRequestId` can be any unique string, for example, a date/time stamp.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The ID of the domain list that you want to use in the rule.
     */
    public val firewallDomainListId: kotlin.String? = builder.firewallDomainListId
    /**
     * The unique identifier of the firewall rule group where you want to create the rule.
     */
    public val firewallRuleGroupId: kotlin.String? = builder.firewallRuleGroupId
    /**
     * A name that lets you identify the rule in the rule group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
     *
     * You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time.
     */
    public val priority: kotlin.Int? = builder.priority

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.CreateFirewallRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFirewallRuleRequest(")
        append("action=$action,")
        append("blockOverrideDnsType=$blockOverrideDnsType,")
        append("blockOverrideDomain=$blockOverrideDomain,")
        append("blockOverrideTtl=$blockOverrideTtl,")
        append("blockResponse=$blockResponse,")
        append("creatorRequestId=$creatorRequestId,")
        append("firewallDomainListId=$firewallDomainListId,")
        append("firewallRuleGroupId=$firewallRuleGroupId,")
        append("name=$name,")
        append("priority=$priority")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (blockOverrideDnsType?.hashCode() ?: 0)
        result = 31 * result + (blockOverrideDomain?.hashCode() ?: 0)
        result = 31 * result + (blockOverrideTtl ?: 0)
        result = 31 * result + (blockResponse?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (firewallDomainListId?.hashCode() ?: 0)
        result = 31 * result + (firewallRuleGroupId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFirewallRuleRequest

        if (action != other.action) return false
        if (blockOverrideDnsType != other.blockOverrideDnsType) return false
        if (blockOverrideDomain != other.blockOverrideDomain) return false
        if (blockOverrideTtl != other.blockOverrideTtl) return false
        if (blockResponse != other.blockResponse) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (firewallDomainListId != other.firewallDomainListId) return false
        if (firewallRuleGroupId != other.firewallRuleGroupId) return false
        if (name != other.name) return false
        if (priority != other.priority) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.CreateFirewallRuleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:
         * + `ALLOW` - Permit the request to go through.
         * + `ALERT` - Permit the request and send metrics and logs to Cloud Watch.
         * + `BLOCK` - Disallow the request. This option requires additional details in the rule's `BlockResponse`.
         */
        public var action: aws.sdk.kotlin.services.route53resolver.model.Action? = null
        /**
         * The DNS record's type. This determines the format of the record value that you provided in `BlockOverrideDomain`. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
         *
         * This setting is required if the `BlockResponse` setting is `OVERRIDE`.
         */
        public var blockOverrideDnsType: aws.sdk.kotlin.services.route53resolver.model.BlockOverrideDnsType? = null
        /**
         * The custom DNS record to send back in response to the query. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
         *
         * This setting is required if the `BlockResponse` setting is `OVERRIDE`.
         */
        public var blockOverrideDomain: kotlin.String? = null
        /**
         * The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
         *
         * This setting is required if the `BlockResponse` setting is `OVERRIDE`.
         */
        public var blockOverrideTtl: kotlin.Int? = null
        /**
         * The way that you want DNS Firewall to block the request, used with the rule action setting `BLOCK`.
         * + `NODATA` - Respond indicating that the query was successful, but no response is available for it.
         * + `NXDOMAIN` - Respond indicating that the domain name that's in the query doesn't exist.
         * + `OVERRIDE` - Provide a custom override in the response. This option requires custom handling details in the rule's `BlockOverride*` settings.
         *
         * This setting is required if the rule action setting is `BLOCK`.
         */
        public var blockResponse: aws.sdk.kotlin.services.route53resolver.model.BlockResponse? = null
        /**
         * A unique string that identifies the request and that allows you to retry failed requests without the risk of running the operation twice. `CreatorRequestId` can be any unique string, for example, a date/time stamp.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * The ID of the domain list that you want to use in the rule.
         */
        public var firewallDomainListId: kotlin.String? = null
        /**
         * The unique identifier of the firewall rule group where you want to create the rule.
         */
        public var firewallRuleGroupId: kotlin.String? = null
        /**
         * A name that lets you identify the rule in the rule group.
         */
        public var name: kotlin.String? = null
        /**
         * The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
         *
         * You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time.
         */
        public var priority: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.CreateFirewallRuleRequest) : this() {
            this.action = x.action
            this.blockOverrideDnsType = x.blockOverrideDnsType
            this.blockOverrideDomain = x.blockOverrideDomain
            this.blockOverrideTtl = x.blockOverrideTtl
            this.blockResponse = x.blockResponse
            this.creatorRequestId = x.creatorRequestId
            this.firewallDomainListId = x.firewallDomainListId
            this.firewallRuleGroupId = x.firewallRuleGroupId
            this.name = x.name
            this.priority = x.priority
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.CreateFirewallRuleRequest = CreateFirewallRuleRequest(this)
    }
}
