// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.route53resolver.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.route53resolver.endpoints.EndpointParameters
import aws.sdk.kotlin.services.route53resolver.endpoints.EndpointProvider
import aws.sdk.kotlin.services.route53resolver.model.AssociateFirewallRuleGroupRequest
import aws.sdk.kotlin.services.route53resolver.model.AssociateFirewallRuleGroupResponse
import aws.sdk.kotlin.services.route53resolver.model.AssociateResolverEndpointIpAddressRequest
import aws.sdk.kotlin.services.route53resolver.model.AssociateResolverEndpointIpAddressResponse
import aws.sdk.kotlin.services.route53resolver.model.AssociateResolverQueryLogConfigRequest
import aws.sdk.kotlin.services.route53resolver.model.AssociateResolverQueryLogConfigResponse
import aws.sdk.kotlin.services.route53resolver.model.AssociateResolverRuleRequest
import aws.sdk.kotlin.services.route53resolver.model.AssociateResolverRuleResponse
import aws.sdk.kotlin.services.route53resolver.model.CreateFirewallDomainListRequest
import aws.sdk.kotlin.services.route53resolver.model.CreateFirewallDomainListResponse
import aws.sdk.kotlin.services.route53resolver.model.CreateFirewallRuleGroupRequest
import aws.sdk.kotlin.services.route53resolver.model.CreateFirewallRuleGroupResponse
import aws.sdk.kotlin.services.route53resolver.model.CreateFirewallRuleRequest
import aws.sdk.kotlin.services.route53resolver.model.CreateFirewallRuleResponse
import aws.sdk.kotlin.services.route53resolver.model.CreateResolverEndpointRequest
import aws.sdk.kotlin.services.route53resolver.model.CreateResolverEndpointResponse
import aws.sdk.kotlin.services.route53resolver.model.CreateResolverQueryLogConfigRequest
import aws.sdk.kotlin.services.route53resolver.model.CreateResolverQueryLogConfigResponse
import aws.sdk.kotlin.services.route53resolver.model.CreateResolverRuleRequest
import aws.sdk.kotlin.services.route53resolver.model.CreateResolverRuleResponse
import aws.sdk.kotlin.services.route53resolver.model.DeleteFirewallDomainListRequest
import aws.sdk.kotlin.services.route53resolver.model.DeleteFirewallDomainListResponse
import aws.sdk.kotlin.services.route53resolver.model.DeleteFirewallRuleGroupRequest
import aws.sdk.kotlin.services.route53resolver.model.DeleteFirewallRuleGroupResponse
import aws.sdk.kotlin.services.route53resolver.model.DeleteFirewallRuleRequest
import aws.sdk.kotlin.services.route53resolver.model.DeleteFirewallRuleResponse
import aws.sdk.kotlin.services.route53resolver.model.DeleteResolverEndpointRequest
import aws.sdk.kotlin.services.route53resolver.model.DeleteResolverEndpointResponse
import aws.sdk.kotlin.services.route53resolver.model.DeleteResolverQueryLogConfigRequest
import aws.sdk.kotlin.services.route53resolver.model.DeleteResolverQueryLogConfigResponse
import aws.sdk.kotlin.services.route53resolver.model.DeleteResolverRuleRequest
import aws.sdk.kotlin.services.route53resolver.model.DeleteResolverRuleResponse
import aws.sdk.kotlin.services.route53resolver.model.DisassociateFirewallRuleGroupRequest
import aws.sdk.kotlin.services.route53resolver.model.DisassociateFirewallRuleGroupResponse
import aws.sdk.kotlin.services.route53resolver.model.DisassociateResolverEndpointIpAddressRequest
import aws.sdk.kotlin.services.route53resolver.model.DisassociateResolverEndpointIpAddressResponse
import aws.sdk.kotlin.services.route53resolver.model.DisassociateResolverQueryLogConfigRequest
import aws.sdk.kotlin.services.route53resolver.model.DisassociateResolverQueryLogConfigResponse
import aws.sdk.kotlin.services.route53resolver.model.DisassociateResolverRuleRequest
import aws.sdk.kotlin.services.route53resolver.model.DisassociateResolverRuleResponse
import aws.sdk.kotlin.services.route53resolver.model.GetFirewallConfigRequest
import aws.sdk.kotlin.services.route53resolver.model.GetFirewallConfigResponse
import aws.sdk.kotlin.services.route53resolver.model.GetFirewallDomainListRequest
import aws.sdk.kotlin.services.route53resolver.model.GetFirewallDomainListResponse
import aws.sdk.kotlin.services.route53resolver.model.GetFirewallRuleGroupAssociationRequest
import aws.sdk.kotlin.services.route53resolver.model.GetFirewallRuleGroupAssociationResponse
import aws.sdk.kotlin.services.route53resolver.model.GetFirewallRuleGroupPolicyRequest
import aws.sdk.kotlin.services.route53resolver.model.GetFirewallRuleGroupPolicyResponse
import aws.sdk.kotlin.services.route53resolver.model.GetFirewallRuleGroupRequest
import aws.sdk.kotlin.services.route53resolver.model.GetFirewallRuleGroupResponse
import aws.sdk.kotlin.services.route53resolver.model.GetResolverConfigRequest
import aws.sdk.kotlin.services.route53resolver.model.GetResolverConfigResponse
import aws.sdk.kotlin.services.route53resolver.model.GetResolverDnssecConfigRequest
import aws.sdk.kotlin.services.route53resolver.model.GetResolverDnssecConfigResponse
import aws.sdk.kotlin.services.route53resolver.model.GetResolverEndpointRequest
import aws.sdk.kotlin.services.route53resolver.model.GetResolverEndpointResponse
import aws.sdk.kotlin.services.route53resolver.model.GetResolverQueryLogConfigAssociationRequest
import aws.sdk.kotlin.services.route53resolver.model.GetResolverQueryLogConfigAssociationResponse
import aws.sdk.kotlin.services.route53resolver.model.GetResolverQueryLogConfigPolicyRequest
import aws.sdk.kotlin.services.route53resolver.model.GetResolverQueryLogConfigPolicyResponse
import aws.sdk.kotlin.services.route53resolver.model.GetResolverQueryLogConfigRequest
import aws.sdk.kotlin.services.route53resolver.model.GetResolverQueryLogConfigResponse
import aws.sdk.kotlin.services.route53resolver.model.GetResolverRuleAssociationRequest
import aws.sdk.kotlin.services.route53resolver.model.GetResolverRuleAssociationResponse
import aws.sdk.kotlin.services.route53resolver.model.GetResolverRulePolicyRequest
import aws.sdk.kotlin.services.route53resolver.model.GetResolverRulePolicyResponse
import aws.sdk.kotlin.services.route53resolver.model.GetResolverRuleRequest
import aws.sdk.kotlin.services.route53resolver.model.GetResolverRuleResponse
import aws.sdk.kotlin.services.route53resolver.model.ImportFirewallDomainsRequest
import aws.sdk.kotlin.services.route53resolver.model.ImportFirewallDomainsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallConfigsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallConfigsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallDomainListsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallDomainListsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallDomainsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallDomainsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRulesRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRulesResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverConfigsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverConfigsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverDnssecConfigsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverDnssecConfigsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverEndpointIpAddressesRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverEndpointIpAddressesResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverEndpointsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverEndpointsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverRuleAssociationsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverRuleAssociationsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesResponse
import aws.sdk.kotlin.services.route53resolver.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.route53resolver.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.route53resolver.model.PutFirewallRuleGroupPolicyRequest
import aws.sdk.kotlin.services.route53resolver.model.PutFirewallRuleGroupPolicyResponse
import aws.sdk.kotlin.services.route53resolver.model.PutResolverQueryLogConfigPolicyRequest
import aws.sdk.kotlin.services.route53resolver.model.PutResolverQueryLogConfigPolicyResponse
import aws.sdk.kotlin.services.route53resolver.model.PutResolverRulePolicyRequest
import aws.sdk.kotlin.services.route53resolver.model.PutResolverRulePolicyResponse
import aws.sdk.kotlin.services.route53resolver.model.TagResourceRequest
import aws.sdk.kotlin.services.route53resolver.model.TagResourceResponse
import aws.sdk.kotlin.services.route53resolver.model.UntagResourceRequest
import aws.sdk.kotlin.services.route53resolver.model.UntagResourceResponse
import aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallConfigRequest
import aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallConfigResponse
import aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallDomainsRequest
import aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallDomainsResponse
import aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest
import aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse
import aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallRuleRequest
import aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallRuleResponse
import aws.sdk.kotlin.services.route53resolver.model.UpdateResolverConfigRequest
import aws.sdk.kotlin.services.route53resolver.model.UpdateResolverConfigResponse
import aws.sdk.kotlin.services.route53resolver.model.UpdateResolverDnssecConfigRequest
import aws.sdk.kotlin.services.route53resolver.model.UpdateResolverDnssecConfigResponse
import aws.sdk.kotlin.services.route53resolver.model.UpdateResolverEndpointRequest
import aws.sdk.kotlin.services.route53resolver.model.UpdateResolverEndpointResponse
import aws.sdk.kotlin.services.route53resolver.model.UpdateResolverRuleRequest
import aws.sdk.kotlin.services.route53resolver.model.UpdateResolverRuleResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * When you create a VPC using Amazon VPC, you automatically get DNS resolution within the VPC from Route 53 Resolver. By default, Resolver answers DNS queries for VPC domain names such as domain names for EC2 instances or Elastic Load Balancing load balancers. Resolver performs recursive lookups against public name servers for all other domain names.
 *
 * You can also configure DNS resolution between your VPC and your network over a Direct Connect or VPN connection:
 *
 * **Forward DNS queries from resolvers on your network to Route 53 Resolver**
 *
 * DNS resolvers on your network can forward DNS queries to Resolver in a specified VPC. This allows your DNS resolvers to easily resolve domain names for Amazon Web Services resources such as EC2 instances or records in a Route 53 private hosted zone. For more information, see [How DNS Resolvers on Your Network Forward DNS Queries to Route 53 Resolver](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resolver.html#resolver-overview-forward-network-to-vpc) in the *Amazon Route 53 Developer Guide*.
 *
 * **Conditionally forward queries from a VPC to resolvers on your network**
 *
 * You can configure Resolver to forward queries that it receives from EC2 instances in your VPCs to DNS resolvers on your network. To forward selected queries, you create Resolver rules that specify the domain names for the DNS queries that you want to forward (such as example.com), and the IP addresses of the DNS resolvers on your network that you want to forward the queries to. If a query matches multiple rules (example.com, acme.example.com), Resolver chooses the rule with the most specific match (acme.example.com) and forwards the query to the IP addresses that you specified in that rule. For more information, see [How Route 53 Resolver Forwards DNS Queries from Your VPCs to Your Network](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resolver.html#resolver-overview-forward-vpc-to-network) in the *Amazon Route 53 Developer Guide*.
 *
 * Like Amazon VPC, Resolver is Regional. In each Region where you have VPCs, you can choose whether to forward queries from your VPCs to your network (outbound queries), from your network to your VPCs (inbound queries), or both.
 */
public interface Route53ResolverClient : SdkClient {
    /**
     * Route53ResolverClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, Route53ResolverClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, Route53ResolverClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): Route53ResolverClient = DefaultRoute53ResolverClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val clientName: String = builder.clientName
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, clientName)
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, IdempotencyTokenConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Route53Resolver"

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a FirewallRuleGroup with a VPC, to provide DNS filtering for the VPC.
     */
    public suspend fun associateFirewallRuleGroup(input: AssociateFirewallRuleGroupRequest): AssociateFirewallRuleGroupResponse

    /**
     * Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address, submit one `AssociateResolverEndpointIpAddress` request for each IP address.
     *
     * To remove an IP address from an endpoint, see [DisassociateResolverEndpointIpAddress](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html).
     */
    public suspend fun associateResolverEndpointIpAddress(input: AssociateResolverEndpointIpAddressRequest): AssociateResolverEndpointIpAddressResponse

    /**
     * Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To associate more than one VPC with a configuration, submit one `AssociateResolverQueryLogConfig` request for each VPC.
     *
     * The VPCs that you associate with a query logging configuration must be in the same Region as the configuration.
     *
     * To remove a VPC from a query logging configuration, see [DisassociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
     */
    public suspend fun associateResolverQueryLogConfig(input: AssociateResolverQueryLogConfigRequest): AssociateResolverQueryLogConfigResponse

    /**
     * Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see [CreateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html).
     */
    public suspend fun associateResolverRule(input: AssociateResolverRuleRequest): AssociateResolverRuleResponse

    /**
     * Creates an empty firewall domain list for use in DNS Firewall rules. You can populate the domains for the new list with a file, using ImportFirewallDomains, or with domain strings, using UpdateFirewallDomains.
     */
    public suspend fun createFirewallDomainList(input: CreateFirewallDomainListRequest): CreateFirewallDomainListResponse

    /**
     * Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.
     */
    public suspend fun createFirewallRule(input: CreateFirewallRuleRequest): CreateFirewallRuleResponse

    /**
     * Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You can add rules to the new rule group by calling CreateFirewallRule.
     */
    public suspend fun createFirewallRuleGroup(input: CreateFirewallRuleGroupRequest): CreateFirewallRuleGroupResponse

    /**
     * Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:
     * + An *inbound Resolver endpoint* forwards DNS queries to the DNS service for a VPC from your network.
     * + An *outbound Resolver endpoint* forwards DNS queries from the DNS service for a VPC to your network.
     */
    public suspend fun createResolverEndpoint(input: CreateResolverEndpointRequest): CreateResolverEndpointResponse

    /**
     * Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that originate in your VPCs. Resolver can log queries only for VPCs that are in the same Region as the query logging configuration.
     *
     * To specify which VPCs you want to log queries for, you use `AssociateResolverQueryLogConfig`. For more information, see [AssociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html).
     *
     * You can optionally use Resource Access Manager (RAM) to share a query logging configuration with other Amazon Web Services accounts. The other accounts can then associate VPCs with the configuration. The query logs that Resolver creates for a configuration include all DNS queries that originate in all VPCs that are associated with the configuration.
     */
    public suspend fun createResolverQueryLogConfig(input: CreateResolverQueryLogConfigRequest): CreateResolverQueryLogConfigResponse

    /**
     * For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.
     */
    public suspend fun createResolverRule(input: CreateResolverRuleRequest): CreateResolverRuleResponse

    /**
     * Deletes the specified domain list.
     */
    public suspend fun deleteFirewallDomainList(input: DeleteFirewallDomainListRequest): DeleteFirewallDomainListResponse

    /**
     * Deletes the specified firewall rule.
     */
    public suspend fun deleteFirewallRule(input: DeleteFirewallRuleRequest): DeleteFirewallRuleResponse

    /**
     * Deletes the specified firewall rule group.
     */
    public suspend fun deleteFirewallRuleGroup(input: DeleteFirewallRuleGroupRequest): DeleteFirewallRuleGroupResponse

    /**
     * Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it's an inbound or an outbound Resolver endpoint:
     * + **Inbound**: DNS queries from your network are no longer routed to the DNS service for the specified VPC.
     * + **Outbound**: DNS queries from a VPC are no longer routed to your network.
     */
    public suspend fun deleteResolverEndpoint(input: DeleteResolverEndpointRequest): DeleteResolverEndpointResponse

    /**
     * Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for all of the Amazon VPCs that are associated with the configuration. This also applies if the query logging configuration is shared with other Amazon Web Services accounts, and the other accounts have associated VPCs with the shared configuration.
     *
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. See [DisassociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
     *
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, you must stop sharing the configuration before you can delete a configuration. The accounts that you shared the configuration with can first disassociate VPCs that they associated with the configuration, but that's not necessary. If you stop sharing the configuration, those VPCs are automatically disassociated from the configuration.
     */
    public suspend fun deleteResolverQueryLogConfig(input: DeleteResolverQueryLogConfigRequest): DeleteResolverQueryLogConfigResponse

    /**
     * Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that you associated the Resolver rule with. For more information, see [DisassociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html).
     */
    public suspend fun deleteResolverRule(input: DeleteResolverRuleRequest): DeleteResolverRuleResponse

    /**
     * Disassociates a FirewallRuleGroup from a VPC, to remove DNS filtering from the VPC.
     */
    public suspend fun disassociateFirewallRuleGroup(input: DisassociateFirewallRuleGroupRequest): DisassociateFirewallRuleGroupResponse

    /**
     * Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP address, submit one `DisassociateResolverEndpointIpAddress` request for each IP address.
     *
     * To add an IP address to an endpoint, see [AssociateResolverEndpointIpAddress](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html).
     */
    public suspend fun disassociateResolverEndpointIpAddress(input: DisassociateResolverEndpointIpAddressRequest): DisassociateResolverEndpointIpAddressResponse

    /**
     * Disassociates a VPC from a query logging configuration.
     *
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, VPCs can be disassociated from the configuration in the following ways:
     * + The accounts that you shared the configuration with can disassociate VPCs from the configuration.
     * + You can stop sharing the configuration.
     */
    public suspend fun disassociateResolverQueryLogConfig(input: DisassociateResolverQueryLogConfigRequest): DisassociateResolverQueryLogConfigResponse

    /**
     * Removes the association between a specified Resolver rule and a specified VPC.
     *
     * If you disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the domain name that you specified in the Resolver rule.
     */
    public suspend fun disassociateResolverRule(input: DisassociateResolverRuleRequest): DisassociateResolverRuleResponse

    /**
     * Retrieves the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
     */
    public suspend fun getFirewallConfig(input: GetFirewallConfigRequest): GetFirewallConfigResponse

    /**
     * Retrieves the specified firewall domain list.
     */
    public suspend fun getFirewallDomainList(input: GetFirewallDomainListRequest): GetFirewallDomainListResponse

    /**
     * Retrieves the specified firewall rule group.
     */
    public suspend fun getFirewallRuleGroup(input: GetFirewallRuleGroupRequest): GetFirewallRuleGroupResponse

    /**
     * Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one rule group. A VPC can have more than one firewall rule group association, and a rule group can be associated with more than one VPC.
     */
    public suspend fun getFirewallRuleGroupAssociation(input: GetFirewallRuleGroupAssociationRequest): GetFirewallRuleGroupAssociationResponse

    /**
     * Returns the Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule group. You can use the policy to share the rule group using Resource Access Manager (RAM).
     */
    public suspend fun getFirewallRuleGroupPolicy(input: GetFirewallRuleGroupPolicyRequest): GetFirewallRuleGroupPolicyResponse

    /**
     * Retrieves the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.
     */
    public suspend fun getResolverConfig(input: GetResolverConfigRequest): GetResolverConfigResponse

    /**
     * Gets DNSSEC validation information for a specified resource.
     */
    public suspend fun getResolverDnssecConfig(input: GetResolverDnssecConfigRequest): GetResolverDnssecConfigResponse

    /**
     * Gets information about a specified Resolver endpoint, such as whether it's an inbound or an outbound Resolver endpoint, and the current status of the endpoint.
     */
    public suspend fun getResolverEndpoint(input: GetResolverEndpointRequest): GetResolverEndpointResponse

    /**
     * Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the configuration is logging queries for and the location that logs are sent to.
     */
    public suspend fun getResolverQueryLogConfig(input: GetResolverQueryLogConfigRequest): GetResolverQueryLogConfigResponse

    /**
     * Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC. When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that VPC.
     */
    public suspend fun getResolverQueryLogConfigAssociation(input: GetResolverQueryLogConfigAssociationRequest): GetResolverQueryLogConfigAssociationResponse

    /**
     * Gets information about a query logging policy. A query logging policy specifies the Resolver query logging operations and resources that you want to allow another Amazon Web Services account to be able to use.
     */
    public suspend fun getResolverQueryLogConfigPolicy(input: GetResolverQueryLogConfigPolicyRequest): GetResolverQueryLogConfigPolicyResponse

    /**
     * Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for and the ID of the outbound Resolver endpoint that the rule is associated with.
     */
    public suspend fun getResolverRule(input: GetResolverRuleRequest): GetResolverRuleResponse

    /**
     * Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule and a VPC using [AssociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html).
     */
    public suspend fun getResolverRuleAssociation(input: GetResolverRuleAssociationRequest): GetResolverRuleAssociationResponse

    /**
     * Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule that you want to share with another account, the account that you want to share the rule with, and the Resolver operations that you want to allow the account to use.
     */
    public suspend fun getResolverRulePolicy(input: GetResolverRulePolicyRequest): GetResolverRulePolicyResponse

    /**
     * Imports domain names from a file into a domain list, for use in a DNS firewall rule group.
     *
     * Each domain specification in your domain list must satisfy the following requirements:
     * + It can optionally start with `*` (asterisk).
     * + With the exception of the optional starting asterisk, it must only contain the following characters: `A-Z`, `a-z`, `0-9`, `-` (hyphen).
     * + It must be from 1-255 characters in length.
     */
    public suspend fun importFirewallDomains(input: ImportFirewallDomainsRequest): ImportFirewallDomainsResponse

    /**
     * Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage firewall behavior for your VPCs.
     *
     * A single call might return only a partial list of the configurations. For information, see `MaxResults`.
     */
    public suspend fun listFirewallConfigs(input: ListFirewallConfigsRequest = ListFirewallConfigsRequest {}): ListFirewallConfigsResponse

    /**
     * Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the domains that are defined for a list by calling ListFirewallDomains.
     *
     * A single call to this list operation might return only a partial list of the domain lists. For information, see `MaxResults`.
     */
    public suspend fun listFirewallDomainLists(input: ListFirewallDomainListsRequest = ListFirewallDomainListsRequest {}): ListFirewallDomainListsResponse

    /**
     * Retrieves the domains that you have defined for the specified firewall domain list.
     *
     * A single call might return only a partial list of the domains. For information, see `MaxResults`.
     */
    public suspend fun listFirewallDomains(input: ListFirewallDomainsRequest): ListFirewallDomainsResponse

    /**
     * Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for a VPC with one rule group.
     *
     * A single call might return only a partial list of the associations. For information, see `MaxResults`.
     */
    public suspend fun listFirewallRuleGroupAssociations(input: ListFirewallRuleGroupAssociationsRequest = ListFirewallRuleGroupAssociationsRequest {}): ListFirewallRuleGroupAssociationsResponse

    /**
     * Retrieves the minimal high-level information for the rule groups that you have defined.
     *
     * A single call might return only a partial list of the rule groups. For information, see `MaxResults`.
     */
    public suspend fun listFirewallRuleGroups(input: ListFirewallRuleGroupsRequest = ListFirewallRuleGroupsRequest {}): ListFirewallRuleGroupsResponse

    /**
     * Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the rules in a rule group to filter DNS network traffic for a VPC.
     *
     * A single call might return only a partial list of the rules. For information, see `MaxResults`.
     */
    public suspend fun listFirewallRules(input: ListFirewallRulesRequest): ListFirewallRulesResponse

    /**
     * Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the configurations to manage DNS resolution behavior for your VPCs.
     */
    public suspend fun listResolverConfigs(input: ListResolverConfigsRequest = ListResolverConfigsRequest {}): ListResolverConfigsResponse

    /**
     * Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.
     */
    public suspend fun listResolverDnssecConfigs(input: ListResolverDnssecConfigsRequest = ListResolverDnssecConfigsRequest {}): ListResolverDnssecConfigsResponse

    /**
     * Gets the IP addresses for a specified Resolver endpoint.
     */
    public suspend fun listResolverEndpointIpAddresses(input: ListResolverEndpointIpAddressesRequest): ListResolverEndpointIpAddressesResponse

    /**
     * Lists all the Resolver endpoints that were created using the current Amazon Web Services account.
     */
    public suspend fun listResolverEndpoints(input: ListResolverEndpointsRequest = ListResolverEndpointsRequest {}): ListResolverEndpointsResponse

    /**
     * Lists information about associations between Amazon VPCs and query logging configurations.
     */
    public suspend fun listResolverQueryLogConfigAssociations(input: ListResolverQueryLogConfigAssociationsRequest = ListResolverQueryLogConfigAssociationsRequest {}): ListResolverQueryLogConfigAssociationsResponse

    /**
     * Lists information about the specified query logging configurations. Each configuration defines where you want Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
     */
    public suspend fun listResolverQueryLogConfigs(input: ListResolverQueryLogConfigsRequest = ListResolverQueryLogConfigsRequest {}): ListResolverQueryLogConfigsResponse

    /**
     * Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services account.
     */
    public suspend fun listResolverRuleAssociations(input: ListResolverRuleAssociationsRequest = ListResolverRuleAssociationsRequest {}): ListResolverRuleAssociationsResponse

    /**
     * Lists the Resolver rules that were created using the current Amazon Web Services account.
     */
    public suspend fun listResolverRules(input: ListResolverRulesRequest = ListResolverRulesRequest {}): ListResolverRulesResponse

    /**
     * Lists the tags that you associated with the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Attaches an Identity and Access Management (Amazon Web Services IAM) policy for sharing the rule group. You can use the policy to share the rule group using Resource Access Manager (RAM).
     */
    public suspend fun putFirewallRuleGroupPolicy(input: PutFirewallRuleGroupPolicyRequest): PutFirewallRuleGroupPolicyResponse

    /**
     * Specifies an Amazon Web Services account that you want to share a query logging configuration with, the query logging configuration that you want to share, and the operations that you want the account to be able to perform on the configuration.
     */
    public suspend fun putResolverQueryLogConfigPolicy(input: PutResolverQueryLogConfigPolicyRequest): PutResolverQueryLogConfigPolicyResponse

    /**
     * Specifies an Amazon Web Services rule that you want to share with another account, the account that you want to share the rule with, and the operations that you want the account to be able to perform on the rule.
     */
    public suspend fun putResolverRulePolicy(input: PutResolverRulePolicyRequest): PutResolverRulePolicyResponse

    /**
     * Adds one or more tags to a specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from a specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
     */
    public suspend fun updateFirewallConfig(input: UpdateFirewallConfigRequest): UpdateFirewallConfigResponse

    /**
     * Updates the firewall domain list from an array of domain specifications.
     */
    public suspend fun updateFirewallDomains(input: UpdateFirewallDomainsRequest): UpdateFirewallDomainsResponse

    /**
     * Updates the specified firewall rule.
     */
    public suspend fun updateFirewallRule(input: UpdateFirewallRuleRequest): UpdateFirewallRuleResponse

    /**
     * Changes the association of a FirewallRuleGroup with a VPC. The association enables DNS filtering for the VPC.
     */
    public suspend fun updateFirewallRuleGroupAssociation(input: UpdateFirewallRuleGroupAssociationRequest): UpdateFirewallRuleGroupAssociationResponse

    /**
     * Updates the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.
     */
    public suspend fun updateResolverConfig(input: UpdateResolverConfigRequest): UpdateResolverConfigResponse

    /**
     * Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one is created.
     */
    public suspend fun updateResolverDnssecConfig(input: UpdateResolverDnssecConfigRequest): UpdateResolverDnssecConfigResponse

    /**
     * Updates the name, or enpoint type for an inbound or an outbound Resolver endpoint. You can only update between IPV4 and DUALSTACK, IPV6 endpoint type can't be updated to other type.
     */
    public suspend fun updateResolverEndpoint(input: UpdateResolverEndpointRequest): UpdateResolverEndpointResponse

    /**
     * Updates settings for a specified Resolver rule. `ResolverRuleId` is required, and all other parameters are optional. If you don't specify a parameter, it retains its current value.
     */
    public suspend fun updateResolverRule(input: UpdateResolverRuleRequest): UpdateResolverRuleResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun Route53ResolverClient.withConfig(block: Route53ResolverClient.Config.Builder.() -> Unit): Route53ResolverClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultRoute53ResolverClient(newConfig)
}

/**
 * Associates a FirewallRuleGroup with a VPC, to provide DNS filtering for the VPC.
 */
public suspend inline fun Route53ResolverClient.associateFirewallRuleGroup(crossinline block: AssociateFirewallRuleGroupRequest.Builder.() -> Unit): AssociateFirewallRuleGroupResponse = associateFirewallRuleGroup(AssociateFirewallRuleGroupRequest.Builder().apply(block).build())

/**
 * Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address, submit one `AssociateResolverEndpointIpAddress` request for each IP address.
 *
 * To remove an IP address from an endpoint, see [DisassociateResolverEndpointIpAddress](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html).
 */
public suspend inline fun Route53ResolverClient.associateResolverEndpointIpAddress(crossinline block: AssociateResolverEndpointIpAddressRequest.Builder.() -> Unit): AssociateResolverEndpointIpAddressResponse = associateResolverEndpointIpAddress(AssociateResolverEndpointIpAddressRequest.Builder().apply(block).build())

/**
 * Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To associate more than one VPC with a configuration, submit one `AssociateResolverQueryLogConfig` request for each VPC.
 *
 * The VPCs that you associate with a query logging configuration must be in the same Region as the configuration.
 *
 * To remove a VPC from a query logging configuration, see [DisassociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
 */
public suspend inline fun Route53ResolverClient.associateResolverQueryLogConfig(crossinline block: AssociateResolverQueryLogConfigRequest.Builder.() -> Unit): AssociateResolverQueryLogConfigResponse = associateResolverQueryLogConfig(AssociateResolverQueryLogConfigRequest.Builder().apply(block).build())

/**
 * Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see [CreateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html).
 */
public suspend inline fun Route53ResolverClient.associateResolverRule(crossinline block: AssociateResolverRuleRequest.Builder.() -> Unit): AssociateResolverRuleResponse = associateResolverRule(AssociateResolverRuleRequest.Builder().apply(block).build())

/**
 * Creates an empty firewall domain list for use in DNS Firewall rules. You can populate the domains for the new list with a file, using ImportFirewallDomains, or with domain strings, using UpdateFirewallDomains.
 */
public suspend inline fun Route53ResolverClient.createFirewallDomainList(crossinline block: CreateFirewallDomainListRequest.Builder.() -> Unit): CreateFirewallDomainListResponse = createFirewallDomainList(CreateFirewallDomainListRequest.Builder().apply(block).build())

/**
 * Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.
 */
public suspend inline fun Route53ResolverClient.createFirewallRule(crossinline block: CreateFirewallRuleRequest.Builder.() -> Unit): CreateFirewallRuleResponse = createFirewallRule(CreateFirewallRuleRequest.Builder().apply(block).build())

/**
 * Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You can add rules to the new rule group by calling CreateFirewallRule.
 */
public suspend inline fun Route53ResolverClient.createFirewallRuleGroup(crossinline block: CreateFirewallRuleGroupRequest.Builder.() -> Unit): CreateFirewallRuleGroupResponse = createFirewallRuleGroup(CreateFirewallRuleGroupRequest.Builder().apply(block).build())

/**
 * Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:
 * + An *inbound Resolver endpoint* forwards DNS queries to the DNS service for a VPC from your network.
 * + An *outbound Resolver endpoint* forwards DNS queries from the DNS service for a VPC to your network.
 */
public suspend inline fun Route53ResolverClient.createResolverEndpoint(crossinline block: CreateResolverEndpointRequest.Builder.() -> Unit): CreateResolverEndpointResponse = createResolverEndpoint(CreateResolverEndpointRequest.Builder().apply(block).build())

/**
 * Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that originate in your VPCs. Resolver can log queries only for VPCs that are in the same Region as the query logging configuration.
 *
 * To specify which VPCs you want to log queries for, you use `AssociateResolverQueryLogConfig`. For more information, see [AssociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html).
 *
 * You can optionally use Resource Access Manager (RAM) to share a query logging configuration with other Amazon Web Services accounts. The other accounts can then associate VPCs with the configuration. The query logs that Resolver creates for a configuration include all DNS queries that originate in all VPCs that are associated with the configuration.
 */
public suspend inline fun Route53ResolverClient.createResolverQueryLogConfig(crossinline block: CreateResolverQueryLogConfigRequest.Builder.() -> Unit): CreateResolverQueryLogConfigResponse = createResolverQueryLogConfig(CreateResolverQueryLogConfigRequest.Builder().apply(block).build())

/**
 * For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.
 */
public suspend inline fun Route53ResolverClient.createResolverRule(crossinline block: CreateResolverRuleRequest.Builder.() -> Unit): CreateResolverRuleResponse = createResolverRule(CreateResolverRuleRequest.Builder().apply(block).build())

/**
 * Deletes the specified domain list.
 */
public suspend inline fun Route53ResolverClient.deleteFirewallDomainList(crossinline block: DeleteFirewallDomainListRequest.Builder.() -> Unit): DeleteFirewallDomainListResponse = deleteFirewallDomainList(DeleteFirewallDomainListRequest.Builder().apply(block).build())

/**
 * Deletes the specified firewall rule.
 */
public suspend inline fun Route53ResolverClient.deleteFirewallRule(crossinline block: DeleteFirewallRuleRequest.Builder.() -> Unit): DeleteFirewallRuleResponse = deleteFirewallRule(DeleteFirewallRuleRequest.Builder().apply(block).build())

/**
 * Deletes the specified firewall rule group.
 */
public suspend inline fun Route53ResolverClient.deleteFirewallRuleGroup(crossinline block: DeleteFirewallRuleGroupRequest.Builder.() -> Unit): DeleteFirewallRuleGroupResponse = deleteFirewallRuleGroup(DeleteFirewallRuleGroupRequest.Builder().apply(block).build())

/**
 * Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it's an inbound or an outbound Resolver endpoint:
 * + **Inbound**: DNS queries from your network are no longer routed to the DNS service for the specified VPC.
 * + **Outbound**: DNS queries from a VPC are no longer routed to your network.
 */
public suspend inline fun Route53ResolverClient.deleteResolverEndpoint(crossinline block: DeleteResolverEndpointRequest.Builder.() -> Unit): DeleteResolverEndpointResponse = deleteResolverEndpoint(DeleteResolverEndpointRequest.Builder().apply(block).build())

/**
 * Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for all of the Amazon VPCs that are associated with the configuration. This also applies if the query logging configuration is shared with other Amazon Web Services accounts, and the other accounts have associated VPCs with the shared configuration.
 *
 * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. See [DisassociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
 *
 * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, you must stop sharing the configuration before you can delete a configuration. The accounts that you shared the configuration with can first disassociate VPCs that they associated with the configuration, but that's not necessary. If you stop sharing the configuration, those VPCs are automatically disassociated from the configuration.
 */
public suspend inline fun Route53ResolverClient.deleteResolverQueryLogConfig(crossinline block: DeleteResolverQueryLogConfigRequest.Builder.() -> Unit): DeleteResolverQueryLogConfigResponse = deleteResolverQueryLogConfig(DeleteResolverQueryLogConfigRequest.Builder().apply(block).build())

/**
 * Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that you associated the Resolver rule with. For more information, see [DisassociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html).
 */
public suspend inline fun Route53ResolverClient.deleteResolverRule(crossinline block: DeleteResolverRuleRequest.Builder.() -> Unit): DeleteResolverRuleResponse = deleteResolverRule(DeleteResolverRuleRequest.Builder().apply(block).build())

/**
 * Disassociates a FirewallRuleGroup from a VPC, to remove DNS filtering from the VPC.
 */
public suspend inline fun Route53ResolverClient.disassociateFirewallRuleGroup(crossinline block: DisassociateFirewallRuleGroupRequest.Builder.() -> Unit): DisassociateFirewallRuleGroupResponse = disassociateFirewallRuleGroup(DisassociateFirewallRuleGroupRequest.Builder().apply(block).build())

/**
 * Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP address, submit one `DisassociateResolverEndpointIpAddress` request for each IP address.
 *
 * To add an IP address to an endpoint, see [AssociateResolverEndpointIpAddress](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html).
 */
public suspend inline fun Route53ResolverClient.disassociateResolverEndpointIpAddress(crossinline block: DisassociateResolverEndpointIpAddressRequest.Builder.() -> Unit): DisassociateResolverEndpointIpAddressResponse = disassociateResolverEndpointIpAddress(DisassociateResolverEndpointIpAddressRequest.Builder().apply(block).build())

/**
 * Disassociates a VPC from a query logging configuration.
 *
 * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, VPCs can be disassociated from the configuration in the following ways:
 * + The accounts that you shared the configuration with can disassociate VPCs from the configuration.
 * + You can stop sharing the configuration.
 */
public suspend inline fun Route53ResolverClient.disassociateResolverQueryLogConfig(crossinline block: DisassociateResolverQueryLogConfigRequest.Builder.() -> Unit): DisassociateResolverQueryLogConfigResponse = disassociateResolverQueryLogConfig(DisassociateResolverQueryLogConfigRequest.Builder().apply(block).build())

/**
 * Removes the association between a specified Resolver rule and a specified VPC.
 *
 * If you disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the domain name that you specified in the Resolver rule.
 */
public suspend inline fun Route53ResolverClient.disassociateResolverRule(crossinline block: DisassociateResolverRuleRequest.Builder.() -> Unit): DisassociateResolverRuleResponse = disassociateResolverRule(DisassociateResolverRuleRequest.Builder().apply(block).build())

/**
 * Retrieves the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
 */
public suspend inline fun Route53ResolverClient.getFirewallConfig(crossinline block: GetFirewallConfigRequest.Builder.() -> Unit): GetFirewallConfigResponse = getFirewallConfig(GetFirewallConfigRequest.Builder().apply(block).build())

/**
 * Retrieves the specified firewall domain list.
 */
public suspend inline fun Route53ResolverClient.getFirewallDomainList(crossinline block: GetFirewallDomainListRequest.Builder.() -> Unit): GetFirewallDomainListResponse = getFirewallDomainList(GetFirewallDomainListRequest.Builder().apply(block).build())

/**
 * Retrieves the specified firewall rule group.
 */
public suspend inline fun Route53ResolverClient.getFirewallRuleGroup(crossinline block: GetFirewallRuleGroupRequest.Builder.() -> Unit): GetFirewallRuleGroupResponse = getFirewallRuleGroup(GetFirewallRuleGroupRequest.Builder().apply(block).build())

/**
 * Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one rule group. A VPC can have more than one firewall rule group association, and a rule group can be associated with more than one VPC.
 */
public suspend inline fun Route53ResolverClient.getFirewallRuleGroupAssociation(crossinline block: GetFirewallRuleGroupAssociationRequest.Builder.() -> Unit): GetFirewallRuleGroupAssociationResponse = getFirewallRuleGroupAssociation(GetFirewallRuleGroupAssociationRequest.Builder().apply(block).build())

/**
 * Returns the Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule group. You can use the policy to share the rule group using Resource Access Manager (RAM).
 */
public suspend inline fun Route53ResolverClient.getFirewallRuleGroupPolicy(crossinline block: GetFirewallRuleGroupPolicyRequest.Builder.() -> Unit): GetFirewallRuleGroupPolicyResponse = getFirewallRuleGroupPolicy(GetFirewallRuleGroupPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.
 */
public suspend inline fun Route53ResolverClient.getResolverConfig(crossinline block: GetResolverConfigRequest.Builder.() -> Unit): GetResolverConfigResponse = getResolverConfig(GetResolverConfigRequest.Builder().apply(block).build())

/**
 * Gets DNSSEC validation information for a specified resource.
 */
public suspend inline fun Route53ResolverClient.getResolverDnssecConfig(crossinline block: GetResolverDnssecConfigRequest.Builder.() -> Unit): GetResolverDnssecConfigResponse = getResolverDnssecConfig(GetResolverDnssecConfigRequest.Builder().apply(block).build())

/**
 * Gets information about a specified Resolver endpoint, such as whether it's an inbound or an outbound Resolver endpoint, and the current status of the endpoint.
 */
public suspend inline fun Route53ResolverClient.getResolverEndpoint(crossinline block: GetResolverEndpointRequest.Builder.() -> Unit): GetResolverEndpointResponse = getResolverEndpoint(GetResolverEndpointRequest.Builder().apply(block).build())

/**
 * Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the configuration is logging queries for and the location that logs are sent to.
 */
public suspend inline fun Route53ResolverClient.getResolverQueryLogConfig(crossinline block: GetResolverQueryLogConfigRequest.Builder.() -> Unit): GetResolverQueryLogConfigResponse = getResolverQueryLogConfig(GetResolverQueryLogConfigRequest.Builder().apply(block).build())

/**
 * Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC. When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that VPC.
 */
public suspend inline fun Route53ResolverClient.getResolverQueryLogConfigAssociation(crossinline block: GetResolverQueryLogConfigAssociationRequest.Builder.() -> Unit): GetResolverQueryLogConfigAssociationResponse = getResolverQueryLogConfigAssociation(GetResolverQueryLogConfigAssociationRequest.Builder().apply(block).build())

/**
 * Gets information about a query logging policy. A query logging policy specifies the Resolver query logging operations and resources that you want to allow another Amazon Web Services account to be able to use.
 */
public suspend inline fun Route53ResolverClient.getResolverQueryLogConfigPolicy(crossinline block: GetResolverQueryLogConfigPolicyRequest.Builder.() -> Unit): GetResolverQueryLogConfigPolicyResponse = getResolverQueryLogConfigPolicy(GetResolverQueryLogConfigPolicyRequest.Builder().apply(block).build())

/**
 * Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for and the ID of the outbound Resolver endpoint that the rule is associated with.
 */
public suspend inline fun Route53ResolverClient.getResolverRule(crossinline block: GetResolverRuleRequest.Builder.() -> Unit): GetResolverRuleResponse = getResolverRule(GetResolverRuleRequest.Builder().apply(block).build())

/**
 * Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule and a VPC using [AssociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html).
 */
public suspend inline fun Route53ResolverClient.getResolverRuleAssociation(crossinline block: GetResolverRuleAssociationRequest.Builder.() -> Unit): GetResolverRuleAssociationResponse = getResolverRuleAssociation(GetResolverRuleAssociationRequest.Builder().apply(block).build())

/**
 * Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule that you want to share with another account, the account that you want to share the rule with, and the Resolver operations that you want to allow the account to use.
 */
public suspend inline fun Route53ResolverClient.getResolverRulePolicy(crossinline block: GetResolverRulePolicyRequest.Builder.() -> Unit): GetResolverRulePolicyResponse = getResolverRulePolicy(GetResolverRulePolicyRequest.Builder().apply(block).build())

/**
 * Imports domain names from a file into a domain list, for use in a DNS firewall rule group.
 *
 * Each domain specification in your domain list must satisfy the following requirements:
 * + It can optionally start with `*` (asterisk).
 * + With the exception of the optional starting asterisk, it must only contain the following characters: `A-Z`, `a-z`, `0-9`, `-` (hyphen).
 * + It must be from 1-255 characters in length.
 */
public suspend inline fun Route53ResolverClient.importFirewallDomains(crossinline block: ImportFirewallDomainsRequest.Builder.() -> Unit): ImportFirewallDomainsResponse = importFirewallDomains(ImportFirewallDomainsRequest.Builder().apply(block).build())

/**
 * Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage firewall behavior for your VPCs.
 *
 * A single call might return only a partial list of the configurations. For information, see `MaxResults`.
 */
public suspend inline fun Route53ResolverClient.listFirewallConfigs(crossinline block: ListFirewallConfigsRequest.Builder.() -> Unit): ListFirewallConfigsResponse = listFirewallConfigs(ListFirewallConfigsRequest.Builder().apply(block).build())

/**
 * Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the domains that are defined for a list by calling ListFirewallDomains.
 *
 * A single call to this list operation might return only a partial list of the domain lists. For information, see `MaxResults`.
 */
public suspend inline fun Route53ResolverClient.listFirewallDomainLists(crossinline block: ListFirewallDomainListsRequest.Builder.() -> Unit): ListFirewallDomainListsResponse = listFirewallDomainLists(ListFirewallDomainListsRequest.Builder().apply(block).build())

/**
 * Retrieves the domains that you have defined for the specified firewall domain list.
 *
 * A single call might return only a partial list of the domains. For information, see `MaxResults`.
 */
public suspend inline fun Route53ResolverClient.listFirewallDomains(crossinline block: ListFirewallDomainsRequest.Builder.() -> Unit): ListFirewallDomainsResponse = listFirewallDomains(ListFirewallDomainsRequest.Builder().apply(block).build())

/**
 * Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for a VPC with one rule group.
 *
 * A single call might return only a partial list of the associations. For information, see `MaxResults`.
 */
public suspend inline fun Route53ResolverClient.listFirewallRuleGroupAssociations(crossinline block: ListFirewallRuleGroupAssociationsRequest.Builder.() -> Unit): ListFirewallRuleGroupAssociationsResponse = listFirewallRuleGroupAssociations(ListFirewallRuleGroupAssociationsRequest.Builder().apply(block).build())

/**
 * Retrieves the minimal high-level information for the rule groups that you have defined.
 *
 * A single call might return only a partial list of the rule groups. For information, see `MaxResults`.
 */
public suspend inline fun Route53ResolverClient.listFirewallRuleGroups(crossinline block: ListFirewallRuleGroupsRequest.Builder.() -> Unit): ListFirewallRuleGroupsResponse = listFirewallRuleGroups(ListFirewallRuleGroupsRequest.Builder().apply(block).build())

/**
 * Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the rules in a rule group to filter DNS network traffic for a VPC.
 *
 * A single call might return only a partial list of the rules. For information, see `MaxResults`.
 */
public suspend inline fun Route53ResolverClient.listFirewallRules(crossinline block: ListFirewallRulesRequest.Builder.() -> Unit): ListFirewallRulesResponse = listFirewallRules(ListFirewallRulesRequest.Builder().apply(block).build())

/**
 * Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the configurations to manage DNS resolution behavior for your VPCs.
 */
public suspend inline fun Route53ResolverClient.listResolverConfigs(crossinline block: ListResolverConfigsRequest.Builder.() -> Unit): ListResolverConfigsResponse = listResolverConfigs(ListResolverConfigsRequest.Builder().apply(block).build())

/**
 * Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.
 */
public suspend inline fun Route53ResolverClient.listResolverDnssecConfigs(crossinline block: ListResolverDnssecConfigsRequest.Builder.() -> Unit): ListResolverDnssecConfigsResponse = listResolverDnssecConfigs(ListResolverDnssecConfigsRequest.Builder().apply(block).build())

/**
 * Gets the IP addresses for a specified Resolver endpoint.
 */
public suspend inline fun Route53ResolverClient.listResolverEndpointIpAddresses(crossinline block: ListResolverEndpointIpAddressesRequest.Builder.() -> Unit): ListResolverEndpointIpAddressesResponse = listResolverEndpointIpAddresses(ListResolverEndpointIpAddressesRequest.Builder().apply(block).build())

/**
 * Lists all the Resolver endpoints that were created using the current Amazon Web Services account.
 */
public suspend inline fun Route53ResolverClient.listResolverEndpoints(crossinline block: ListResolverEndpointsRequest.Builder.() -> Unit): ListResolverEndpointsResponse = listResolverEndpoints(ListResolverEndpointsRequest.Builder().apply(block).build())

/**
 * Lists information about associations between Amazon VPCs and query logging configurations.
 */
public suspend inline fun Route53ResolverClient.listResolverQueryLogConfigAssociations(crossinline block: ListResolverQueryLogConfigAssociationsRequest.Builder.() -> Unit): ListResolverQueryLogConfigAssociationsResponse = listResolverQueryLogConfigAssociations(ListResolverQueryLogConfigAssociationsRequest.Builder().apply(block).build())

/**
 * Lists information about the specified query logging configurations. Each configuration defines where you want Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
 */
public suspend inline fun Route53ResolverClient.listResolverQueryLogConfigs(crossinline block: ListResolverQueryLogConfigsRequest.Builder.() -> Unit): ListResolverQueryLogConfigsResponse = listResolverQueryLogConfigs(ListResolverQueryLogConfigsRequest.Builder().apply(block).build())

/**
 * Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services account.
 */
public suspend inline fun Route53ResolverClient.listResolverRuleAssociations(crossinline block: ListResolverRuleAssociationsRequest.Builder.() -> Unit): ListResolverRuleAssociationsResponse = listResolverRuleAssociations(ListResolverRuleAssociationsRequest.Builder().apply(block).build())

/**
 * Lists the Resolver rules that were created using the current Amazon Web Services account.
 */
public suspend inline fun Route53ResolverClient.listResolverRules(crossinline block: ListResolverRulesRequest.Builder.() -> Unit): ListResolverRulesResponse = listResolverRules(ListResolverRulesRequest.Builder().apply(block).build())

/**
 * Lists the tags that you associated with the specified resource.
 */
public suspend inline fun Route53ResolverClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Attaches an Identity and Access Management (Amazon Web Services IAM) policy for sharing the rule group. You can use the policy to share the rule group using Resource Access Manager (RAM).
 */
public suspend inline fun Route53ResolverClient.putFirewallRuleGroupPolicy(crossinline block: PutFirewallRuleGroupPolicyRequest.Builder.() -> Unit): PutFirewallRuleGroupPolicyResponse = putFirewallRuleGroupPolicy(PutFirewallRuleGroupPolicyRequest.Builder().apply(block).build())

/**
 * Specifies an Amazon Web Services account that you want to share a query logging configuration with, the query logging configuration that you want to share, and the operations that you want the account to be able to perform on the configuration.
 */
public suspend inline fun Route53ResolverClient.putResolverQueryLogConfigPolicy(crossinline block: PutResolverQueryLogConfigPolicyRequest.Builder.() -> Unit): PutResolverQueryLogConfigPolicyResponse = putResolverQueryLogConfigPolicy(PutResolverQueryLogConfigPolicyRequest.Builder().apply(block).build())

/**
 * Specifies an Amazon Web Services rule that you want to share with another account, the account that you want to share the rule with, and the operations that you want the account to be able to perform on the rule.
 */
public suspend inline fun Route53ResolverClient.putResolverRulePolicy(crossinline block: PutResolverRulePolicyRequest.Builder.() -> Unit): PutResolverRulePolicyResponse = putResolverRulePolicy(PutResolverRulePolicyRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to a specified resource.
 */
public suspend inline fun Route53ResolverClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from a specified resource.
 */
public suspend inline fun Route53ResolverClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
 */
public suspend inline fun Route53ResolverClient.updateFirewallConfig(crossinline block: UpdateFirewallConfigRequest.Builder.() -> Unit): UpdateFirewallConfigResponse = updateFirewallConfig(UpdateFirewallConfigRequest.Builder().apply(block).build())

/**
 * Updates the firewall domain list from an array of domain specifications.
 */
public suspend inline fun Route53ResolverClient.updateFirewallDomains(crossinline block: UpdateFirewallDomainsRequest.Builder.() -> Unit): UpdateFirewallDomainsResponse = updateFirewallDomains(UpdateFirewallDomainsRequest.Builder().apply(block).build())

/**
 * Updates the specified firewall rule.
 */
public suspend inline fun Route53ResolverClient.updateFirewallRule(crossinline block: UpdateFirewallRuleRequest.Builder.() -> Unit): UpdateFirewallRuleResponse = updateFirewallRule(UpdateFirewallRuleRequest.Builder().apply(block).build())

/**
 * Changes the association of a FirewallRuleGroup with a VPC. The association enables DNS filtering for the VPC.
 */
public suspend inline fun Route53ResolverClient.updateFirewallRuleGroupAssociation(crossinline block: UpdateFirewallRuleGroupAssociationRequest.Builder.() -> Unit): UpdateFirewallRuleGroupAssociationResponse = updateFirewallRuleGroupAssociation(UpdateFirewallRuleGroupAssociationRequest.Builder().apply(block).build())

/**
 * Updates the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.
 */
public suspend inline fun Route53ResolverClient.updateResolverConfig(crossinline block: UpdateResolverConfigRequest.Builder.() -> Unit): UpdateResolverConfigResponse = updateResolverConfig(UpdateResolverConfigRequest.Builder().apply(block).build())

/**
 * Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one is created.
 */
public suspend inline fun Route53ResolverClient.updateResolverDnssecConfig(crossinline block: UpdateResolverDnssecConfigRequest.Builder.() -> Unit): UpdateResolverDnssecConfigResponse = updateResolverDnssecConfig(UpdateResolverDnssecConfigRequest.Builder().apply(block).build())

/**
 * Updates the name, or enpoint type for an inbound or an outbound Resolver endpoint. You can only update between IPV4 and DUALSTACK, IPV6 endpoint type can't be updated to other type.
 */
public suspend inline fun Route53ResolverClient.updateResolverEndpoint(crossinline block: UpdateResolverEndpointRequest.Builder.() -> Unit): UpdateResolverEndpointResponse = updateResolverEndpoint(UpdateResolverEndpointRequest.Builder().apply(block).build())

/**
 * Updates settings for a specified Resolver rule. `ResolverRuleId` is required, and all other parameters are optional. If you don't specify a parameter, it retains its current value.
 */
public suspend inline fun Route53ResolverClient.updateResolverRule(crossinline block: UpdateResolverRuleRequest.Builder.() -> Unit): UpdateResolverRuleResponse = updateResolverRule(UpdateResolverRuleRequest.Builder().apply(block).build())
